#! usr/bin/python3.9
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-09-25 14:34:21.593357

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""
from pycatia.cat_sch_platform_interfaces.sch_grr import SchGRR
from pycatia.cat_sch_platform_interfaces.sch_list_of_doubles import SchListOfDoubles
from pycatia.system_interfaces.any_object import AnyObject


class SchCntrLocation(AnyObject):
    """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.AnyObject
                |                     SchCntrLocation
                | 
                | Manage the location of a schematic connector.
    
    """

    def __init__(self, com_object):
        super().__init__(com_object)
        self.sch_cntr_location = com_object

    def get_align_vector(self, i_grr: SchGRR, o_db2_align_vector: SchListOfDoubles) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub GetAlignVector(SchGRR iGRR,
                | SchListOfDoubles oDb2AlignVector)
                | 
                |     Get the current alignment vector of the connector.
                | 
                |     Parameters:
                | 
                |         iGRR
                |             Pointer to the graphical primitive or the graphical image or the
                |             graphical primitives of the owner of the connector.
                |             
                |         oDb2AlignVector
                |             X-Y component of the current alignment vector of the connector.
                |             
                |     Example:
                |
                |          Dim objThisIntf As SchCntrLocation
                |          Dim objArg1 As SchGRR
                |          Dim objArg2 As SchListOfDoubles
                |           ...
                |          objThisIntf.GetAlignVectorobjArg1,objArg2

        :param SchGRR i_grr:
        :param SchListOfDoubles o_db2_align_vector:
        :rtype: None
        """
        return self.sch_cntr_location.GetAlignVector(i_grr.com_object, o_db2_align_vector.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'get_align_vector'
        # # vba_code = """
        # # Public Function get_align_vector(sch_cntr_location)
        # #     Dim iGRR (2)
        # #     sch_cntr_location.GetAlignVector iGRR
        # #     get_align_vector = iGRR
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def get_position(self, i_grr: SchGRR, o_db2_position: SchListOfDoubles) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub GetPosition(SchGRR iGRR,
                | SchListOfDoubles oDb2Position)
                | 
                |     Get the current position of the connector in absolute
                |     coordinates.
                | 
                |     Parameters:
                | 
                |         iGRR
                |             Pointer to the graphical primitive or the graphical image or the
                |             graphical primitives of the owner of the connector.
                |             
                |         oDb2Position
                |             Absolute X-Y coordinates of the current position of the connector.
                |
                |     Example:
                |
                |          Dim objThisIntf As SchCntrLocation
                |          Dim objArg1 As SchGRR
                |          Dim objArg2 As SchListOfDoubles
                |           ...
                |          objThisIntf.GetPositionobjArg1,objArg2

        :param SchGRR i_grr:
        :param SchListOfDoubles o_db2_position:
        :rtype: None
        """
        return self.sch_cntr_location.GetPosition(i_grr.com_object, o_db2_position.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'get_position'
        # # vba_code = """
        # # Public Function get_position(sch_cntr_location)
        # #     Dim iGRR (2)
        # #     sch_cntr_location.GetPosition iGRR
        # #     get_position = iGRR
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def get_relative_position(self, o_db2_relative_position: SchListOfDoubles) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub GetRelativePosition(SchListOfDoubles
                | oDb2RelativePosition)
                | 
                |     Get the current position of the connector in relative
                |     coordinates.
                | 
                |     Parameters:
                | 
                |         oDb2RelativePosition
                |             relative X-Y coordinates of the current position of the connector.
                |             
                | 
                |     Example:
                | 
                |           
                | 
                |          Dim objThisIntf As SchCntrLocation
                |          Dim objArg1 As SchListOfDoubles
                |           ...
                |          objThisIntf.GetRelativePositionobjArg1

        :param SchListOfDoubles o_db2_relative_position:
        :rtype: None
        """
        return self.sch_cntr_location.GetRelativePosition(o_db2_relative_position.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'get_relative_position'
        # # vba_code = """
        # # Public Function get_relative_position(sch_cntr_location)
        # #     Dim oDb2RelativePosition (2)
        # #     sch_cntr_location.GetRelativePosition oDb2RelativePosition
        # #     get_relative_position = oDb2RelativePosition
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def set_align_vector(self, i_grr: SchGRR, i_db2_align_vector: tuple) -> tuple:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub SetAlignVector(SchGRR iGRR,
                | CATSafeArrayVariant iDb2AlignVector)
                | 
                |     Set the current alignment vector of the connector.
                | 
                |     Parameters:
                | 
                |         iGRR
                |             Pointer to the graphical primitive or the graphical image or the
                |             graphical primitives of the owner of the connector.
                |             
                |         iDb2AlignVector
                |             X-Y component of the current alignment vector of the connector to
                |             be set. 
                | 
                |     Example:
                |
                |          Dim objThisIntf As SchCntrLocation
                |          Dim objArg1 As SchGRR
                |          Dim dbVar2(2) As CATSafeArrayVariant
                |           ...
                |          objThisIntf.SetAlignVectorobjArg1,dbVar2

        :param SchGRR i_grr:
        :param tuple i_db2_align_vector:
        :rtype: tuple
        """
        return self.sch_cntr_location.SetAlignVector(i_grr.com_object, i_db2_align_vector)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'set_align_vector'
        # # vba_code = """
        # # Public Function set_align_vector(sch_cntr_location)
        # #     Dim iGRR (2)
        # #     sch_cntr_location.SetAlignVector iGRR
        # #     set_align_vector = iGRR
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def set_position(self, i_grr: SchGRR, i_db2_position: tuple) -> tuple:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub SetPosition(SchGRR iGRR,
                | CATSafeArrayVariant iDb2Position)
                | 
                |     Set the current position of the connector in absolute coordinates. All
                |     connectors on multi-images are affected because the relative position on
                |     connect will be changed accordingly.
                | 
                |     Parameters:
                | 
                |         iGRR
                |             Pointer to the graphical primitive or the graphical image or the
                |             graphical primitives of the owner of the connector..
                |             
                |         iDb2Position
                |             absolute X-Y coordinates of the current position of the connector
                |             to be set. 
                | 
                |     Example:
                |
                |          Dim objThisIntf As SchCntrLocation
                |          Dim objArg1 As SchGRR
                |          Dim dbVar2(2) As CATSafeArrayVariant
                |           ...
                |          objThisIntf.SetPositionobjArg1,dbVar2

        :param SchGRR i_grr:
        :param tuple i_db2_position:
        :rtype: tuple
        """
        return self.sch_cntr_location.SetPosition(i_grr.com_object, i_db2_position)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'set_position'
        # # vba_code = """
        # # Public Function set_position(sch_cntr_location)
        # #     Dim iGRR (2)
        # #     sch_cntr_location.SetPosition iGRR
        # #     set_position = iGRR
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def set_relative_position(self, i_db2_relative_position: tuple) -> tuple:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub SetRelativePosition(CATSafeArrayVariant
                | iDb2RelativePosition)
                | 
                |     Set the current position of the connector in absolute
                |     coordinates.
                | 
                |     Parameters:
                | 
                |         iDb2RelativePosition
                |             relative X-Y coordinates of the current position of the connector
                |             to be set. 
                | 
                |     Example:
                |
                |          Dim objThisIntf As SchCntrLocation
                |          Dim dbVar1(2) As CATSafeArrayVariant
                |           ...
                |          objThisIntf.SetRelativePositiondbVar1

        :param tuple i_db2_relative_position:
        :rtype: tuple
        """
        return self.sch_cntr_location.SetRelativePosition(i_db2_relative_position)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'set_relative_position'
        # # vba_code = """
        # # Public Function set_relative_position(sch_cntr_location)
        # #     Dim iDb2RelativePosition (2)
        # #     sch_cntr_location.SetRelativePosition iDb2RelativePosition
        # #     set_relative_position = iDb2RelativePosition
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def __repr__(self):
        return f'SchCntrLocation(name="{self.name}")'
