#! usr/bin/python3.9
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-09-25 14:34:21.593357

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""
from pycatia.cat_sch_platform_interfaces.sch_list_of_objects import SchListOfObjects
from pycatia.system_interfaces.any_object import AnyObject


class SchGapDisplay(AnyObject):
    """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.AnyObject
                |                     SchGapDisplay
                | 
                | Manage the graphical representation of a schematic route.
    
    """

    def __init__(self, com_object):
        super().__init__(com_object)
        self.sch_gap_display = com_object

    def is_gap_shown(self, o_b_yes: bool) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub IsGapShown(boolean oBYes)
                | 
                |     Query whether gaps are shown (gap attributes exist).
                | 
                |     Parameters:
                | 
                |         oBYes
                |             If TRUE, then gaps are shown (gap attributes exist). If FALSE, then
                |             gaps are not shown (gap attributes do not exist). 
                | 
                |     Example:
                |
                |          Dim objThisIntf As SchGapDisplay
                |          Dim bVar1 As boolean
                |           ...
                |          objThisIntf.IsGapShownbVar1

        :param bool o_b_yes:
        :rtype: None
        """
        return self.sch_gap_display.IsGapShown(o_b_yes)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'is_gap_shown'
        # # vba_code = """
        # # Public Function is_gap_shown(sch_gap_display)
        # #     Dim oBYes (2)
        # #     sch_gap_display.IsGapShown oBYes
        # #     is_gap_shown = oBYes
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def set_gap(self, i_luk_routes: SchListOfObjects) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub SetGap(SchListOfObjects iLUKRoutes)
                | 
                |     Add gap display attributes on the route.
                | 
                |     Parameters:
                | 
                |         iLUKRoutes
                |             A list of routes to be processed, default is NULL (if NULL, then
                |             all routes in model are processed). Members are CATISchRoute interface
                |             pointers. 
                | 
                |     Example:
                | 
                |           
                | 
                |          Dim objThisIntf As SchGapDisplay
                |          Dim objArg1 As SchListOfObjects
                |           ...
                |          objThisIntf.SetGapobjArg1

        :param SchListOfObjects i_luk_routes:
        :rtype: None
        """
        return self.sch_gap_display.SetGap(i_luk_routes.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'set_gap'
        # # vba_code = """
        # # Public Function set_gap(sch_gap_display)
        # #     Dim iLUKRoutes (2)
        # #     sch_gap_display.SetGap iLUKRoutes
        # #     set_gap = iLUKRoutes
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def unset_gap(self, i_luk_routes: SchListOfObjects) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub UnsetGap(SchListOfObjects iLUKRoutes)
                | 
                |     Remove gap display attributes on the route. A list of routes to be
                |     processed, default is NULL (if NULL, then all routes in model are processed).
                |     Members are CATISchRoute interface pointers.
                | 
                |     Example:
                |
                |          Dim objThisIntf As SchGapDisplay
                |          Dim objArg1 As SchListOfObjects
                |           ...
                |          objThisIntf.UnsetGapobjArg1

        :param SchListOfObjects i_luk_routes:
        :rtype: None
        """
        return self.sch_gap_display.UnsetGap(i_luk_routes.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'unset_gap'
        # # vba_code = """
        # # Public Function unset_gap(sch_gap_display)
        # #     Dim iLUKRoutes (2)
        # #     sch_gap_display.UnsetGap iLUKRoutes
        # #     unset_gap = iLUKRoutes
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def __repr__(self):
        return f'SchGapDisplay(name="{self.name}")'
