#! usr/bin/python3.9
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-09-25 14:34:21.593357

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""
from pycatia.cat_sch_platform_interfaces.sch_list_of_doubles import SchListOfDoubles
from pycatia.system_interfaces.any_object import AnyObject


class SchGRRComp(AnyObject):
    """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.AnyObject
                |                     SchGRRComp
                | 
                | Manage the graphical representation of a schematic component.
    
    """

    def __init__(self, com_object):
        super().__init__(com_object)
        self.sch_grr_comp = com_object

    def get_position(self, o_db2_position: SchListOfDoubles) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub GetPosition(SchListOfDoubles oDb2Position)
                | 
                |     Get the current position of the component.
                | 
                |     Parameters:
                | 
                |         oDb2Position
                |             The current position of the component. 
                | 
                |     Example:
                |
                |          Dim objThisIntf As SchGRRComp
                |          Dim objArg1 As SchListOfDoubles
                |           ...
                |          objThisIntf.GetPositionobjArg1

        :param SchListOfDoubles o_db2_position:
        :rtype: None
        """
        return self.sch_grr_comp.GetPosition(o_db2_position.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'get_position'
        # # vba_code = """
        # # Public Function get_position(sch_grr_comp)
        # #     Dim oDb2Position (2)
        # #     sch_grr_comp.GetPosition oDb2Position
        # #     get_position = oDb2Position
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def get_rotation_angle(self, o_db1_rotation_angle_in_rad: float) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub GetRotationAngle(double oDb1RotationAngleInRad)
                | 
                |     Get the current rotation angle (from x-axis in radian) of the
                |     component.
                | 
                |     Parameters:
                | 
                |         oDb1RotationAngleInRad
                |             The current angle of the component in radian. 
                | 
                |     Example:
                |
                |          Dim objThisIntf As SchGRRComp
                |          Dim dbVar As Double;
                |           ...
                |          objThisIntf.GetRotationAngledbVar

        :param float o_db1_rotation_angle_in_rad:
        :rtype: None
        """
        return self.sch_grr_comp.GetRotationAngle(o_db1_rotation_angle_in_rad)

    def get_scale(self, o_db1_scale_factor: float) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub GetScale(double oDb1ScaleFactor)
                | 
                |     Get the current scale factor of the component.
                | 
                |     Parameters:
                | 
                |         oDb1ScaleFactor
                |             The current scale factor of the component. 
                | 
                |     Example:
                |
                |          Dim objThisIntf As SchGRRComp
                |          Dim dbVar As Double;
                |           ...
                |          objThisIntf.GetScaledbVar

        :param float o_db1_scale_factor:
        :rtype: None
        """
        return self.sch_grr_comp.GetScale(o_db1_scale_factor)

    def get_transformation2_d(self, o_db6_trans_matrix: SchListOfDoubles) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub GetTransformation2D(SchListOfDoubles oDb6TransMatrix)
                | 
                |     Get the local coordinate reference frame (with respect to absolute
                |     coordinate system) of the component.
                | 
                |     Parameters:
                | 
                |         oDb6TransMatrix
                |             An double array of 6 members. Transformation matrix that defines
                |             the local coordinate reference frame of the component member 1, 2 - defines the
                |             x-axis of the local coordinate reference frame. member 3, 4 - defines the
                |             y-axis of the local coordinate reference frame. member 5, 6 - defines the
                |             origin of the local coordinate reference frame One can also interpret this as
                |             the transformation matrix that would move the component from the absolute
                |             coordinate frame to the current position and orientation. As such, the member
                |             5,6 define the translational vector Furthemore, rotation angle and scale factor
                |             can be calculated from member 1 to 4. 
                | 
                |     Example:
                |
                |          Dim objThisIntf As SchGRRComp
                |          Dim objArg1 As SchListOfDoubles
                |           ...
                |          objThisIntf.GetTransformation2DobjArg1

        :param SchListOfDoubles o_db6_trans_matrix:
        :rtype: None
        """
        return self.sch_grr_comp.GetTransformation2D(o_db6_trans_matrix.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'get_transformation2_d'
        # # vba_code = """
        # # Public Function get_transformation2_d(sch_grr_comp)
        # #     Dim oDb6TransMatrix (2)
        # #     sch_grr_comp.GetTransformation2D oDb6TransMatrix
        # #     get_transformation2_d = oDb6TransMatrix
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def set_position(self, o_db2_position: tuple) -> tuple:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub SetPosition(CATSafeArrayVariant oDb2Position)
                | 
                |     Set the current position of the component.
                | 
                |     Parameters:
                | 
                |         iDb2Position
                |             The position of the component to be set. 
                | 
                |     Example:
                |
                |          Dim objThisIntf As SchGRRComp
                |          Dim dbVar1(x) As CATSafeArrayVariant
                |           ...
                |          objThisIntf.SetPositiondbVar1

        :param tuple o_db2_position:
        :rtype: tuple
        """
        return self.sch_grr_comp.SetPosition(o_db2_position)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'set_position'
        # # vba_code = """
        # # Public Function set_position(sch_grr_comp)
        # #     Dim oDb2Position (2)
        # #     sch_grr_comp.SetPosition oDb2Position
        # #     set_position = oDb2Position
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def set_rotation_angle(self, i_db1_rotation_angle_in_rad: float) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub SetRotationAngle(double iDb1RotationAngleInRad)
                | 
                |     Set the current rotation angle (from x-axis in radian) of the
                |     component.
                | 
                |     Parameters:
                | 
                |         iDb1RotationAngleInRad
                |             The rotation angle of the component in radian to be set.
                |             
                | 
                |     Example:
                |
                |          Dim objThisIntf As SchGRRComp
                |          Dim dbVar As Double;
                |           ...
                |          objThisIntf.SetRotationAngledbVar

        :param float i_db1_rotation_angle_in_rad:
        :rtype: None
        """
        return self.sch_grr_comp.SetRotationAngle(i_db1_rotation_angle_in_rad)

    def set_scale(self, i_db1_scale_factor: float) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub SetScale(double iDb1ScaleFactor)
                | 
                |     Set the current scale factor of the component.
                | 
                |     Parameters:
                | 
                |         iDb1ScaleFactor
                |             The scale factor of the component to be set. 
                | 
                |     Example:
                |
                |          Dim objThisIntf As SchGRRComp
                |          Dim dbVar As Double;
                | 
                |           ...
                |          objThisIntf.SetScaledbVar

        :param float i_db1_scale_factor:
        :rtype: None
        """
        return self.sch_grr_comp.SetScale(i_db1_scale_factor)

    def set_transformation2_d(self, i_db6_trans_matrix: tuple) -> tuple:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub SetTransformation2D(CATSafeArrayVariant
                | iDb6TransMatrix)
                | 
                |     Set the local coordinate reference frame (with respect to absolute
                |     coordinate system) of the component.
                | 
                |     Parameters:
                | 
                |         iDb6TransMatrix
                |             Transformation matrix to be set. See 
                | 
                |         GetTransformation2D for explanation of this argument. 
                |     Example:
                |
                |          Dim objThisIntf As SchGRRComp
                |          Dim dbVar1(6) As CATSafeArrayVariant
                |           ...
                |          objThisIntf.SetTransformation2DdbVar1

        :param tuple i_db6_trans_matrix:
        :rtype: tuple
        """
        return self.sch_grr_comp.SetTransformation2D(i_db6_trans_matrix)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'set_transformation2_d'
        # # vba_code = """
        # # Public Function set_transformation2_d(sch_grr_comp)
        # #     Dim iDb6TransMatrix (2)
        # #     sch_grr_comp.SetTransformation2D iDb6TransMatrix
        # #     set_transformation2_d = iDb6TransMatrix
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def __repr__(self):
        return f'SchGRRComp(name="{self.name}")'
