#! usr/bin/python3.9
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-09-25 14:34:21.593357

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""
from pycatia.cat_sch_platform_interfaces.sch_list_of_objects import SchListOfObjects
from pycatia.system_interfaces.any_object import AnyObject


class SchObsoleteModel(AnyObject):
    """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.AnyObject
                |                     SchObsoleteModel
                | 
                | Manage obsolete model elements.
    
    """

    def __init__(self, com_object):
        super().__init__(com_object)
        self.sch_obsolete_model = com_object

    def find_obsolete_classes(self) -> SchListOfObjects:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Func FindObsoleteClasses() As SchListOfObjects
                | 
                |     Find obsolete base classes. This method will internally call
                |     CATISchAppObsoleteClass to ask the application for the names of the obsolete
                |     classes.
                | 
                |     Parameters:
                | 
                |         oListObsoleteObj
                |             A list of objects with obsoleted base class types.
                |             
                | 
                |     Example:
                |
                |          Dim objThisIntf As SchObsoleteModel
                |          Dim objArg1 As SchListOfObjects
                |           ...
                |          Set objArg1 = objThisIntf.FindObsoleteClasses

        :rtype: SchListOfObjects
        """
        return SchListOfObjects(self.sch_obsolete_model.FindObsoleteClasses())

    def has_obsolete_class(self, o_b_yes: bool) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub HasObsoleteClass(boolean oBYes)
                | 
                |     Is there any obsolete class in the application model.
                | 
                |     Parameters:
                | 
                |         oBYes
                |             If yes, then there is. 
                | 
                |     Example:
                |
                |          Dim objThisIntf As SchObsoleteModel
                |          Dim bVar1 As boolean
                |           ...
                |          objThisIntf.HasObsoleteClassbVar1

        :param bool o_b_yes:
        :rtype: None
        """
        return self.sch_obsolete_model.HasObsoleteClass(o_b_yes)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'has_obsolete_class'
        # # vba_code = """
        # # Public Function has_obsolete_class(sch_obsolete_model)
        # #     Dim oBYes (2)
        # #     sch_obsolete_model.HasObsoleteClass oBYes
        # #     has_obsolete_class = oBYes
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def __repr__(self):
        return f'SchObsoleteModel(name="{self.name}")'
