#! usr/bin/python3.9
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-09-25 14:34:21.593357

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""
from pycatia.cat_sch_platform_interfaces.sch_app_connection import SchAppConnection
from pycatia.cat_sch_platform_interfaces.sch_app_connector import SchAppConnector
from pycatia.cat_sch_platform_interfaces.sch_grr_route import SchGRRRoute
from pycatia.cat_sch_platform_interfaces.sch_list_of_doubles import SchListOfDoubles
from pycatia.system_interfaces.any_object import AnyObject


class SchRoute(AnyObject):
    """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.AnyObject
                |                     SchRoute
                | 
                | Manage a schematic route data.
    
    """

    def __init__(self, com_object):
        super().__init__(com_object)
        self.sch_route = com_object

    def add_points(self, i_grr: SchGRRRoute, i_l_db2_pt_path_to_add: tuple, i_after_which_pt_num: int) -> tuple:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub AddPoints(SchGRRRoute iGRR,
                | CATSafeArrayVariant iLDb2PtPathToAdd,
                | long iAfterWhichPtNum)
                | 
                |     Add a list of point to a route. Modify the route according to the route
                |     mode
                | 
                |     Parameters:
                | 
                |         iGRR
                |             graphical primitive of the route to add points to (if NULL, assume
                |             there is only one graphical primitive) 
                |         iLDbPtPathToAdd
                |             A list of X-Y coordinates of points to be added. 2 doubles per
                |             point. 
                |         iAfterWhichPtNum
                |             The point number to add the points after. Use 0 to indicate adding
                |             before the first point. 
                | 
                |     Example:
                |
                |          Dim objThisIntf As SchRoute
                |          Dim objArg1 As SchGRRRoute
                |          Dim dbVar2(x) As CATSafeArrayVariant
                |          Dim intVar4 As Integer
                |           ...
                |          objThisIntf.AddPointsobjArg1,dbVar2,intVar4

        :param SchGRRRoute i_grr:
        :param tuple i_l_db2_pt_path_to_add:
        :param int i_after_which_pt_num:
        :rtype: tuple
        """
        return self.sch_route.AddPoints(i_grr.com_object, i_l_db2_pt_path_to_add, i_after_which_pt_num)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'add_points'
        # # vba_code = """
        # # Public Function add_points(sch_route)
        # #     Dim iGRR (2)
        # #     sch_route.AddPoints iGRR
        # #     add_points = iGRR
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def branch(
            self,
            i_grr_main: SchGRRRoute,
            i_sch_branch_route: 'SchRoute',
            i_sch_branch_route_cntr: SchAppConnector,
            o_branch_cntn: SchAppConnection,
            o_new_branch_cntr: SchAppConnector
    ) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub Branch(SchGRRRoute iGRRMain,
                | SchRoute iSchBranchRoute,
                | SchAppConnector iSchBranchRouteCntr,
                | SchAppConnection oBranchCntn,
                | SchAppConnector oNewBranchCntr)
                | 
                |     Create a branch from this route.
                | 
                |     Parameters:
                | 
                |         iGRRMain
                |             graphical primitive of the "this" route to branch from (if NULL,
                |             assume there is only one graphical primitive) 
                |         iSchBranchRoute
                |             The route to create a branch connection to (from this route)
                |             
                |         iSchBranchRouteCntr
                |             The extremity connector of the branch 
                |         oBranchCntn
                |             The branch connection created 
                |         oNewBranchCntr
                |             The new branch connector created on "this" route 
                | 
                |     Example:
                |
                |          Dim objThisIntf As SchRoute
                |          Dim objArg1 As SchGRRRoute
                |          Dim objArg2 As SchRoute
                |          Dim objArg3 As SchAppConnector
                |          Dim objArg4 As SchAppConnection
                |          Dim objArg5 As SchAppConnector
                |           ...
                |          objThisIntf.BranchobjArg1,objArg2,objArg3,objArg4,objArg5

        :param SchGRRRoute i_grr_main:
        :param SchRoute i_sch_branch_route:
        :param SchAppConnector i_sch_branch_route_cntr:
        :param SchAppConnection o_branch_cntn:
        :param SchAppConnector o_new_branch_cntr:
        :rtype: None
        """
        return self.sch_route.Branch(
            i_grr_main.com_object,
            i_sch_branch_route.com_object,
            i_sch_branch_route_cntr.com_object,
            o_branch_cntn.com_object,
            o_new_branch_cntr.com_object
        )
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'branch'
        # # vba_code = """
        # # Public Function branch(sch_route)
        # #     Dim iGRRMain (2)
        # #     sch_route.Branch iGRRMain
        # #     branch = iGRRMain
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def break_(
            self,
            i_grr: SchGRRRoute,
            i_db2_pt1: tuple,
            i_db2_pt2: tuple,
            o_new_sch_route: 'SchRoute'
    ) -> tuple:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub Break(SchGRRRoute iGRR,
                | CATSafeArrayVariant iDb2Pt1,
                | CATSafeArrayVariant iDb2Pt2,
                | SchRoute oNewSchRoute)
                | 
                |     Break a route into 2 pieces. The old route is shortened and a new route is
                |     created.
                | 
                |     Parameters:
                | 
                |         iGRR
                |             graphical primitive of the route to be broken (if NULL, assume
                |             there is only one graphical primitive) 
                |         iDb2Pt1
                |             X-Y coordinates of point 1 to break the route at (this point is
                |             mandatory). 
                |         iDb2Pt2
                |             X-Y coordinates of point 2 to break the route at (this point is
                |             optional). If provided the points in between point 1 and this point will be
                |             eliminated. Point 1 is the last point of the shortened old route and point 2 is
                |             the first point of the new route. If this point is not provided (sends in a
                |             NULL). point 1 and point 2 are the same. 
                |         oNewSchRoute
                |             The new Schematic route object 
                | 
                |     Example:
                |
                |          Dim objThisIntf As SchRoute
                |          Dim objArg1 As SchGRRRoute
                |          Dim dbVar2(2) As CATSafeArrayVariant
                |          Dim dbVar3(2) As CATSafeArrayVariant
                |          Dim objArg4 As SchRoute
                |           ...
                |          objThisIntf.BreakobjArg1,dbVar2,dbVar3,objArg4

        :param SchGRRRoute i_grr:
        :param tuple i_db2_pt1:
        :param tuple i_db2_pt2:
        :param SchRoute o_new_sch_route:
        :rtype: tuple
        """
        return self.sch_route.Break(i_grr.com_object, i_db2_pt1, i_db2_pt2, o_new_sch_route.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'break'
        # # vba_code = """
        # # Public Function break(sch_route)
        # #     Dim iGRR (2)
        # #     sch_route.Break iGRR
        # #     break = iGRR
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def compress(self) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub Compress()
                | 
                |     Compress a the defining points of a route, removing coincident
                |     points.
                | 
                |     Example:
                |
                |          Dim objThisIntf As SchRoute
                |           ...
                |          objThisIntf.Compress

        :rtype: None
        """
        return self.sch_route.Compress()

    def concatenate(
            self,
            i_sch_route1_cntr: SchAppConnector,
            i_sch_route2: 'SchRoute',
            i_sch_route2_cntr: SchAppConnector
    ) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub Concatenate(SchAppConnector iSchRoute1Cntr,
                | SchRoute iSchRoute2,
                | SchAppConnector iSchRoute2Cntr)
                | 
                |     Concatenate 2 routes into one. Only works for those that have only one line
                |     graphic object. The first route is elongated and is modified. The second route
                |     is deleted.
                | 
                |     Parameters:
                | 
                |         iSchRoute1Cntr
                |             Connector of this route to concatenate with the second route.
                |             
                |         iSchRoute2
                |             Second route to be concatenate to the first. iSchRoute2 will be
                |             deleted. 
                |         iSchRoute2Cntr
                |             Connector of second route to concatenate with the first route.
                |
                |     Example:
                |
                |          Dim objThisIntf As SchRoute
                |          Dim objArg1 As SchAppConnector
                |          Dim objArg2 As SchRoute
                |          Dim objArg3 As SchAppConnector
                |           ...
                |          objThisIntf.ConcatenateobjArg1,objArg2,objArg3

        :param SchAppConnector i_sch_route1_cntr:
        :param SchRoute i_sch_route2:
        :param SchAppConnector i_sch_route2_cntr:
        :rtype: None
        """
        return self.sch_route.Concatenate(
            i_sch_route1_cntr.com_object,
            i_sch_route2.com_object,
            i_sch_route2_cntr.com_object
        )
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'concatenate'
        # # vba_code = """
        # # Public Function concatenate(sch_route)
        # #     Dim iSchRoute1Cntr (2)
        # #     sch_route.Concatenate iSchRoute1Cntr
        # #     concatenate = iSchRoute1Cntr
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def concatenate_keep_route2(
            self,
            i_sch_route1_cntr: SchAppConnector,
            i_sch_route2: 'SchRoute',
            i_sch_route2_cntr: SchAppConnector
    ) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub ConcatenateKeepRoute2(SchAppConnector iSchRoute1Cntr,
                | SchRoute iSchRoute2,
                | SchAppConnector iSchRoute2Cntr)
                | 
                |     Concatenate 2 routes into one. Only works for those that have only one line
                |     graphic object. The first route is elongated and is modified. The second route
                |     is unchanged.
                | 
                |     Parameters:
                | 
                |         iSchRoute1Cntr
                |             Connector of this route to concatenate with the second route.
                |             
                |         iSchRoute2
                |             Second route to be concatenate to the first. iSchRoute2 will be
                |             unchanged. 
                |         iSchRoute2Cntr
                |             Connector of second route to concatenate with the first route.
                |
                |     Example:
                |
                |          Dim objThisIntf As SchRoute
                |          Dim objArg1 As SchAppConnector
                |          Dim objArg2 As SchRoute
                |          Dim objArg3 As SchAppConnector
                |           ...
                |          objThisIntf.ConcatenateKeepRoute2objArg1,objArg2,objArg3

        :param SchAppConnector i_sch_route1_cntr:
        :param SchRoute i_sch_route2:
        :param SchAppConnector i_sch_route2_cntr:
        :rtype: None
        """
        return self.sch_route.ConcatenateKeepRoute2(
            i_sch_route1_cntr.com_object,
            i_sch_route2.com_object,
            i_sch_route2_cntr.com_object
        )
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'concatenate_keep_route2'
        # # vba_code = """
        # # Public Function concatenate_keep_route2(sch_route)
        # #     Dim iSchRoute1Cntr (2)
        # #     sch_route.ConcatenateKeepRoute2 iSchRoute1Cntr
        # #     concatenate_keep_route2 = iSchRoute1Cntr
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def get_extremity_cntrs(
            self,
            i_grr: SchGRRRoute,
            o_route_cntr1: SchAppConnector,
            o_route_cntr2: SchAppConnector
    ) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub GetExtremityCntrs(SchGRRRoute iGRR,
                | SchAppConnector oRouteCntr1,
                | SchAppConnector oRouteCntr2)
                | 
                |     Get extremity connectors of the route.
                | 
                |     Parameters:
                | 
                |         iGRR
                |             graphical primitive of the route to query. (if NULL, assume there
                |             is only one graphical primitive) 
                |         oRouteCntr1
                |             Route connector at first extremity 
                |         oRouteCntr2
                |             Route connector at second extremity 
                | 
                |     Example:
                |
                |          Dim objThisIntf As SchRoute
                |          Dim objArg1 As SchGRRRoute
                |          Dim objArg2 As SchAppConnector
                |          Dim objArg3 As SchAppConnector
                |           ...
                |          objThisIntf.GetExtremityCntrsobjArg1,objArg2,objArg3

        :param SchGRRRoute i_grr:
        :param SchAppConnector o_route_cntr1:
        :param SchAppConnector o_route_cntr2:
        :rtype: None
        """
        return self.sch_route.GetExtremityCntrs(i_grr.com_object, o_route_cntr1.com_object, o_route_cntr2.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'get_extremity_cntrs'
        # # vba_code = """
        # # Public Function get_extremity_cntrs(sch_route)
        # #     Dim iGRR (2)
        # #     sch_route.GetExtremityCntrs iGRR
        # #     get_extremity_cntrs = iGRR
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def get_path(self, i_grr: SchGRRRoute, o_l_db2_pt_path: SchListOfDoubles) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub GetPath(SchGRRRoute iGRR,
                | SchListOfDoubles oLDb2PtPath)
                | 
                |     Get the defining points of a route.
                | 
                |     Parameters:
                | 
                |         iGRR
                |             graphical primitive of the route get the path from (if NULL, assume
                |             there is only one graphical primitive) 
                |         oLDbPtPath
                |             A list of X-Y coordinates of points. 2 doubles per point.
                |
                |     Example:
                |
                |          Dim objThisIntf As SchRoute
                |          Dim objArg1 As SchGRRRoute
                |          Dim objArg2 As SchListOfDoubles
                |           ...
                |          objThisIntf.GetPathobjArg1,objArg2

        :param SchGRRRoute i_grr:
        :param SchListOfDoubles o_l_db2_pt_path:
        :rtype: None
        """
        return self.sch_route.GetPath(i_grr.com_object, o_l_db2_pt_path.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'get_path'
        # # vba_code = """
        # # Public Function get_path(sch_route)
        # #     Dim iGRR (2)
        # #     sch_route.GetPath iGRR
        # #     get_path = iGRR
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def ok_to_branch(self, i_grr: SchGRRRoute, i_branch_class_type: str, o_b_yes: bool) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub OKToBranch(SchGRRRoute iGRR,
                | CATBSTR iBranchClassType,
                | boolean oBYes)
                | 
                |     Query whether it is OK to create a branch.
                | 
                |     Parameters:
                | 
                |         iGRR
                |             graphical primitive of the route to query. (if NULL, assume there
                |             is only one graphical primitive) 
                |         iBranchClassType
                |             Class type of the branch to create. 
                |         oBYes
                |             If TRUE, then it is OK to create a branch from a route
                |
                |     Example:
                |
                |          Dim objThisIntf As SchRoute
                |          Dim objArg1 As SchGRRRoute
                |          Dim strVar2 As String
                |          Dim bVar3 As boolean
                |           ...
                |          objThisIntf.OKToBranchobjArg1,strVar2,bVar3

        :param SchGRRRoute i_grr:
        :param str i_branch_class_type:
        :param bool o_b_yes:
        :rtype: None
        """
        return self.sch_route.OKToBranch(i_grr.com_object, i_branch_class_type, o_b_yes)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'ok_to_branch'
        # # vba_code = """
        # # Public Function ok_to_branch(sch_route)
        # #     Dim iGRR (2)
        # #     sch_route.OKToBranch iGRR
        # #     ok_to_branch = iGRR
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def ok_to_break(self, i_grr: SchGRRRoute, o_b_yes: bool) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub OKToBreak(SchGRRRoute iGRR,
                | boolean oBYes)
                | 
                |     Query whether it is OK to break.
                | 
                |     Parameters:
                | 
                |         iGRR
                |             graphical primitive of the route to query. (if NULL, assume there
                |             is only one graphical primitive) 
                |         oBYes
                |             If TRUE, then it is OK to break the route 
                | 
                |     Example:
                |
                |          Dim objThisIntf As SchRoute
                |          Dim objArg1 As SchGRRRoute
                |          Dim bVar2 As boolean
                |           ...
                |          objThisIntf.OKToBreakobjArg1,bVar2

        :param SchGRRRoute i_grr:
        :param bool o_b_yes:
        :rtype: None
        """
        return self.sch_route.OKToBreak(i_grr.com_object, o_b_yes)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'ok_to_break'
        # # vba_code = """
        # # Public Function ok_to_break(sch_route)
        # #     Dim iGRR (2)
        # #     sch_route.OKToBreak iGRR
        # #     ok_to_break = iGRR
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def ok_to_concatenate(self, i_grr: SchGRRRoute, o_b_yes: bool) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub OKToConcatenate(SchGRRRoute iGRR,
                | boolean oBYes)
                | 
                |     Query whether it is OK to concatenate.
                | 
                |     Parameters:
                | 
                |         iGRR
                |             graphical primitive of the route to query. (if NULL, assume there
                |             is only one graphical primitive) 
                |         oBYes
                |             If TRUE, then it is OK to concatenate the route with another
                |
                |     Example:
                |
                |          Dim objThisIntf As SchRoute
                |          Dim objArg1 As SchGRRRoute
                |          Dim bVar2 As boolean
                |           ...
                |          objThisIntf.OKToConcatenateobjArg1,bVar2

        :param SchGRRRoute i_grr:
        :param bool o_b_yes:
        :rtype: None
        """
        return self.sch_route.OKToConcatenate(i_grr.com_object, o_b_yes)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'ok_to_concatenate'
        # # vba_code = """
        # # Public Function ok_to_concatenate(sch_route)
        # #     Dim iGRR (2)
        # #     sch_route.OKToConcatenate iGRR
        # #     ok_to_concatenate = iGRR
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def ok_to_modify_points(self, i_grr: SchGRRRoute, o_b_yes: bool) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub OKToModifyPoints(SchGRRRoute iGRR,
                | boolean oBYes)
                | 
                |     Query whether it is OK to modify (add or remove) the
                |     points.
                | 
                |     Parameters:
                | 
                |         iGRR
                |             graphical primitive of the route to query. (if NULL, assume there
                |             is only one graphical primitive). 
                |         oBYes
                |             If TRUE, then it is OK to add or remove the points from the route
                |
                |     Example:
                |
                |          Dim objThisIntf As SchRoute
                |          Dim objArg1 As SchGRRRoute
                |          Dim bVar2 As boolean
                |           ...
                |          objThisIntf.OKToModifyPointsobjArg1,bVar2

        :param SchGRRRoute i_grr:
        :param bool o_b_yes:
        :rtype: None
        """
        return self.sch_route.OKToModifyPoints(i_grr.com_object, o_b_yes)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'ok_to_modify_points'
        # # vba_code = """
        # # Public Function ok_to_modify_points(sch_route)
        # #     Dim iGRR (2)
        # #     sch_route.OKToModifyPoints iGRR
        # #     ok_to_modify_points = iGRR
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def remove_points(self, i_grr: SchGRRRoute, i_num_of_pts_to_remove: int, i_after_which_pt_num: int) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub RemovePoints(SchGRRRoute iGRR,
                | long iNumOfPtsToRemove,
                | long iAfterWhichPtNum)
                | 
                |     Remove points from route. Modify the route according to the route
                |     mode.
                | 
                |     Parameters:
                | 
                |         iGRR
                |             graphical primitive of the route to remove the points from (if
                |             NULL, assume there is only one graphical primitive)
                |             
                |         iNumOfPtsToRemove
                |             The number of points to be removed 
                |         iAfterWhichPtNum
                |             The point number at which to start removing the point.
                |
                |     Example:
                |
                |          Dim objThisIntf As SchRoute
                |          Dim objArg1 As SchGRRRoute
                |          Dim intVar2 As Integer
                |          Dim intVar3 As Integer
                |           ...
                |          objThisIntf.RemovePointsobjArg1,intVar2,intVar3

        :param SchGRRRoute i_grr:
        :param int i_num_of_pts_to_remove:
        :param int i_after_which_pt_num:
        :rtype: None
        """
        return self.sch_route.RemovePoints(i_grr.com_object, i_num_of_pts_to_remove, i_after_which_pt_num)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'remove_points'
        # # vba_code = """
        # # Public Function remove_points(sch_route)
        # #     Dim iGRR (2)
        # #     sch_route.RemovePoints iGRR
        # #     remove_points = iGRR
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def reshape_extremity(self, i_grr: SchGRRRoute, i_route_cntr: SchAppConnector, i_db2_delta_xy: tuple) -> tuple:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub ReshapeExtremity(SchGRRRoute iGRR,
                | SchAppConnector iRouteCntr,
                | CATSafeArrayVariant iDb2DeltaXY)
                | 
                |     Change the position of the extremity of the route.
                | 
                |     Parameters:
                | 
                |         iGRR
                |             graphical primitive of the route to reshape (if NULL, assume there
                |             is only one graphical primitive) 
                |         iRouteCntr
                |             Route connector whose position is to be modified
                |             (CATISchAppConnector interface pointer). 
                |         iDb2DeltaXY
                |             Delta X-Y coordinates of the extremity move 
                | 
                |     Example:
                |
                |          Dim objThisIntf As SchRoute
                |          Dim objArg1 As SchGRRRoute
                |          Dim objArg2 As SchAppConnector
                |          Dim dbVar3(2) As CATSafeArrayVariant
                |           ...
                |          objThisIntf.ReshapeExtremityobjArg1,objArg2,dbVar3

        :param SchGRRRoute i_grr:
        :param SchAppConnector i_route_cntr:
        :param tuple i_db2_delta_xy:
        :rtype: tuple
        """
        return self.sch_route.ReshapeExtremity(i_grr.com_object, i_route_cntr.com_object, i_db2_delta_xy)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'reshape_extremity'
        # # vba_code = """
        # # Public Function reshape_extremity(sch_route)
        # #     Dim iGRR (2)
        # #     sch_route.ReshapeExtremity iGRR
        # #     reshape_extremity = iGRR
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def reshape_extremity2(
            self,
            i_e_route_mode: int,
            i_grr: SchGRRRoute,
            i_route_cntr: SchAppConnector,
            i_db2_pt_to_move_cntr_to: tuple
    ) -> tuple:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub ReshapeExtremity2(CatSchIDLRouteMode iERouteMode,
                | SchGRRRoute iGRR,
                | SchAppConnector iRouteCntr,
                | CATSafeArrayVariant iDb2PtToMoveCntrTo)
                | 
                |     Change the position of the extremity of the route. Modify the route
                |     according to the route mode.
                | 
                |     Parameters:
                | 
                |         iERouteMode
                |             Routing mode. 
                |         iGRR
                |             graphical primitive of the route to reshape (if NULL, assume there
                |             is only one graphical primitive) 
                |         iRouteCntr
                |             Route connector whose position is to be modified (CATISchConnector
                |             interface pointer). 
                |         iDb2PtToMoveCntrTo
                |             X-Y coordinates of the point to move the connector to.
                |
                |     Example:
                |
                |          Dim objThisIntf As SchRoute
                | 
                |          Dim objArg2 As SchGRRRoute
                |          Dim objArg3 As SchAppConnector
                |          Dim dbVar4(2) As CATSafeArrayVariant
                |           ...
                |          objThisIntf.ReshapeExtremity2CatSchIDLRouteMode_Enum,objArg2,objArg3,dbVar4

        :param int i_e_route_mode: enum cat_sch_idl_route_mode
        :param SchGRRRoute i_grr:
        :param SchAppConnector i_route_cntr:
        :param tuple i_db2_pt_to_move_cntr_to:
        :rtype: tuple
        """
        return self.sch_route.ReshapeExtremity2(
            i_e_route_mode,
            i_grr.com_object,
            i_route_cntr.com_object,
            i_db2_pt_to_move_cntr_to
        )
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'reshape_extremity2'
        # # vba_code = """
        # # Public Function reshape_extremity2(sch_route)
        # #     Dim iERouteMode (2)
        # #     sch_route.ReshapeExtremity2 iERouteMode
        # #     reshape_extremity2 = iERouteMode
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def set_path(self, i_grr: SchGRRRoute, i_l_db2_pt_path: tuple) -> tuple:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub SetPath(SchGRRRoute iGRR,
                | CATSafeArrayVariant iLDb2PtPath)
                | 
                |     Set the defining points of a route.
                | 
                |     Parameters:
                | 
                |         iGRR
                |             graphical primitive of the route to set the path on (if NULL,
                |             assume there is only one graphical primitive) 
                |         iLDbPtPath
                |             A list of X-Y coordinates of points to be set. 2 doubles per point.
                |
                |     Example:
                |
                |          Dim objThisIntf As SchRoute
                |          Dim objArg1 As SchGRRRoute
                |          Dim dbVar2(x) As CATSafeArrayVariant
                |           ...
                |          objThisIntf.SetPathobjArg1,dbVar2

        :param SchGRRRoute i_grr:
        :param tuple i_l_db2_pt_path:
        :rtype: tuple
        """
        return self.sch_route.SetPath(i_grr.com_object, i_l_db2_pt_path)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'set_path'
        # # vba_code = """
        # # Public Function set_path(sch_route)
        # #     Dim iGRR (2)
        # #     sch_route.SetPath iGRR
        # #     set_path = iGRR
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def __repr__(self):
        return f'SchRoute(name="{self.name}")'
