#! usr/bin/python3.9
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-09-25 14:34:21.593357

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""
from pycatia.cat_sch_platform_interfaces.sch_grr import SchGRR
from pycatia.cat_sch_platform_interfaces.sch_list_of_objects import SchListOfObjects
from pycatia.system_interfaces.any_object import AnyObject


class SchRouteAlternateGraphic(AnyObject):
    """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.AnyObject
                |                     SchRouteAlternateGraphic
                | 
                | Manage alternative graphical primitives of a schematic route.
    
    """

    def __init__(self, com_object):
        super().__init__(com_object)
        self.sch_route_alternate_graphic = com_object

    def add_alternate_graphic(self, i_initial_xy_position: tuple, o_added_grr: SchGRR) -> tuple:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub AddAlternateGraphic(CATSafeArrayVariant
                | iInitialXYPosition,
                | SchGRR oAddedGRR)
                | 
                |     Add an alternate graphical primitive to a route. The alternate graphical
                |     style is determined by the application. on the Schematic component in order to
                |     specify the graphic style. on the Schematic component in order to identify the
                |     component as an assembly.
                | 
                |     Parameters:
                | 
                |         iInitialXYPosition
                |             The initial position for calculating the display of the graphic. If
                |             NULL, the start point will be calculated based on the route graphic path of the
                |             first assembly member to this Schematic component.
                |             
                |         oAddedGRR
                |             The route alternate graphical primitive that is added to the route.
                |
                |     Example:
                |
                |          Dim objThisIntf As SchRouteAlternateGraphic
                |          Dim dbVar1(x) As CATSafeArrayVariant
                |          Dim objArg2 As SchGRR
                |           ...
                |          objThisIntf.AddAlternateGraphicdbVar1,objArg2

        :param tuple i_initial_xy_position:
        :param SchGRR o_added_grr:
        :rtype: tuple
        """
        return self.sch_route_alternate_graphic.AddAlternateGraphic(i_initial_xy_position, o_added_grr.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'add_alternate_graphic'
        # # vba_code = """
        # # Public Function add_alternate_graphic(sch_route_alternate_graphic)
        # #     Dim iInitialXYPosition (2)
        # #     sch_route_alternate_graphic.AddAlternateGraphic iInitialXYPosition
        # #     add_alternate_graphic = iInitialXYPosition
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def list_alternate_graphics(self) -> SchListOfObjects:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Func ListAlternateGraphics() As SchListOfObjects
                | 
                |     Lists the alternate graphics of a route. The list contains all objects of
                |     the same alternate graphic style. The style is determined must be implemented
                |     on the Schematic component in order to specify the graphic
                |     style.
                | 
                |     Parameters:
                | 
                |         oLGRR
                |             A list of the alternate graphic objects. 
                | 
                |     Example:
                |
                |          Dim objThisIntf As SchRouteAlternateGraphic
                |          Dim objArg1 As SchListOfObjects
                |           ...
                |          Set objArg1 = objThisIntf.ListAlternateGraphics

        :rtype: SchListOfObjects
        """
        return SchListOfObjects(self.sch_route_alternate_graphic.ListAlternateGraphics())

    def remove_all_alternate_graphics(self) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub RemoveAllAlternateGraphics()
                | 
                |     Removes all alternate graphical primitives.
                | 
                |     Example:
                |
                |          Dim objThisIntf As SchRouteAlternateGraphic
                |           ...
                |          objThisIntf.RemoveAllAlternateGraphics

        :rtype: None
        """
        return self.sch_route_alternate_graphic.RemoveAllAlternateGraphics()

    def remove_all_alternate_graphics_of_style(self, i_style: int) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub RemoveAllAlternateGraphicsOfStyle(CatSchIDLRouteAlternateGraphicStyle
                | iStyle)
                | 
                |     Removes all alternate graphical primitives of the given
                |     style.
                | 
                |     Parameters:
                | 
                |         iStyle
                |             An enum of the style of alternate graphic to remove.
                |
                |     Example:
                |
                |          Dim objThisIntf As SchRouteAlternateGraphic
                | 
                |           ...
                |          objThisIntf.RemoveAllAlternateGraphicsOfStyleCatSchIDLRouteAlternateGraphicStyle_Enum

        :param int i_style: enum cat_sch_idl_route_alternate_graphic_style
        :rtype: None
        """
        return self.sch_route_alternate_graphic.RemoveAllAlternateGraphicsOfStyle(i_style)

    def remove_alternate_graphic(self, i_grr_to_be_removed: SchGRR) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub RemoveAlternateGraphic(SchGRR iGRRToBeRemoved)
                | 
                |     Remove an alternate graphical primitive from a route.
                | 
                |     Parameters:
                | 
                |         iGRRToBeRemoved
                |             The route alternate graphic to be removed from the route. The input
                |             graphic will be removed as long as there are at least two alternate graphics of
                |             that style on the route. 
                | 
                |     Example:
                |
                |          Dim objThisIntf As SchRouteAlternateGraphic
                |          Dim objArg1 As SchGRR
                |           ...
                |          objThisIntf.RemoveAlternateGraphicobjArg1

        :param SchGRR i_grr_to_be_removed:
        :rtype: None
        """
        return self.sch_route_alternate_graphic.RemoveAlternateGraphic(i_grr_to_be_removed.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'remove_alternate_graphic'
        # # vba_code = """
        # # Public Function remove_alternate_graphic(sch_route_alternate_graphic)
        # #     Dim iGRRToBeRemoved (2)
        # #     sch_route_alternate_graphic.RemoveAlternateGraphic iGRRToBeRemoved
        # #     remove_alternate_graphic = iGRRToBeRemoved
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def __repr__(self):
        return f'SchRouteAlternateGraphic(name="{self.name}")'
