#! usr/bin/python3.9
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-09-25 14:34:21.593357

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""

from pycatia.in_interfaces.document import Document
from pycatia.system_interfaces.any_object import AnyObject


class SchSession(AnyObject):
    """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.AnyObject
                |                     SchSession
                | 
                | Represents a schematic session.
    
    """

    def __init__(self, com_object):
        super().__init__(com_object)
        self.sch_session = com_object

    def create_document(self, i_doc_type: str, i_b_interactive: bool, o_new_doc: Document) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub CreateDocument(CATBSTR iDocType,
                | boolean iBInteractive,
                | Document oNewDoc)
                | 
                |     Create a document with Schematic context.
                | 
                |     Parameters:
                | 
                |         iDocType
                |             Document type, if NULL "Product" is assumed. These are the types
                |             shown in the File+New list 
                |         iBInteractive
                |             If TRUE, document is created in interactive session with editor
                |             
                |         oNewDoc
                |             Document created. 
                | 
                |     Example:
                |
                |          Dim objThisIntf As SchSession
                |          Dim strVar1 As String
                |          Dim bVar2 As boolean
                |          Dim objArg3 As Document
                |           ...
                |          objThisIntf.CreateDocumentstrVar1,bVar2,objArg3

        :param str i_doc_type:
        :param bool i_b_interactive:
        :param Document o_new_doc:
        :rtype: None
        """
        return self.sch_session.CreateDocument(i_doc_type, i_b_interactive, o_new_doc.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'create_document'
        # # vba_code = """
        # # Public Function create_document(sch_session)
        # #     Dim iDocType (2)
        # #     sch_session.CreateDocument iDocType
        # #     create_document = iDocType
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def get_current_application_id(self, o_application_id: str) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub GetCurrentApplicationID(CATBSTR oApplicationID)
                | 
                |     Get the current application ID.
                | 
                |     Parameters:
                | 
                |         oApplicationID
                |             Application ID 
                | 
                |     Example:
                |
                |          Dim objThisIntf As SchSession
                |          Dim strVar1 As String
                |           ...
                |          objThisIntf.GetCurrentApplicationIDstrVar1

        :param str o_application_id:
        :rtype: None
        """
        return self.sch_session.GetCurrentApplicationID(o_application_id)

    def get_current_document(self) -> Document:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Func GetCurrentDocument() As Document
                | 
                |     Get the current document.
                | 
                |     Parameters:
                | 
                |         oCurDoc
                |             Pointer to current document. DO NOT NEED TO RELEASE OUTPUT POINTER.
                |
                |     Example:
                |
                |          Dim objThisIntf As SchSession
                |          Dim objArg1 As Document
                |           ...
                |          Set objArg1 = objThisIntf.GetCurrentDocument

        :rtype: Document
        """
        return Document(self.sch_session.GetCurrentDocument())

    def get_sch_ext_container(self, i_doc: Document) -> AnyObject:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Func GetSchExtContainer(Document iDoc) As AnyObject
                | 
                |     Get the schematic container (e.g. for CATISchBaseFactory
                |     implementation).
                | 
                |     Parameters:
                | 
                |         iDoc
                |             Document in the session to retreive the container from
                |             
                |         oContainer
                |             Schematic container shown in the File+New list 
                | 
                |     Example:
                |
                |          Dim objThisIntf As SchSession
                |          Dim objArg1 As Document
                |          Dim objArg2 As AnyObject
                |           ...
                |          Set objArg2 = objThisIntf.GetSchExtContainer(objArg1)

        :param Document i_doc:
        :rtype: AnyObject
        """
        return AnyObject(self.sch_session.GetSchExtContainer(i_doc.com_object))

    def set_current_application_id(self, i_application_id: str) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub SetCurrentApplicationID(CATBSTR iApplicationID)
                | 
                |     Set the current application ID.
                | 
                |     Parameters:
                | 
                |         iApplicationID
                |             Application ID 
                | 
                |     Example:
                |
                |          Dim objThisIntf As SchSession
                |          Dim strVar1 As String
                |           ...
                |          objThisIntf.SetCurrentApplicationIDstrVar1

        :param str i_application_id:
        :rtype: None
        """
        return self.sch_session.SetCurrentApplicationID(i_application_id)

    def set_current_document(self, i_cur_doc: Document) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub SetCurrentDocument(Document iCurDoc)
                | 
                |     Set the current document.
                | 
                |     Parameters:
                | 
                |         iCurDoc
                |             Pointer to current document. 
                | 
                |     Example:
                |
                |          Dim objThisIntf As SchSession
                |          Dim objArg1 As Document
                |           ...
                |          objThisIntf.SetCurrentDocumentobjArg1

        :param Document i_cur_doc:
        :rtype: None
        """
        return self.sch_session.SetCurrentDocument(i_cur_doc.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'set_current_document'
        # # vba_code = """
        # # Public Function set_current_document(sch_session)
        # #     Dim iCurDoc (2)
        # #     sch_session.SetCurrentDocument iCurDoc
        # #     set_current_document = iCurDoc
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def __repr__(self):
        return f'SchSession(name="{self.name}")'
