#! usr/bin/python3.9
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-09-25 14:34:21.593357

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""

from pycatia.system_interfaces.setting_controller import SettingController


class CatalogShmObjectSettingAtt(SettingController):
    """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.AnyObject
                |                     System.SettingController
                |                         CatalogSHMObjectSettingAtt
                | 
                | Represents the CATIA Sheet Metal Aerospace General setting controller
                | object.
                | Role: The CATIA Sheet Metal Aerospace setting General controller object deals
                | with the setting attributes displayed in the Aerospace Sheet Metal Design
                | General property page. To access this property page:
                | 
                |     Click the Options command in the Tools menu
                |     Click + left of Mechanical Design to unfold the workbench
                |     list
                |     Click General
                | 
                | The Sheet Metal Aerospace General setting controller object can be retrieved as
                | an item of the setting controller collection using its name
                | "CATIStmCatalogSHMObjectSettingCtrl" as follows:
                | 
                |  Dim settingControllers1 As SettingControllers
                |  Set settingControllers1 = CATIA.SettingControllers
                |  Dim CATIAStmCatalogSHMObjectSettingAtt1 As SettingController
                |  Set CATIAStmCatalogSHMObjectSettingAtt1 = settingControllers1.Item("CATIStmCatalogSHMObjectSettingCtrl")
    
    """

    def __init__(self, com_object):
        super().__init__(com_object)
        self.catalog_shm_object_setting_att = com_object

    @property
    def shm_std_prof_path(self) -> str:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)
                | o Property SHMStdProfPath() As CATBSTR
                | 
                |     Returns or sets the SHMStdProfPath setting parameter
                |     value.
                |     Role: The SHMStdProfPath setting parameter stores the path to the CATIA
                |     Catalog file used by the Catalog Browser whenever it is involved in Aerospace
                |     Sheet Metal commands, such as cutout or corner relief.
                |     Legal values: a valid path to a CATIA Catalog file.

        :rtype: str
        """

        return self.catalog_shm_object_setting_att.SHMStdProfPath

    @shm_std_prof_path.setter
    def shm_std_prof_path(self, value: str):
        """
        :param str value:
        """

        self.catalog_shm_object_setting_att.SHMStdProfPath = value

    def get_shm_std_prof_path_info(self, io_admin_level: str, io_locked: str) -> bool:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Func GetSHMStdProfPathInfo(CATBSTR ioAdminLevel,
                | CATBSTR ioLocked) As boolean
                | 
                |     Retrieves information about the SHMStdProfPath setting
                |     parameter.
                |     Refer to SettingController for a detailed description.

        :param str io_admin_level:
        :param str io_locked:
        :rtype: bool
        """
        return self.catalog_shm_object_setting_att.GetSHMStdProfPathInfo(io_admin_level, io_locked)

    def set_shm_std_prof_path_lock(self, i_locked: bool) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub SetSHMStdProfPathLock(boolean iLocked)
                | 
                |     Locks or unlocks the SHMStdProfPath setting parameter.
                |     Refer to SettingController for a detailed description.

        :param bool i_locked:
        :rtype: None
        """
        return self.catalog_shm_object_setting_att.SetSHMStdProfPathLock(i_locked)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'set_shm_std_prof_path_lock'
        # # vba_code = """
        # # Public Function set_shm_std_prof_path_lock(catalog_shm_object_setting_att)
        # #     Dim iLocked (2)
        # #     catalog_shm_object_setting_att.SetSHMStdProfPathLock iLocked
        # #     set_shm_std_prof_path_lock = iLocked
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def __repr__(self):
        return f'CatalogShmObjectSettingAtt(name="{self.name}")'
