#! usr/bin/python3.9
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-09-25 14:34:21.593357

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""
from pycatia.cat_str_functional_interfaces.sfm_standard_contour_parameters import SFMStandardContourParameters
from pycatia.system_interfaces.any_object import AnyObject
from pycatia.types.general import cat_variant


class SFMOpeningContoursMgr(AnyObject):
    """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.AnyObject
                |                     SfmOpeningContoursMgr
                | 
                | Gets CATIASfmOpeningContoursMgr.
                | Use this manager to GetAvailableStdOpeningContours &
                | GetStdOpeningContourParams.
                | 
                | Example
                | :
                |     Retrives the Manager from factory
                | 
                |       'Get the Factory
                |       Set Factory =  part1.GetCustomerFactory("SfmFunctionFactory")
                |       'Retrieve the Contour Manager
                |       Dim ObjSfmContourMgr As SfmOpeningContoursMgr
                |       Set ObjSfmContourMgr = Factory.GetOpeningMgr(Part1, "SfmOpeningContoursMgr")
    
    """

    def __init__(self, com_object):
        super().__init__(com_object)
        self.sfm_opening_contours_mgr = com_object

    def get_available_std_opening_contours(self, o_list_contour_names: tuple) -> cat_variant:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub GetAvailableStdOpeningContours(CATSafeArrayVariant
                | oListContourNames)
                | 
                |     Get The list of Available Contours.
                | 
                |     Parameters:
                | 
                |         oListContourNames
                |             [out] Available Contour names 
                | 
                |     Returns:
                |         S_OK if everything ran ok
                | 
                |         Example
                |         :
                |             The Example demonstrates how to see available contours. Choose the
                |             required contour from the list.
                | 
                |               'Get the Factory
                |               Set Factory =  part1.GetCustomerFactory("SfmFunctionFactory")
                |               'Get the Contour Manager
                |               Dim ObjSfmContourMgr As SfmOpeningContoursMgr
                |               Set ObjSfmContourMgr = Factory.GetOpeningMgr(Part1, "SfmOpeningContoursMgr")
                |               'Get The List of Available Contours
                |               Dim oListContourNames() As Variant
                |               ObjSfmContourMgr.GetAvailableStdOpeningContours
                |               oListContourNames
                |               'Display The List of Available Contours
                |               Dim NbOfContour As Long
                |               NbOfContour = UBound(oListContourNames)
                |               Display List of contours
                |               For i = 0 To NbOfContour
                |               MsgBox oListContourNames(i)
                |               Next

        :param tuple o_list_contour_names:
        :rtype: cat_variant
        """
        return self.sfm_opening_contours_mgr.GetAvailableStdOpeningContours(o_list_contour_names)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'get_available_std_opening_contours'
        # # vba_code = """
        # # Public Function get_available_std_opening_contours(sfm_opening_contours_mgr)
        # #     Dim oListContourNames (2)
        # #     sfm_opening_contours_mgr.GetAvailableStdOpeningContours oListContourNames
        # #     get_available_std_opening_contours = oListContourNames
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def get_std_opening_contour_params(self, i_contour_name: str) -> SFMStandardContourParameters:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Func GetStdOpeningContourParams(CATBSTR iContourName) As
                | SfmStandardContourParameters
                | 
                |     Get The list of Parameters for a selected Contour Name.The list varies
                |     depending on the type of contour.
                | 
                |     Parameters:
                | 
                |         iContourName
                |             [in] Contour names for which parameters need to be set.
                |             
                |         oListCkeParms
                |             [out] List of Parameters. 
                | 
                |     Returns:
                |         S_OK if everything ran ok
                | 
                |         Example:
                |             The Example demonstartes what parameters are required to be set for
                |             a chosen contour.Here "Sfm_Rect" is the chosen
                |             contour.
                | 
                |               'Retrieve the Factory
                |               Set Factory =  part1.GetCustomerFactory("SfmFunctionFactory")
                |               'Retrieve the Contour Manager
                |               Dim ObjSfmContourMgr As SfmOpeningContoursMgr
                |               Set ObjSfmContourMgr = Factory.GetOpeningMgr(Part1, "SfmOpeningContoursMgr")
                |               ' Enter Contour Name for which Parameter values need to be
                |               set
                |               Dim oListCkeParms As
                |               SfmStandardContourParameters
                |               Set oListCkeParms = ObjSfmContourMgr.GetStdOpeningContourParams("Sfm_Rect")
                |              'Display List of Parameters for Selected Contour
                |               Dim NbOfParam As Long
                |               NbOfParam = oListCkeParms.Count
                |               Dim ContourParam As Parameter
                |               Dim ContourParamName As String
                |               For i = 1 To NbOfParam
                |               Set ContourParam = oListCkeParms.Item(i)
                |               ContourParamName = oListCkeParms.Item(i).Name
                |               MsgBox ContourParamName
                |              'Set Contour Parameter Values
                |              If ContourParamName = "Sfm_Width" Then
                |                ContourParam.ValuateFromString ("1000mm")
                |                End If
                |              If ContourParamName = "Sfm_Height" Then
                |               ContourParam.ValuateFromString ("5000mm")
                |                End If
                |              If ContourParamName = "Sfm_CornerRadius" Then
                |               ContourParam.ValuateFromString ("10mm")
                |                End If
                |                Next

        :param str i_contour_name:
        :rtype: SFMStandardContourParameters
        """
        return SFMStandardContourParameters(self.sfm_opening_contours_mgr.GetStdOpeningContourParams(i_contour_name))

    def __repr__(self):
        return f'SFMOpeningContoursMgr(name="{self.name}")'
