#! usr/bin/python3.9
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-09-25 14:34:21.593357

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""
from pycatia.dnb_fastener_interfaces.fastener import Fastener
from pycatia.system_interfaces.any_object import AnyObject


class DnbFastenerNewMfgPosServices(AnyObject):
    """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.AnyObject
                |                     DNBFastenerNewMfgPosServices

    
    """

    def __init__(self, com_object):
        super().__init__(com_object)
        self.dnb_fastener_new_mfg_pos_services = com_object

    def get_flagged_fasteners(self, o_fastener_array: tuple) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub GetFlaggedFasteners(CATSafeArrayVariant
                | oFastenerArray)
                | 
                |     Gets List of flagged DELMIAFasteners. * 
                | 
                | Example:
                |     Set myObject = CATIA.GetItem("DNBFastenerNewMfgPosServices")
                |     myObject.GetFlaggedFasteners ArrayFastener

        :param tuple o_fastener_array:
        :rtype: None
        """
        return self.dnb_fastener_new_mfg_pos_services.GetFlaggedFasteners(o_fastener_array)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'get_flagged_fasteners'
        # # vba_code = """
        # # Public Function get_flagged_fasteners(dnb_fastener_new_mfg_pos_services)
        # #     Dim oFastenerArray (2)
        # #     dnb_fastener_new_mfg_pos_services.GetFlaggedFasteners oFastenerArray
        # #     get_flagged_fasteners = oFastenerArray
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def get_number_of_flagged_fasteners(self) -> int:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Func GetNumberOfFlaggedFasteners() As long
                | 
                |     Gets number of flagged DELMIAFasteners. * 
                | 
                | Example:
                |     Set myObject = CATIA.GetItem("DNBFastenerNewMfgPosServices")
                |     NbFastener = myObject.GetNumberOfFlaggedFasteners

        :rtype: int
        """
        return self.dnb_fastener_new_mfg_pos_services.GetNumberOfFlaggedFasteners()

    def set_flag(self, i_fastener: Fastener) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub SetFlag(Fastener iFastener)
                | 
                |     flags a specified DELMIAFastener to create a new manufacturing fastener in
                |     its place. * 
                | 
                | Example:
                |     Set myObject = CATIA.GetItem("DNBFastenerNewMfgPosServices")
                |     myObject.SetFlag MyFastener always returns S_OK even the function is not successful.
                |     For example the fastener is already flagged.

        :param Fastener i_fastener:
        :rtype: None
        """
        return self.dnb_fastener_new_mfg_pos_services.SetFlag(i_fastener.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'set_flag'
        # # vba_code = """
        # # Public Function set_flag(dnb_fastener_new_mfg_pos_services)
        # #     Dim iFastener (2)
        # #     dnb_fastener_new_mfg_pos_services.SetFlag iFastener
        # #     set_flag = iFastener
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def set_flag_on_fasteners(self, i_fastener_array: tuple) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub SetFlagOnFasteners(CATSafeArrayVariant iFastenerArray)
                | 
                |     flags a list of DELMIAFasteners to create new manufacturing fasteners in
                |     their place. * 
                | 
                | Example:
                |     Set myObject = CATIA.GetItem("DNBFastenerNewMfgPosServices")
                |     myObject.SetFlagOnFasteners ArrayFastener always returns S_OK even the function is not successful.
                |     For example the fasteners are already flagged.

        :param tuple i_fastener_array:
        :rtype: None
        """
        return self.dnb_fastener_new_mfg_pos_services.SetFlagOnFasteners(i_fastener_array)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'set_flag_on_fasteners'
        # # vba_code = """
        # # Public Function set_flag_on_fasteners(dnb_fastener_new_mfg_pos_services)
        # #     Dim iFastenerArray (2)
        # #     dnb_fastener_new_mfg_pos_services.SetFlagOnFasteners iFastenerArray
        # #     set_flag_on_fasteners = iFastenerArray
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def unset_flag(self, i_fastener: Fastener) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub UnsetFlag(Fastener iFastener)
                | 
                |     unflags a flagged DELMIAFastener to create a new manufacturing fastener in
                |     its place. * 
                | 
                | Example:
                |     Set myObject = CATIA.GetItem("DNBFastenerNewMfgPosServices")
                |     myObject.UnsetFlag MyFastener always returns S_OK even the function is not successful.
                |     For example the fastener is not flagged.

        :param Fastener i_fastener:
        :rtype: None
        """
        return self.dnb_fastener_new_mfg_pos_services.UnsetFlag(i_fastener.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'unset_flag'
        # # vba_code = """
        # # Public Function unset_flag(dnb_fastener_new_mfg_pos_services)
        # #     Dim iFastener (2)
        # #     dnb_fastener_new_mfg_pos_services.UnsetFlag iFastener
        # #     unset_flag = iFastener
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def unset_flag_on_fasteners(self, i_fastener_array: tuple) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub UnsetFlagOnFasteners(CATSafeArrayVariant
                | iFastenerArray)
                | 
                |     unflags a list of DELMIAFasteners to create new manufacturing fasteners in
                |     their place. * 
                | 
                | Example:
                |     Set myObject = CATIA.GetItem("DNBFastenerNewMfgPosServices")
                |     myObject.UnsetFlagOnFasteners ArrayFastener always returns S_OK even the function is not
                |     successful. For example the fasteners are not flagged.

        :param tuple i_fastener_array:
        :rtype: None
        """
        return self.dnb_fastener_new_mfg_pos_services.UnsetFlagOnFasteners(i_fastener_array)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'unset_flag_on_fasteners'
        # # vba_code = """
        # # Public Function unset_flag_on_fasteners(dnb_fastener_new_mfg_pos_services)
        # #     Dim iFastenerArray (2)
        # #     dnb_fastener_new_mfg_pos_services.UnsetFlagOnFasteners iFastenerArray
        # #     unset_flag_on_fasteners = iFastenerArray
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def __repr__(self):
        return f'DnbFastenerNewMfgPosServices(name="{self.name}")'
