#! usr/bin/python3.9
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-09-25 14:34:21.593357

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""

from pycatia.system_interfaces.any_object import AnyObject


class FastenerWorkBench(AnyObject):

    """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.AnyObject
                |                     FastenerWorkBench
                | 
                | Interface DELMIAFastenerWorkBench It is a utility class to get fasteners and
                | groups from document.
    
    """

    def __init__(self, com_object):
        super().__init__(com_object)
        self.fastener_work_bench = com_object

    def curve_fasteners(self, o_curve_fastener_array: tuple) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub CurveFasteners(CATSafeArrayVariant
                | oCurveFastenerArray)

        :param tuple o_curve_fastener_array:
        :rtype: None
        """
        return self.fastener_work_bench.CurveFasteners(o_curve_fastener_array)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'curve_fasteners'
        # # vba_code = """
        # # Public Function curve_fasteners(fastener_work_bench)
        # #     Dim oCurveFastenerArray (2)
        # #     fastener_work_bench.CurveFasteners oCurveFastenerArray
        # #     curve_fasteners = oCurveFastenerArray
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def fastener_groups(self, o_fastener_group_array: tuple) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub FastenerGroups(CATSafeArrayVariant
                | oFastenerGroupArray)

        :param tuple o_fastener_group_array:
        :rtype: None
        """
        return self.fastener_work_bench.FastenerGroups(o_fastener_group_array)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'fastener_groups'
        # # vba_code = """
        # # Public Function fastener_groups(fastener_work_bench)
        # #     Dim oFastenerGroupArray (2)
        # #     fastener_work_bench.FastenerGroups oFastenerGroupArray
        # #     fastener_groups = oFastenerGroupArray
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def get_number_of_curve_fasteners(self) -> int:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Func GetNumberOfCurveFasteners() As long

        :rtype: int
        """
        return self.fastener_work_bench.GetNumberOfCurveFasteners()

    def get_number_of_fastener_groups(self) -> int:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Func GetNumberOfFastenerGroups() As long

        :rtype: int
        """
        return self.fastener_work_bench.GetNumberOfFastenerGroups()

    def get_number_of_point_fasteners(self) -> int:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Func GetNumberOfPointFasteners() As long

        :rtype: int
        """
        return self.fastener_work_bench.GetNumberOfPointFasteners()

    def point_fasteners(self, o_point_fastener_array: tuple) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub PointFasteners(CATSafeArrayVariant
                | oPointFastenerArray)

        :param tuple o_point_fastener_array:
        :rtype: None
        """
        return self.fastener_work_bench.PointFasteners(o_point_fastener_array)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'point_fasteners'
        # # vba_code = """
        # # Public Function point_fasteners(fastener_work_bench)
        # #     Dim oPointFastenerArray (2)
        # #     fastener_work_bench.PointFasteners oPointFastenerArray
        # #     point_fasteners = oPointFastenerArray
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def __repr__(self):
        return f'FastenerWorkBench(name="{ self.name }")'
