#! usr/bin/python3.9
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-09-25 14:34:21.593357

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""
from pycatia.dnb_human_sim_interfaces.walk_activity import WalkActivity


class AutoWalkActivity(WalkActivity):
    """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.AnyObject
                |                     DMAPSInterfaces.Activity
                |                         DNBHumanSimInterfaces.WorkerActivity
                |                             DNBHumanSimInterfaces.WalkActivity
                |                                 AutoWalkActivity
                | 
                | Interface that represents an Auto-Walk activity
    
    """

    def __init__(self, com_object):
        super().__init__(com_object)
        self.auto_walk_activity = com_object

    def get_length_in_metre(self, d_length: float, b_curr_manikin_pose: bool) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub GetLengthInMetre(double dLength,
                | boolean bCurrManikinPose)
                | 
                |     This gets the auto walk length in metres
                | 
                |     Parameters:
                | 
                |         bCurrManikinPosition
                |             The bCurrManikinPosition flag is used to obtain the walk length for
                |             autowalk dynamically based on the location of manikin irrespective of its
                |             previous MoveToPosture activity; in a line tracking scenario if the manikin has
                |             a body constraint with a moving object then, the Degree Of Freedom (DOF)of
                |             previous MoveToPosture activity gives only the static walk length and is
                |             incorrect. By default, this value will be taken as FALSE
                |
                |     Returns:
                |         dLength walk length in metre

        :param float d_length:
        :param bool b_curr_manikin_pose:
        :rtype: None
        """
        return self.auto_walk_activity.GetLengthInMetre(d_length, b_curr_manikin_pose)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'get_length_in_metre'
        # # vba_code = """
        # # Public Function get_length_in_metre(auto_walk_activity)
        # #     Dim dLength (2)
        # #     auto_walk_activity.GetLengthInMetre dLength
        # #     get_length_in_metre = dLength
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def __repr__(self):
        return f'AutoWalkActivity(name="{self.name}")'
