#! usr/bin/python3.9
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-09-25 14:34:21.593357

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""
from pycatia.dnb_igp_arc_commands.amp_tag import AMPTag
from pycatia.system_interfaces.any_object import AnyObject


class AMPPath(AnyObject):
    """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.AnyObject
                |                     AMPPath
                | 
                | This interface provides the methods to handle the feature AMPPath which is a
                | list of AMPTags.
                | 
                | USAGE :
                | This interface can be used only during AMP primitive file execution and not in
                | a stand alone VB script file. In the AMP primitive file, use the AMP "Execute"
                | keyword to execute a VB script file. For example:
                | 
                | Execute FREE path_name_of_the_VB_script_file
                | ( Example tutorial file:
                | /intel_a/startup/ARW/PRIMITIVES/AMPPath_AMPTag_Interfaces_Usage
                | )
                | 
                | The entry point in the VB script file is the CATMain method which takes a
                | single argument of type "AMPPath".
                | ( For more details, please refer to the following sample VB script file:
                | /intel_a/startup/ARW/PRIMITIVES/AMPPath_AMPTag_Interfaces_Usage.CATScript
                | )
    
    """

    def __init__(self, com_object):
        super().__init__(com_object)
        self.amp_path = com_object

    def create_tag(self, i_location: tuple, o_tag: AMPTag) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub CreateTag(CATSafeArrayVariant iLocation,
                | AMPTag oTag)
                | 
                |     Function to create an AMPTag.
                | 
                |     Parameters:
                | 
                |         iLocation
                |             The location (with respect to world reference frame) at which the
                |             AMPTag has to be created. 
                |         oTag
                |             The newly created AMPTag. 
                | 
                |     Returns:
                |         an HRESULT value.
                |         Legal values:
                | 
                |             S_OK if the operation succeeds
                |             E_FAIL otherwise
                |             .

        :param tuple i_location:
        :param AMPTag o_tag:
        :rtype: None
        """
        return self.amp_path.CreateTag(i_location, o_tag.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'create_tag'
        # # vba_code = """
        # # Public Function create_tag(amp_path)
        # #     Dim iLocation (2)
        # #     amp_path.CreateTag iLocation
        # #     create_tag = iLocation
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def create_tag_with_reference(self, i_ref_tag: AMPTag, i_location: tuple, o_tag: AMPTag) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub CreateTagWithReference(AMPTag iRefTag,
                | CATSafeArrayVariant iLocation,
                | AMPTag oTag)
                | 
                |     Function to create an AMPTag with reference to an already existing
                |     AMPTag.
                | 
                |     Parameters:
                | 
                |         iRefTag
                |             The AMPTag which is taken as the reference. 
                |         iLocation
                |             The location (with respect to iRefTag as the reference frame) at
                |             which the AMPTag has to be created. 
                |         oTag
                |             The newly created AMPTag. 
                | 
                |     Returns:
                |         an HRESULT value.
                |         Legal values:
                | 
                |             S_OK if the operation succeeds
                |             E_FAIL otherwise
                |             .

        :param AMPTag i_ref_tag:
        :param tuple i_location:
        :param AMPTag o_tag:
        :rtype: None
        """
        return self.amp_path.CreateTagWithReference(i_ref_tag.com_object, i_location, o_tag.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'create_tag_with_reference'
        # # vba_code = """
        # # Public Function create_tag_with_reference(amp_path)
        # #     Dim iRefTag (2)
        # #     amp_path.CreateTagWithReference iRefTag
        # #     create_tag_with_reference = iRefTag
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def get_all_tags(self, io_tag_list: tuple) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub GetAllTags(CATSafeArrayVariant ioTagList)
                | 
                |     Function to get the list of AMPTags by name.
                | 
                |     Parameters:
                | 
                |         ioTagList
                |             Underlying list of AMPTag names. 
                | 
                |     Returns:
                |         an HRESULT value.
                |         Legal values:
                | 
                |             S_OK if the operation succeeds
                |             E_FAIL otherwise
                |             .

        :param tuple io_tag_list:
        :rtype: None
        """
        return self.amp_path.GetAllTags(io_tag_list)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'get_all_tags'
        # # vba_code = """
        # # Public Function get_all_tags(amp_path)
        # #     Dim ioTagList (2)
        # #     amp_path.GetAllTags ioTagList
        # #     get_all_tags = ioTagList
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def get_num_tags(self, otag_list_size: int) -> AMPTag:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub GetNumTags(short otagListSize)
                | 
                |     Function to get the number of AMPTags in the given
                |     AMPPath.
                |     Usage:
                |     'Array of AMPTags; No size specified as size is not known
                |     Dim objAMPTags() As AMPTag
                | 
                |     'Size of the array objAMPTags is determined
                |     Dim count As Integer
                |     iAMPPath.GetNumTags count
                | 
                |     'Set the size of array objAMPTags
                |     ReDim objAMPTags(count)
                | 
                |     Parameters:
                | 
                |         otagListSize
                |             Number of AMPTags. 
                | 
                |     Returns:
                |         an HRESULT value.
                |         Legal values:
                | 
                |             S_OK if the operation succeeds
                |             E_FAIL otherwise
                |             .

        :param int otag_list_size:
        :rtype: AMPTag
        """
        return AMPTag(self.amp_path.GetNumTags(otag_list_size))

    def get_script_var_value(self, o_value: str) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub GetScriptVarValue(CATBSTR oValue)
                | 
                |     Function to get the value of system variable, "ScriptVar".
                |     Usage:
                |     Dim myScriptVar As String
                |     iAMPPath.GetScriptVarValue myScriptVar
                | 
                |     Parameters:
                | 
                |         oValue
                |             Value of the system variable, "ScriptVar". 
                | 
                |     Returns:
                |         an HRESULT value.
                |         Legal values:
                | 
                |             S_OK if the operation succeeds
                |             E_FAIL otherwise.

        :param str o_value:
        :rtype: None
        """
        return self.amp_path.GetScriptVarValue(o_value)

    def get_target_device(self, o_device: AnyObject) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub GetTargetDevice(AnyObject oDevice)
                | 
                |     Function to get the target device of the AMPPath.
                | 
                |     Parameters:
                | 
                |         oDevice
                |             The target device of the AMPPath. 
                | 
                |     Returns:
                |         an HRESULT value.
                |         Legal values:
                | 
                |             S_OK if the operation succeeds
                |             E_FAIL otherwise
                |             .

        :param AnyObject o_device:
        :rtype: None
        """
        return self.amp_path.GetTargetDevice(o_device.com_object)

    def insert_at(self, i_index: int, i_tag: AMPTag) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub InsertAt(short iIndex,
                | AMPTag iTag)
                | 
                |     Function to insert an AMPTag at a given index of the
                |     AMPPath.
                | 
                |     Parameters:
                | 
                |         iIndex
                |             The index of AMPPath at which the AMPTag has to be inserted.
                |             
                |         iTag
                |             The AMPTag that has to be inserted. 
                | 
                |     Returns:
                |         an HRESULT value.
                |         Legal values:
                | 
                |             S_OK if the operation succeeds
                |             E_FAIL otherwise.

        :param int i_index:
        :param AMPTag i_tag:
        :rtype: None
        """
        return self.amp_path.InsertAt(i_index, i_tag.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'insert_at'
        # # vba_code = """
        # # Public Function insert_at(amp_path)
        # #     Dim iIndex (2)
        # #     amp_path.InsertAt iIndex
        # #     insert_at = iIndex
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def remove_from(self, i_index: int) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub RemoveFrom(short iIndex)
                | 
                |     Function to remove an AMPTag at a given index of the
                |     AMPPath.
                | 
                |     Parameters:
                | 
                |         iIndex
                |             The index of AMPPath at which the AMPTag has to be removed.
                |
                |     Returns:
                |         an HRESULT value.
                |         Legal values:
                | 
                |             S_OK if the operation succeeds
                |             E_FAIL otherwise
                |             .

        :param int i_index:
        :rtype: None
        """
        return self.amp_path.RemoveFrom(i_index)

    def __repr__(self):
        return f'AMPPath(name="{self.name}")'
