#! usr/bin/python3.9
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-09-25 14:34:21.593357

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""
from pycatia.dmaps_interfaces.activity import Activity
from pycatia.dnb_robot_interfaces.parameter_profiles import ParameterProfiles


class OperationProfile(Activity):
    """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.AnyObject
                |                     DMAPSInterfaces.Activity
                |                         OperationProfile
                | 
                | Represents an Operation.
                | 
                | Role: The interface is used to manage the attributes of an
                | Operation.
    
    """

    def __init__(self, com_object):
        super().__init__(com_object)
        self.operation_profile = com_object

    def get_user_profiles_list(self, i_profile_type: str, o_profiles: tuple) -> ParameterProfiles:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub GetUserProfilesList(CATBSTR iProfileType,
                | CATSafeArrayVariant oProfiles)
                | 
                |     Retreives the list of User Profiles for the Operation.
                | 
                |     Parameters:
                | 
                |         iProfileType
                |             if iType specified, only a list of that type inside the User
                |             Profiles List will be returned if iType is an empty string, all the User
                |             Profiles are returned 
                |         oProfiles
                |             The List of User Profiles. 
                | 
                |     Returns:
                |         An HRESULT.
                |         Legal values:
                | 
                |         S_OK
                |             List of User Profiles is successfully returned
                |         E_FAIL
                |             List of User Profiles could not be obtained
                | 
                |     Example:
                |
                |            Dim objOperProfile As OperationProfile
                |            Dim ProfileType as String
                |            ProfileType=""
                |                   ......
                |            Dim MyListOfProfiles() As ParameterProfiles 
                |            objOperProfile.GetUserProfilesList ProfileType,
                |            MyListOfProfiles
                |            ..

        :param str i_profile_type:
        :param tuple o_profiles:
        :rtype: ParameterProfiles
        """
        return ParameterProfiles(self.operation_profile.GetUserProfilesList(i_profile_type, o_profiles))
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'get_user_profiles_list'
        # # vba_code = """
        # # Public Function get_user_profiles_list(operation_profile)
        # #     Dim iProfileType (2)
        # #     operation_profile.GetUserProfilesList iProfileType
        # #     get_user_profiles_list = iProfileType
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def set_user_profiles_list(self, i_user_profiles: tuple) -> ParameterProfiles:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub SetUserProfilesList(CATSafeArrayVariant iUserProfiles)
                | 
                |     Sets User Profiles List for the Operation.
                | 
                |     Parameters:
                | 
                |         iUserProfiles
                |             The List of User Profiles to be set. 
                | 
                |     Returns:
                |         An HRESULT.
                |         Legal values:
                | 
                |         S_OK
                |             The List of User Profiles was successfully set.
                |         E_FAIL
                |             The List of User Profiles could not be set.
                | 
                |         Example:
                |             The following example sets the user profiles list for an
                |             Operation.
                | 
                |                Dim objOperProfile as OperationProfile
                |                Dim MyListOfProfiles() As ParameterProfiles
                |                ...
                |                ...
                |                objOperProfile.SetUserProfilesList
                |                MyListOfProfiles

        :param tuple i_user_profiles:
        :rtype: ParameterProfiles
        """
        return ParameterProfiles(self.operation_profile.SetUserProfilesList(i_user_profiles))
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'set_user_profiles_list'
        # # vba_code = """
        # # Public Function set_user_profiles_list(operation_profile)
        # #     Dim iUserProfiles (2)
        # #     operation_profile.SetUserProfilesList iUserProfiles
        # #     set_user_profiles_list = iUserProfiles
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def __repr__(self):
        return f'OperationProfile(name="{self.name}")'
