#! usr/bin/python3.9
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-09-25 14:34:21.593357

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""
from pycatia.dmaps_interfaces.activity import Activity
from pycatia.dnb_igp_setup_interfaces.operation import Operation
from pycatia.system_interfaces.any_object import AnyObject


class RobotTask(Activity):
    """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.AnyObject
                |                     DMAPSInterfaces.Activity
                |                         RobotTask
                | 
                | Represents the Robot Task.
                | 
                | Role: The interface is used manage activities under a Robot
                | Task.
                | The following code snippet can be used to obtain the Robot Task from a Robot
                | Task Factory.
                | 
                |    Dim objRobotTaskFactory As RobotTaskFactory
                |    Dim objRobot As Product
                |    ...
                |    Set objRobotTaskFactory = objRobot.GetTechnologicalObject("RobotTaskFactory" )
                |    Dim objRobotTaskList(3) as RobotTask
                |    Dim objRobotTask as RobotTask
                |    objRobotTaskFactory.GetAllRobotTasks objRobotTaskList
                |    objRobotTask=objRobotTaskList[0]
                |
                | The Robot Task can also be obtained from an activity of the type
                | RobotTask.
                | 
                |    Dim objActivity as Activity
                |    ...
                |    Dim objRobotTask as RobotTask
                |    Set objRobotTask = objActivity.GetTechnologicalObject("RobotTask" )
    
    """

    def __init__(self, com_object):
        super().__init__(com_object)
        self.robot_task = com_object

    def create_after_operation(self, i_after_operation: Operation, o_created_operation: Operation) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub CreateAfterOperation(Operation iAfterOperation,
                | Operation oCreatedOperation)
                | 
                |     Creates Operation as a child of Robot Task.
                | 
                |     Parameters:
                | 
                |         iAfterOperation
                |             The Operation after which the required operation is to be created.
                |             
                |         oCreatedOperation
                |             The Created Operation. 
                | 
                |     Returns:
                |         An HRESULT.
                |         Legal values:
                | 
                |         S_OK
                |             The operation was successfully created.
                |         E_FAIL
                |             The operation could not be created.
                | 
                |         Example:
                |             The following example creates an Operation
                | 
                |                Dim objRobotTask as RobotTask
                |                Dim objAfterOperation As Operation
                |                ...
                |                Dim objOperation As Operation
                |                objRobotTask.CreateAfterOperation
                |                objAfterOperation,objOperation

        :param Operation i_after_operation:
        :param Operation o_created_operation:
        :rtype: None
        """
        return self.robot_task.CreateAfterOperation(i_after_operation.com_object, o_created_operation.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'create_after_operation'
        # # vba_code = """
        # # Public Function create_after_operation(robot_task)
        # #     Dim iAfterOperation (2)
        # #     robot_task.CreateAfterOperation iAfterOperation
        # #     create_after_operation = iAfterOperation
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def create_call_task(
            self,
            i_robot_task: 'RobotTask',
            i_after_operation: Operation,
            i_where: bool,
            o_created_call_task: AnyObject
    ) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub CreateCallTask(RobotTask iRobotTask,
                | Operation iAfterOperation,
                | boolean iWhere,
                | AnyObject oCreatedCallTask)
                | 
                |     Creates a calltask inside a Robot Task
                | 
                |     Parameters:
                | 
                |         iRobotTask
                |             The task to be called in the current robot task 
                |         iAfterOperation
                |             The Operation after which the required operation is to be created..
                |             
                |         iWhere
                |             The postion of where the task needs to be inserted Before(0)
                |             After(1) 
                |         oCreatedCallTask
                |             The created call task 
                | 
                |     Returns:
                |         An HRESULT.
                |         Legal values:
                | 
                |         S_OK
                |             The call task was successfully created.
                |         E_FAIL
                |             The call task could not be created.
                | 
                |         Example:
                |             The following example creates An Operation
                | 
                |                Dim objRobotTask as RobotTask
                |                Dim objCalledTask as RobotTask
                |                Dim objAfterOperation as Operation
                |                ..
                |                Dim objCallTaskAct as AnyObject
                |                objRobotTask.CreateCallTask objCalledTask,objAfterOperation,1,objCallTaskAct

        :param RobotTask i_robot_task:
        :param Operation i_after_operation:
        :param bool i_where:
        :param AnyObject o_created_call_task:
        :rtype: None
        """
        return self.robot_task.CreateCallTask(
            i_robot_task.com_object,
            i_after_operation.com_object,
            i_where,
            o_created_call_task.com_object
        )
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'create_call_task'
        # # vba_code = """
        # # Public Function create_call_task(robot_task)
        # #     Dim iRobotTask (2)
        # #     robot_task.CreateCallTask iRobotTask
        # #     create_call_task = iRobotTask
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def create_operation(
            self,
            i_reference_operation: Operation,
            i_after_operation: Operation,
            o_created_operation: Operation
    ) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub CreateOperation(Operation iReferenceOperation,
                | Operation iAfterOperation,
                | Operation oCreatedOperation)
                | 
                |     Creates Operation as a child of Robot Task.
                | 
                |     Parameters:
                | 
                |         iReferenceOperation
                |             The Reference Operation after which the Operation has to be created
                |             and whose properties will be copied to the created operation.
                |             
                |         iAfterOperation
                |             The Operation after which the required operation is to be created.
                |             (Pass NOTHING if Reference Operation is specified)
                |             
                |         oCreatedOperation
                |             The Created Operation. 
                | 
                |     Returns:
                |         An HRESULT.
                |         Legal values:
                | 
                |         S_OK
                |             The operation was successfully created.
                |         E_FAIL
                |             The operation could not be created.
                | 
                |         Example:
                |             The following example creates an Operation
                | 
                |                Dim objRobotTask as RobotTask
                |                Dim objRefOperation as Operation
                |                ...
                |                Dim objAfterOperation as Operation
                |                Set objAfterOperation = Nothing
                |                Dim objOperation As Operation
                |                objRobotTask.CreateOperation
                |                objRefOperation,objAfterOperation,objOperation

        :param Operation i_reference_operation:
        :param Operation i_after_operation:
        :param Operation o_created_operation:
        :rtype: None
        """
        return self.robot_task.CreateOperation(
            i_reference_operation.com_object,
            i_after_operation.com_object,
            o_created_operation.com_object
        )
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'create_operation'
        # # vba_code = """
        # # Public Function create_operation(robot_task)
        # #     Dim iReferenceOperation (2)
        # #     robot_task.CreateOperation iReferenceOperation
        # #     create_operation = iReferenceOperation
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def delete_operations(self, i_operation_list: tuple) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub DeleteOperations(CATSafeArrayVariant iOperationList)
                | 
                |     Deletes the required list of Operations.
                | 
                |     Parameters:
                | 
                |         iOperationList
                |             The list of Operations to be deleted. 
                | 
                |     Returns:
                |         An HRESULT.
                |         Legal values:
                | 
                |         S_OK
                |             The operation list was successfully deleted.
                |         E_FAIL
                |             The operation list could not be created.
                | 
                |         Example:
                |             The following example creates an Operation
                | 
                |                Dim objRobotTask as RobotTask
                |                Dim objOperationList as Operation
                |                ...
                |                objRobotTask.DeleteOperations objOperationList

        :param tuple i_operation_list:
        :rtype: None
        """
        return self.robot_task.DeleteOperations(i_operation_list)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'delete_operations'
        # # vba_code = """
        # # Public Function delete_operations(robot_task)
        # #     Dim iOperationList (2)
        # #     robot_task.DeleteOperations iOperationList
        # #     delete_operations = iOperationList
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def get_all_operations(self, o_operation_list: tuple) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub GetAllOperations(CATSafeArrayVariant oOperationList)
                | 
                |     Retrieves the List of Operations of Robot Task.
                | 
                |     Parameters:
                | 
                |         oOperationList
                |             The list of Operations 
                | 
                |     Returns:
                |         An HRESULT.
                |         Legal values:
                | 
                |         S_OK
                |             The operation list was successfully queried.
                |         E_FAIL
                |             The operation list could not be queried.
                | 
                |         Example:
                |             The following example creates An Operation
                | 
                |                Dim objRobotTask as RobotTask
                |                Dim objOperationList As Operation
                |                ...
                |                objRobotTask.GetAllOperations objOperationList

        :param tuple o_operation_list:
        :rtype: None
        """
        return self.robot_task.GetAllOperations(o_operation_list)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'get_all_operations'
        # # vba_code = """
        # # Public Function get_all_operations(robot_task)
        # #     Dim oOperationList (2)
        # #     robot_task.GetAllOperations oOperationList
        # #     get_all_operations = oOperationList
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def __repr__(self):
        return f'RobotTask(name="{self.name}")'
