#! usr/bin/python3.9
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-09-25 14:34:21.593357

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""
from pycatia.dnb_igp_setup_interfaces.robot_task import RobotTask
from pycatia.system_interfaces.any_object import AnyObject


class RobotTaskFactory(AnyObject):
    """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.AnyObject
                |                     RobotTaskFactory
                | 
                | Represents the Task Creation Factory for Robots.
                | 
                | Role: Robot Task Factory is the object used to create robot
                | tasks.
                | The following code snippet can be used to obtain the Robot Task Factory from
                | the robot product.
                | 
                |    Dim objRobotTaskFactory As RobotTaskFactory
                |    Dim objRobot As Product
                |    ...
                |    Set objRobotTaskFactory = objRobot.GetTechnologicalObject("RobotTaskFactory" )
    
    """

    def __init__(self, com_object):
        super().__init__(com_object)
        self.robot_task_factory = com_object

    def create_robot_task(self, i_name: str, o_robot_task: RobotTask) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub CreateRobotTask(CATBSTR iName,
                | RobotTask oRobotTask)
                | 
                |     Creates a Robot Task
                | 
                |     Parameters:
                | 
                |         iName
                |             The Robot Task Name. 
                |         oRobotTask
                |             The Created Robot Task. 
                | 
                |     Returns:
                |         An HRESULT.
                |         Legal values:
                | 
                |         S_OK
                |             The Robot Task was successfully created.
                |         E_FAIL
                |             The Robot Task creation failed.
                | 
                |         Example:
                |             The following example creates a robot task for a
                |             robot.
                | 
                |                Dim objRobotTaskFactory As RobotTaskFactory
                |                Dim objRobotTask as RobotTask
                |                ..
                |                objRobotTaskFactory.CreateRobotTask
                |                "New_RobotTask_1",objRobotTask

        :param str i_name:
        :param RobotTask o_robot_task:
        :rtype: None
        """
        return self.robot_task_factory.CreateRobotTask(i_name, o_robot_task.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'create_robot_task'
        # # vba_code = """
        # # Public Function create_robot_task(robot_task_factory)
        # #     Dim iName (2)
        # #     robot_task_factory.CreateRobotTask iName
        # #     create_robot_task = iName
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def delete_robot_task(self, i_robot_task: RobotTask) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub DeleteRobotTask(RobotTask iRobotTask)
                | 
                |     Removes the required Robot Task.
                | 
                |     Parameters:
                | 
                |         iRobotTask
                |             The Robot Task to be Removed. 
                | 
                |     Returns:
                |         An HRESULT.
                |         Legal values:
                | 
                |         S_OK
                |             The Robot Task could be successfully deleted.
                |         E_FAIL
                |             The deletion of Robot Task failed.
                | 
                |         Example:
                |             The following example deleted a robot task of a
                |             robot.
                | 
                |                Dim objRobotTaskFactory As RobotTaskFactory
                |                Dim objRobotTask as RobotTask
                |                ..
                |                objRobotTaskFactory.DeleteRobotTask
                |                objRobotTask

        :param RobotTask i_robot_task:
        :rtype: None
        """
        return self.robot_task_factory.DeleteRobotTask(i_robot_task.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'delete_robot_task'
        # # vba_code = """
        # # Public Function delete_robot_task(robot_task_factory)
        # #     Dim iRobotTask (2)
        # #     robot_task_factory.DeleteRobotTask iRobotTask
        # #     delete_robot_task = iRobotTask
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def get_all_robot_tasks(self, o_robot_task_list: tuple) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub GetAllRobotTasks(CATSafeArrayVariant oRobotTaskList)
                | 
                |     Retrieves the list of Robot Tasks owned by a Robot.
                | 
                |     Parameters:
                | 
                |         oRobotTaskList
                |             The Robot Task List. 
                | 
                |     Returns:
                |         An HRESULT.
                |         Legal values:
                | 
                |         S_OK
                |             The Robot Task List could be successfully queried.
                |         E_FAIL
                |             The Robot Task List could not be retrieved.
                | 
                |         Example:
                |             The following example Retrieves the list of Robot Tasks for the
                |             Robot.
                | 
                |                Dim objRobotTaskFactory As RobotTaskFactory
                |                Dim objRobotTask(3) as RobotTask
                |                ..
                |                objRobotTaskFactory.GetAllRobotTasks
                |                objRobotTask

        :param tuple o_robot_task_list:
        :rtype: None
        """
        return self.robot_task_factory.GetAllRobotTasks(o_robot_task_list)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'get_all_robot_tasks'
        # # vba_code = """
        # # Public Function get_all_robot_tasks(robot_task_factory)
        # #     Dim oRobotTaskList (2)
        # #     robot_task_factory.GetAllRobotTasks oRobotTaskList
        # #     get_all_robot_tasks = oRobotTaskList
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def __repr__(self):
        return f'RobotTaskFactory(name="{self.name}")'
