#! usr/bin/python3.9
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-09-25 14:34:21.593357

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""
from pycatia.dnb_igp_setup_interfaces.tag import Tag
from pycatia.system_interfaces.any_object import AnyObject


class TagFactory(AnyObject):
    """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.AnyObject
                |                     TagFactory
                | 
                | Interface representing Tag factory.
                | 
                | Role: This allows the creation of a Tag
                | The following code snippet can be used to obtain a TagFactory from a selected
                | TagGroup
                | 
                |  Dim objTagFactory As TagFactory
                |  Set ParentObject = CATIA.ActiveDocument.Selection.FindObject("CATIAProduct")	
                |  Set objTagFactory = ParentObject.GetTechnologicalObject("TagFactory")
    
    """

    def __init__(self, com_object):
        super().__init__(com_object)
        self.tag_factory = com_object

    def create_tag(self, i_tag_name: str, o_tag: Tag) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub CreateTag(CATBSTR iTagName,
                | Tag oTag)
                | 
                |     Creates a Tag. Each Tag has a Name and a parent TagGroup.
                | 
                |     Parameters:
                | 
                |         iTagName
                |             Name of the Tag to be created. 
                |         oTag
                |             Newly created Tag. 
                | 
                |     Returns:
                |         An HRESULT.
                |         Legal values:
                | 
                |         S_OK
                |             Action is successfully created and the interface pointer is
                |             successfully returned
                |         E_FAIL
                |             Action was successfully created, but the interface query
                |             failed
                |         E_NOINTERFACE
                |             Action was successfully created, but the it doesn't implement the
                |             requested interface
                |         E_OUTOFMEMORY
                |             The component allocation failed
                | 
                |     Example:
                |
                |           Dim objTagFactory As TagFactory
                |           ...
                |           Dim objTag As Tag
                |           Dim TagName As String
                |           TagName =  "MY_TAG"
                |           objTagFactory.CreateTag TagName, objTag

        :param str i_tag_name:
        :param Tag o_tag:
        :rtype: None
        """
        return self.tag_factory.CreateTag(i_tag_name, o_tag.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'create_tag'
        # # vba_code = """
        # # Public Function create_tag(tag_factory)
        # #     Dim iTagName (2)
        # #     tag_factory.CreateTag iTagName
        # #     create_tag = iTagName
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def __repr__(self):
        return f'TagFactory(name="{self.name}")'
