#! usr/bin/python3.9
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-09-25 14:34:21.593357

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""
from pycatia.dnb_resource_program_interfaces.task import Task
from pycatia.system_interfaces.any_object import AnyObject


class ResourceProgramManager(AnyObject):
    """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.AnyObject
                |                     ResourceProgramManager
                | 
                | Represents the Resource Program manager of a resource.
                | 
                | Role: Resource Program manager is the object used to access the tasks
                | associated to the resource.
                | The following code snippet can be used to obtain the Resource Program manager
                | from the robot product.
                | 
                |    Dim objResourceProgramManager As ResourceProgramManager
                |    Dim objRobot as Product
                |    
                |    Set objResourceProgramManager = objRobot.GetTechnologicalObject("ResourceProgramManager" )
    
    """

    def __init__(self, com_object):
        super().__init__(com_object)
        self.resource_program_manager = com_object

    def get_all_tasks(self, o_task_list: tuple) -> Task:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub GetAllTasks(CATSafeArrayVariant oTaskList)
                | 
                |     Retrieves all the Tasks corresponding to this Resource.
                | 
                |     Parameters:
                | 
                |         oTaskList
                |             The list of Tasks. 
                | 
                |     Returns:
                |         An HRESULT.
                |         Legal values:
                | 
                |         S_OK
                |             The Tasks were corrrectly retrieved
                |         E_FAIL
                |             The Tasks were not corrrectly retrieved
                | 
                |         Example:
                |             The following example retrieves the list of tasks on the
                |             resource.
                | 
                |                Dim objResourceProgramManager As
                |                ResourceProgramManager
                |                Dim TaskList(3) As Task
                |                ..
                |                objResourceProgramManager.GetAllTasks TaskList

        :param tuple o_task_list:
        :rtype: Task
        """
        return Task(self.resource_program_manager.GetAllTasks(o_task_list))
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'get_all_tasks'
        # # vba_code = """
        # # Public Function get_all_tasks(resource_program_manager)
        # #     Dim oTaskList (2)
        # #     resource_program_manager.GetAllTasks oTaskList
        # #     get_all_tasks = oTaskList
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def get_task(self, i_task_name: str, o_task: Task) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub GetTask(CATBSTR iTaskName,
                | Task oTask)
                | 
                |     Retrieves the Tasks corresponding to the given Task Name.
                | 
                |     Parameters:
                | 
                |         iTaskName
                |             The name of the Task. 
                |         oTask
                |             The output Task. 
                | 
                |     Returns:
                |         An HRESULT.
                |         Legal values:
                | 
                |         S_OK
                |             The Task was corrrectly retrieved
                |         E_FAIL
                |             The Task was not corrrectly retrieved
                | 
                |         Example:
                |             The following example Retrieves the task corresponding the given
                |             task name.
                | 
                |                Dim objResourceProgramManager As
                |                ResourceProgramManager
                |                Dim oTask As Task
                |                ..
                |                objResourceProgramManager.GetTask  "RobotTask.1",
                |                oTask

        :param str i_task_name:
        :param Task o_task:
        :rtype: None
        """
        return self.resource_program_manager.GetTask(i_task_name, o_task.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'get_task'
        # # vba_code = """
        # # Public Function get_task(resource_program_manager)
        # #     Dim iTaskName (2)
        # #     resource_program_manager.GetTask iTaskName
        # #     get_task = iTaskName
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def __repr__(self):
        return f'ResourceProgramManager(name="{self.name}")'
