#! usr/bin/python3.9
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-09-25 14:34:21.593357

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""
from pycatia.dmaps_interfaces.activity import Activity
from pycatia.product_structure_interfaces.product import Product


class Task(Activity):
    """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.AnyObject
                |                     DMAPSInterfaces.Activity
                |                         Task
                | 
                | Represents the Task of a resource.
                | 
                | Role: Task is the object used to access and manage the attributes of the
                | task.
                | The following code snippet can be used to obtain the Task from the Resource
                | program manager.
                | 
                |    Dim objResourceProgramManager As ResourceProgramManager
                |    Dim oTask As Task
                |    
                |    objResourceProgramManager.GetTask  "RobotTask.1", oTask
    
    """

    def __init__(self, com_object):
        super().__init__(com_object)
        self.task = com_object

    def get_name(self, o_name: str) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub GetName(CATBSTR oName)
                | 
                |     Get the name of the Task
                | 
                |     Parameters:
                | 
                |         oName
                |             The user defined name of the Task. 
                | 
                |     Returns:
                |         An HRESULT.
                |         Legal values:
                | 
                |         S_OK
                |             The name of the task was corrrectly retrieved
                |         E_FAIL
                |             The name of the task was not corrrectly retrieved
                | 
                |         Example:
                |             The following example get the name of the task.
                | 
                |                Dim objTask As Task
                |                Dim strTaskName As String
                |                ..
                |                objTask.GetName strTaskName

        :param str o_name:
        :rtype: None
        """
        return self.task.GetName(o_name)

    def get_resource(self, o_res: Product) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub GetResource(Product oRes)
                | 
                |     Gets the Owning Resource
                | 
                |     Parameters:
                | 
                |         oRes
                |             The Owning Resource. 
                | 
                |     Returns:
                |         An HRESULT.
                |         Legal values:
                | 
                |         S_OK
                |             The owning resource was corrrectly retrieved
                |         E_FAIL
                |             The owning resource was not corrrectly retrieved
                | 
                |         Example:
                |             The following example retrieves the owning resource of the
                |             task.
                | 
                |                Dim objTask As Task   
                |                Dim objRobot as Product
                |                ..
                |                objTask.GetResource objRobot

        :param Product o_res:
        :rtype: None
        """
        return self.task.GetResource(o_res.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'get_resource'
        # # vba_code = """
        # # Public Function get_resource(task)
        # #     Dim oRes (2)
        # #     task.GetResource oRes
        # #     get_resource = oRes
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def set_name(self, i_name: str) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub SetName(CATBSTR iName)
                | 
                |     Set the name of the task
                | 
                |     Parameters:
                | 
                |         iName
                |             The user defined name of the Task. 
                | 
                |     Returns:
                |         An HRESULT.
                |         Legal values:
                | 
                |         S_OK
                |             The name of the task was set corrrectly 
                |         E_FAIL
                |             The name of the task was not set corrrectly 
                | 
                |         Example:
                |             The following example set the name of the task.
                | 
                |                Dim objTask As Task     
                |                ..
                |                objTask.SetName("RobotTask.2")

        :param str i_name:
        :rtype: None
        """
        return self.task.SetName(i_name)

    def __repr__(self):
        return f'Task(name="{self.name}")'
