#! usr/bin/python3.9
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-09-25 14:34:21.593357

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""
from typing import TYPE_CHECKING

from pycatia.system_interfaces.any_object import AnyObject

if TYPE_CHECKING:
    from pycatia.dnb_robot_interfaces.rob_generic_controller import RobGenericController


class GenericObjFrameProfile(AnyObject):
    """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.AnyObject
                |                     GenericObjFrameProfile
                | 
                | Interface to manage Generic Object frame Profile of Robot
                | controller.
                | 
                | Role: This interface provides methods to get/set data related to Object
                | Profile.
    
    """

    def __init__(self, com_object):
        super().__init__(com_object)
        self.generic_obj_frame_profile = com_object

    def get_controller(self, o_controller: 'RobGenericController') -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub GetController(RobGenericController oController)
                | 
                |     Retrieves controller owning the profile.
                | 
                |     Parameters:
                | 
                |         oController
                |             This parameter contains pointer to controller. 
                | 
                |     Returns:
                |         An HRESULT.
                |         Legal values:
                | 
                |             S_OK if the operation succeeds
                |             E_FAIL otherwise

        :param RobGenericController o_controller:
        :rtype: None
        """
        return self.generic_obj_frame_profile.GetController(o_controller.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'get_controller'
        # # vba_code = """
        # # Public Function get_controller(generic_obj_frame_profile)
        # #     Dim oController (2)
        # #     generic_obj_frame_profile.GetController oController
        # #     get_controller = oController
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def get_name(self, o_name: str) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub GetName(CATBSTR oName)
                | 
                |     Gets name of the Object frame Profile.
                | 
                |     Parameters:
                | 
                |         oName
                |             Name of the required Object frame Profile. 
                | 
                |     Returns:
                |         an HRESULT value.
                |         Legal values:
                | 
                |             S_OK if the operation succeeds
                |             E_FAIL otherwise

        :param str o_name:
        :rtype: None
        """
        return self.generic_obj_frame_profile.GetName(o_name)

    def get_object_frame(self, x: float, y: float, z: float, roll: float, pitch: float, yaw: float) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub GetObjectFrame(double x,
                | double y,
                | double z,
                | double roll,
                | double pitch,
                | double yaw)
                | 
                |     Retrieve the underlying x,y,z, roll, pitch, yaw of the Object
                |     Frame.
                | 
                |     Parameters:
                | 
                |         x,
                |             The X Coordinate. 
                |         y,
                |             The Y Coordinate. 
                |         z,
                |             The Z Coordinate. 
                |         roll,
                |             The roll Coordinate. 
                |         pitch,
                |             The pitch Coordinate. 
                |         yaw,
                |             The yaw Coordinate. 
                | 
                |     Returns:
                |         an HRESULT value.
                |         Legal values:
                | 
                |             S_OK if the operation succeeds
                |             E_FAIL otherwise

        :param float x:
        :param float y:
        :param float z:
        :param float roll:
        :param float pitch:
        :param float yaw:
        :rtype: None
        """
        return self.generic_obj_frame_profile.GetObjectFrame(x, y, z, roll, pitch, yaw)

    def set_name(self, i_name: str) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub SetName(CATBSTR iName)
                | 
                |     Set name of the Object frame Profile.
                | 
                |     Parameters:
                | 
                |         iName
                |             Name of the Object frame Profile to be set. 
                | 
                |     Returns:
                |         an HRESULT value.
                |         Legal values:
                | 
                |             S_OK if the operation succeeds
                |             E_FAIL otherwise

        :param str i_name:
        :rtype: None
        """
        return self.generic_obj_frame_profile.SetName(i_name)

    def set_object_frame(self, x: float, y: float, z: float, roll: float, pitch: float, yaw: float) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub SetObjectFrame(double x,
                | double y,
                | double z,
                | double roll,
                | double pitch,
                | double yaw)
                | 
                |     Set the underlying x,y,z, roll, pitch, yaw of the Object
                |     Frame.
                | 
                |     Parameters:
                | 
                |         x,
                |             The X Coordinate. 
                |         y,
                |             The Y Coordinate. 
                |         z,
                |             The Z Coordinate. 
                |         roll,
                |             The roll Coordinate. 
                |         pitch,
                |             The pitch Coordinate. 
                |         yaw,
                |             The yaw Coordinate. 
                | 
                |     Returns:
                |         an HRESULT value.
                |         Legal values:
                | 
                |             S_OK if the operation succeeds
                |             E_FAIL otherwise

        :param float x:
        :param float y:
        :param float z:
        :param float roll:
        :param float pitch:
        :param float yaw:
        :rtype: None
        """
        return self.generic_obj_frame_profile.SetObjectFrame(x, y, z, roll, pitch, yaw)

    def __repr__(self):
        return f'GenericObjFrameProfile(name="{self.name}")'
