#! usr/bin/python3.9
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-09-25 14:34:21.593357

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""
from pycatia.dnb_robot_interfaces.generic_accuracy_profile import GenericAccuracyProfile
from pycatia.dnb_robot_interfaces.generic_motion_profile import GenericMotionProfile
from pycatia.dnb_robot_interfaces.generic_obj_frame_profile import GenericObjFrameProfile
from pycatia.dnb_robot_interfaces.generic_tool_profile import GenericToolProfile
from pycatia.system_interfaces.any_object import AnyObject


class RobControllerFactory(AnyObject):
    """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.AnyObject
                |                     RobControllerFactory
                | 
                | Interface to manipulate Robot Controller.
                | Role: This interface provides methods to operate attributes related to robot
                | controller, especially profiles.
    
    """

    def __init__(self, com_object):
        super().__init__(com_object)
        self.rob_controller_factory = com_object

    def create_generic_accuracy_profile(self, o_accuracy_profile: GenericAccuracyProfile) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub CreateGenericAccuracyProfile(GenericAccuracyProfile
                | oAccuracyProfile)
                | 
                |     Creates a Generic Accuracy Profile.
                | 
                |     Parameters:
                | 
                |         oAccuracyProfile
                |             Created Accuracy Profile. 
                | 
                |     Returns:
                |         an HRESULT value.
                |         Legal values:
                | 
                |             S_OK if the operation succeeds
                |             E_FAIL otherwise

        :param GenericAccuracyProfile o_accuracy_profile:
        :rtype: None
        """
        return self.rob_controller_factory.CreateGenericAccuracyProfile(o_accuracy_profile.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'create_generic_accuracy_profile'
        # # vba_code = """
        # # Public Function create_generic_accuracy_profile(rob_controller_factory)
        # #     Dim oAccuracyProfile (2)
        # #     rob_controller_factory.CreateGenericAccuracyProfile oAccuracyProfile
        # #     create_generic_accuracy_profile = oAccuracyProfile
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def create_generic_motion_profile(self, o_motion_profile: GenericMotionProfile) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub CreateGenericMotionProfile(GenericMotionProfile
                | oMotionProfile)
                | 
                |     Creates a Generic Motion Profile.
                | 
                |     Parameters:
                | 
                |         oMotionProfile
                |             Created Motion Profile. 
                | 
                |     Returns:
                |         an HRESULT value.
                |         Legal values:
                | 
                |             S_OK if the operation succeeds
                |             E_FAIL otherwise

        :param GenericMotionProfile o_motion_profile:
        :rtype: None
        """
        return self.rob_controller_factory.CreateGenericMotionProfile(o_motion_profile.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'create_generic_motion_profile'
        # # vba_code = """
        # # Public Function create_generic_motion_profile(rob_controller_factory)
        # #     Dim oMotionProfile (2)
        # #     rob_controller_factory.CreateGenericMotionProfile oMotionProfile
        # #     create_generic_motion_profile = oMotionProfile
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def create_generic_obj_frame_profile(self, o_obj_frame_profile: GenericObjFrameProfile) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub CreateGenericObjFrameProfile(GenericObjFrameProfile
                | oObjFrameProfile)
                | 
                |     Creates a Generic Object-Frame Profile.
                | 
                |     Parameters:
                | 
                |         oObjFrameProfile
                |             Created ObjFrame Profile. 
                | 
                |     Returns:
                |         an HRESULT value.
                |         Legal values:
                | 
                |             S_OK if the operation succeeds
                |             E_FAIL otherwise

        :param GenericObjFrameProfile o_obj_frame_profile:
        :rtype: None
        """
        return self.rob_controller_factory.CreateGenericObjFrameProfile(o_obj_frame_profile.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'create_generic_obj_frame_profile'
        # # vba_code = """
        # # Public Function create_generic_obj_frame_profile(rob_controller_factory)
        # #     Dim oObjFrameProfile (2)
        # #     rob_controller_factory.CreateGenericObjFrameProfile oObjFrameProfile
        # #     create_generic_obj_frame_profile = oObjFrameProfile
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def create_generic_tool_profile(self, o_tool_profile: GenericToolProfile) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub CreateGenericToolProfile(GenericToolProfile
                | oToolProfile)
                | 
                |     Creates a Generic Tool Profile.
                | 
                |     Parameters:
                | 
                |         oToolProfile
                |             Created Tool Profile. 
                | 
                |     Returns:
                |         an HRESULT value.
                |         Legal values:
                | 
                |             S_OK if the operation succeeds
                |             E_FAIL otherwise

        :param GenericToolProfile o_tool_profile:
        :rtype: None
        """
        return self.rob_controller_factory.CreateGenericToolProfile(o_tool_profile.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'create_generic_tool_profile'
        # # vba_code = """
        # # Public Function create_generic_tool_profile(rob_controller_factory)
        # #     Dim oToolProfile (2)
        # #     rob_controller_factory.CreateGenericToolProfile oToolProfile
        # #     create_generic_tool_profile = oToolProfile
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def __repr__(self):
        return f'RobControllerFactory(name="{self.name}")'
