#! usr/bin/python3.9
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-09-25 14:34:21.593357

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""

from pycatia.system_interfaces.any_object import AnyObject


class TCPTraceManagerGraphics(AnyObject):
    """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.AnyObject
                |                     TCPTraceManagerGraphics
                | 
                | Interface used to modify the default graphical properties of TCP
                | traces.
                | 
                | Role: This interface is used to overload the next TCP traces and points
                | graphical properties.
                | 
                | A TCP trace is the graphical output of a task simulation. This output is the
                | trajectory path generated by the TCP, defined by lines and points. Each point
                | represents the location of the TCP at a given time.
                | 
                | The following code snippet can be used to obtain a handle from a
                | product:
                | 
                |    Dim MyRobot As Product
                |    'retrieval of the product
                |    ...
                | 
                |    'retrieval of the trace manager
                |    Dim objDevice As TCPTraceManagerGraphics
                |    set objDevice = MyRobot.GetTechnologicalObject("TCPTraceManagerGraphics")
                |    
                |    Dim iR As Long
                |    Dim iG As Long
                |    Dim iB As Long
                |    Dim iA As Long
                |    
                |    'activate the trace
                |    objDevice.SetTraceNextColor DNBTCPTraceRepLine,iR,iG,iB,iA
                |
                | See also:
                |     TCPTrace 
                | See also:
                |     TCPTraceManager
    
    """

    def __init__(self, com_object):
        super().__init__(com_object)
        self.tcp_trace_manager_graphics = com_object

    def set_next_thickness(self, i_rep: int, i_thickness: int) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub SetNextThickness(DNBTCPTraceReps iRep,
                | long iThickness)
                | 
                |     Set the TCP trace component (DNBTCPTraceReps) thickness(for line, axis) for
                |     new points.This method does not modify the type for the complete path (as
                |     TCPTrace.SetThickness does). Instead, it changes the current type to apply for
                |     newly created points. This method is usefull, when the user interrupts the
                |     simulation and want to render differently the next points to be
                |     created.
                | 
                |     Parameters:
                | 
                |         iRep
                |             DNBTCPTraceReps. Define the graphical object the method will be
                |             applied on. Input parameter. 
                |         iThickness
                |             Indicates the index width of the line in the range [1,55]. This
                |             index is pointing on the true width in pixel, recorded in the standard (if
                |             there is one in the document) or in the setting. Input parameter.

        :param int i_rep: enum dnbtcp_trace_reps
        :param int i_thickness:
        :rtype: None
        """
        return self.tcp_trace_manager_graphics.SetNextThickness(i_rep, i_thickness)

    def set_next_type(self, i_rep: int, i_type: int) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub SetNextType(DNBTCPTraceReps iRep,
                | long iType)
                | 
                |     Set the TCP trace component (DNBTCPTraceReps) type for new points. This
                |     method does not modify the type for the complete path (as TCPTrace.SetType
                |     does). Instead, it changes the current type to apply for newly created points.
                |     This method is usefull, when the user interrupts the simulation and want to
                |     render differently the next points to be created. For points, legal values are
                |     :
                | 
                |         1 : CROSS
                |         2 : PLUS
                |         3 : CONCENTRIC
                | 
                |     For line and axis, legal values are :
                | 
                |         1 : solid
                |         2 : dotted
                |         3 : dashed
                |         4 : dot-dashed
                |         5 : phantom
                | 
                |     Call < to see the changes applied.
                | 
                |     Parameters:
                | 
                |         iRep
                |             DNBTCPTraceReps. Define the graphical object the method will be
                |             applied on. Input parameter. 
                |         iType
                |             Long.Depends on the DNBTCPTraceReps. Input parameter.
                |
                |     Returns:
                |         HRESULT Returns S_OK if it succeeds, otherwise E_FAIL.

        :param int i_rep: enum dnbtcp_trace_reps
        :param int i_type:
        :rtype: None
        """
        return self.tcp_trace_manager_graphics.SetNextType(i_rep, i_type)

    def set_trace_next_colour(self, i_rep: int, i_r: int, i_g: int, i_b: int, i_a: int) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub SetTraceNextColor(DNBTCPTraceReps iRep,
                | long iR,
                | long iG,
                | long iB,
                | long iA)
                | 
                |     Set the TCP trace component (DNBTCPTraceReps) color for new points. This
                |     method does not modify the complete color path (as TCPTrace.SetColor does).
                |     Instead, it changes the current color to apply for newly created points. This
                |     method is usefull, when the user interrupts the simulation and want to render
                |     differently the next points to be created.
                | 
                |     Parameters:
                | 
                |         iRep
                |             DNBTCPTraceReps. Define the graphical object the method will be
                |             applied on. Input parameter. 
                |         iR
                |             Long. Red color component from 0 to 255. Input parameter.
                |             
                |         iG
                |             Long. Green color component from 0 to 255. Input parameter.
                |             
                |         iB
                |             Long. Blue color component from 0 to 255. Input parameter.
                |             
                |         iA
                |             Long. Alpha color component from 0 to 255. Input parameter.

        :param int i_rep: enum dnbtcp_trace_reps
        :param int i_r:
        :param int i_g:
        :param int i_b:
        :param int i_a:
        :rtype: None
        """
        return self.tcp_trace_manager_graphics.SetTraceNextColor(i_rep, i_r, i_g, i_b, i_a)

    def __repr__(self):
        return f'TCPTraceManagerGraphics(name="{self.name}")'
