#! usr/bin/python3.9
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-09-25 14:34:21.593357

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""
from pycatia.dmaps_interfaces.activity import Activity
from pycatia.product_structure_interfaces.product import Product


class ReleaseAct(Activity):
    """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.AnyObject
                |                     DMAPSInterfaces.Activity
                |                         ReleaseAct
                | 
                | Interface representing a Release activity.
                | 
                | Role: This interface is used to retrieve/assign the value of attributes for the
                | Release activity.
                | The following code snippet can be used to obtain a ReleaseAct from a selected
                | Activity
                | 
                |    Dim oSelectAct As Activity
                |    set oSelectAct = CATIA.ActiveDocument.Selection.FindObject("CATIAActivity")
                |    Dim objReleaseAct As ReleaseAct
                |    set objReleaseAct = oSelectAct.GetTechnologicalObject("ReleaseAct")
    
    """

    def __init__(self, com_object):
        super().__init__(com_object)
        self.release_act = com_object

    @property
    def grabbing_object(self) -> Product:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)
                | o Property GrabbingObject() As Product
                | 
                |     Sets and retrieves the grabbing object
                | 
                |     Returns:
                |         oGrabbingObject The grabbing object. 
                |     Parameters:
                | 
                |         iGrabbingObject
                |             The specified grabbing object

        :rtype: Product
        """

        return Product(self.release_act.GrabbingObject)

    @grabbing_object.setter
    def grabbing_object(self, value: Product):
        """
        :param Product value:
        """

        self.release_act.GrabbingObject = value

    def get_grabbed_objects(self, o_grabbed_objects: tuple) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub GetGrabbedObjects(CATSafeArrayVariant oGrabbedObjects)
                | 
                |     Sets and retrieves the grabbed objects
                | 
                |     Returns:
                |         oGrabbedObjects The grabbed object. 
                |     Parameters:
                | 
                |         iGrabbedObjects
                |             The specified grabbed objects

        :param tuple o_grabbed_objects:
        :rtype: None
        """
        return self.release_act.GetGrabbedObjects(o_grabbed_objects)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'get_grabbed_objects'
        # # vba_code = """
        # # Public Function get_grabbed_objects(release_act)
        # #     Dim oGrabbedObjects (2)
        # #     release_act.GetGrabbedObjects oGrabbedObjects
        # #     get_grabbed_objects = oGrabbedObjects
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def put_grabbed_objects(self, i_grabbed_objects: tuple) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub PutGrabbedObjects(CATSafeArrayVariant iGrabbedObjects)

        :param tuple i_grabbed_objects:
        :rtype: None
        """
        return self.release_act.PutGrabbedObjects(i_grabbed_objects)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'put_grabbed_objects'
        # # vba_code = """
        # # Public Function put_grabbed_objects(release_act)
        # #     Dim iGrabbedObjects (2)
        # #     release_act.PutGrabbedObjects iGrabbedObjects
        # #     put_grabbed_objects = iGrabbedObjects
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def __repr__(self):
        return f'ReleaseAct(name="{self.name}")'
