#! usr/bin/python3.9
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-09-25 14:34:21.593357

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""
from pycatia.dmaps_interfaces.activity import Activity
from pycatia.in_interfaces.position import Position
from pycatia.system_interfaces.any_object import AnyObject


class DNB3DState(AnyObject):
    """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.AnyObject
                |                     DNB3DState
                | 
                | Interface representing the 3D State object.
                | 
                | Role: Represents a 3D State object and provides APIs to update an existing 3D
                | state object.
    
    """

    def __init__(self, com_object):
        super().__init__(com_object)
        self.dnb_3d_state = com_object

    @property
    def state_name(self) -> str:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)
                | o Property StateName() As CATBSTR
                | 
                |     Returns or sets the Name of the 3D State.
                | 
                |     Example:
                |         This example fetches the Name of a 3D State.
                | 
                |          Dim stateName As String
                |          stateName = mySelected3DState.StateName
                |
                |         This example sets the Name of a 3D State.
                | 
                |          mySelected3DState.StateName = "NewStateName"

        :rtype: str
        """

        return self.dnb_3d_state.StateName

    @state_name.setter
    def state_name(self, value: str):
        """
        :param str value:
        """

        self.dnb_3d_state.StateName = value

    def add_3d_position(self, i_position: Position) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub Add3DPosition(DNBIA3DStatePosition iPosition)
                | 
                |     Adds the specified 3D Position to the given 3D state as a child. This input
                |     state object should be defined inside the product hierarchy of the ‘this’
                |     state. Otherwise this method would return E_FAIL.
                | 
                |     Parameters:
                | 
                |         iPosition
                |             The 3D position object to be added.
                | 
                |             Example:
                |                 This example adds a specified 3D position to a 3D State as a
                |                 child.
                | 
                |                  Dim myState1 As DNB3DState
                |                  Dim myPostion As DNB3DStatePosition
                |                  myPostion = 
                |                  myState1.Add3DState(myPostion)

        :param DNBIA3DStatePosition i_position:
        :rtype: None
        """
        return self.dnb_3d_state.Add3DPosition(i_position.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'add3_d_position'
        # # vba_code = """
        # # Public Function add3_d_position(dnb3_d_state)
        # #     Dim iPosition (2)
        # #     dnb3_d_state.Add3DPosition iPosition
        # #     add3_d_position = iPosition
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def add_3d_state(self, i_state: 'DNB3DState') -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub Add3DState(DNB3DState iState)
                | 
                |     Adds the specified 3D state to the given 3D state as a child. This input
                |     state object should be defined inside the product hierarchy of the ‘this’
                |     state. Otherwise this method would return E_FAIL.
                | 
                |     Parameters:
                | 
                |         iState
                |             The 3D State object to be added.
                | 
                |             Example:
                |                 This example adds a specified 3D state to a 3D State as a
                |                 child.
                | 
                |                  Dim myState1 As DNB3DState
                |                  Dim myState2 As DNB3DState
                |                  myState2 = 
                |                  myState1.Add3DState(myState2)

        :param DNB3DState i_state:
        :rtype: None
        """
        return self.dnb_3d_state.Add3DState(i_state.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'add3_d_state'
        # # vba_code = """
        # # Public Function add3_d_state(dnb3_d_state)
        # #     Dim iState (2)
        # #     dnb3_d_state.Add3DState iState
        # #     add3_d_state = iState
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def assign_3d_state(self, i_process: Activity, i_condition: str) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub Assign3DState(Activity iProcess,
                | CATBSTR iCondition)
                | 
                |     Assigns the 3D state to a specified process, based on the given
                |     condition.
                | 
                |     Parameters:
                | 
                |         iProcess
                |             The activity to which the 3D state is to be assigned.
                |             
                |         iCondition
                |             The condition on which the 3D state is assigned to the specified
                |             process. iCondition should be one of "Begin Condition" or "End Condition" or
                |             "3D Context"
                | 
                |             Example:
                |                 This example assigns myState to mySelectedAct as a "Begin
                |                 Condition" .
                | 
                |                  Dim myState As DNB3DState
                |                  mySelectedAct = 
                |                  myState = 
                |                  myState1.Assign3DState(mySelectedAct, "Begin
                |                  Condition")

        :param Activity i_process:
        :param str i_condition:
        :rtype: None
        """
        return self.dnb_3d_state.Assign3DState(i_process.com_object, i_condition)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'assign3_d_state'
        # # vba_code = """
        # # Public Function assign3_d_state(dnb3_d_state)
        # #     Dim iProcess (2)
        # #     dnb3_d_state.Assign3DState iProcess
        # #     assign3_d_state = iProcess
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def get_children(self, i_type: str, o_children_array: tuple) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub GetChildren(CATBSTR iType,
                | CATSafeArrayVariant oChildrenArray)
                | 
                |     Returns the list of all the 3D states or 3D positions or both, managed by
                |     the given 3D state.
                | 
                |     Parameters:
                | 
                |         iType
                |             The type of children to be obtained which can be "3D State" or "3D
                |             Position" or "All". 
                | 
                |     Returns:
                |         oChildrenArray The list of 3D states or 3D positions or both, managed
                |         by the given 3D state.
                | 
                |         Example:
                |             This example returns the list of 3D States managed by
                |             myState.
                | 
                |              Dim myState As DNB3DState
                |              Dim statesArray() 
                |              myState = 
                |              numStates = myState.GetNumberOfChildren("3D State")
                |              Redim statesArray(numStates - 1)
                |              myState.GetChildren "3D State",statesArray

        :param str i_type:
        :param tuple o_children_array:
        :rtype: None
        """
        return self.dnb_3d_state.GetChildren(i_type, o_children_array)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'get_children'
        # # vba_code = """
        # # Public Function get_children(dnb3_d_state)
        # #     Dim iType (2)
        # #     dnb3_d_state.GetChildren iType
        # #     get_children = iType
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def get_condition_name(self, i_related_activity: Activity) -> str:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Func GetConditionName(Activity iRelatedActivity) As
                | CATBSTR
                | 
                |     Returns the condition type on which the 3D State has been assigned to a
                |     specified activity.
                | 
                |     Parameters:
                | 
                |         iRelatedActivity
                |             The activity to which the 3D state has been assigned based on a
                |             condition. 
                | 
                |     Returns:
                |         oConditonName The condition type on which the 3D State has been
                |         assigned and can have the value as "Begin Condition" or "End Condition" or "3D
                |         Context"
                | 
                |         Example:
                |             This example returns the condition on which the given activity has
                |             been assigned to the state.
                | 
                |              Dim myState As DNB3DState
                |              Dim conditionName as String
                |              Dim activitiesArray()
                |              myState = 
                |              mySelectedAct = 
                |              conditionName = myState.GetConditionName(iRelatedActivity)

        :param Activity i_related_activity:
        :rtype: str
        """
        return self.dnb_3d_state.GetConditionName(i_related_activity.com_object)

    def get_number_of_children(self, i_type: str) -> int:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Func GetNumberOfChildren(CATBSTR iType) As long
                | 
                |     Returns the number of 3D states or 3D positions or both, managed by the
                |     given 3D state.
                | 
                |     Parameters:
                | 
                |         iType
                |             The type of children to be obtained which can be "3D State" or "3D
                |             Position" or "All". 
                | 
                |     Returns:
                |         oNumberOfChild The number of 3D states or 3D positions or both, managed
                |         by the given 3D state.
                | 
                |         Example:
                |             This example returns the number of 3D States managed by
                |             myState.
                | 
                |              Dim myState As DNB3DState
                |              Dim statesArray() 
                |              myState = 
                |              numStates = myState.GetNumberOfChildren("3D State")

        :param str i_type:
        :rtype: int
        """
        return self.dnb_3d_state.GetNumberOfChildren(i_type)

    def get_number_of_related_activities(self, i_condition_type: str) -> int:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Func GetNumberofRelatedActivities(CATBSTR iConditionType) As
                | long
                | 
                |     Returns the number of activities/processes associated with the 3D State
                |     based on the condition on which the state has been
                |     assigned.
                | 
                |     Parameters:
                | 
                |         iConditionType
                |             The condition on which the state has been assigned. The condition
                |             type should be one of "Begin Condition" or "End Condition" or "3D Context" or
                |             "All". 
                | 
                |     Returns:
                |         oNumActivities The number of activities assigned to the given 3D state
                |         based on the specified condition.
                | 
                |         Example:
                |             This example returns the number of activities assigned to myState
                |             as a "End Condition".
                | 
                |              Dim myState As DNB3DState
                |              Dim activitiesArray()
                |              myState = 
                |              numOfActivities = myState.GetNumberofRelatedActivities("End Conditon")

        :param str i_condition_type:
        :rtype: int
        """
        return self.dnb_3d_state.GetNumberofRelatedActivities(i_condition_type)

    def get_parent(self) -> AnyObject:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Func GetParent() As CATBaseDispatch
                | 
                |     Returns the parent for the 3D State
                | 
                |     Returns:
                |         oParent The parent under which the 3D state has been created which
                |         could be "3D States" or "Mfg Positions"
                | 
                |         Example:
                |             This example returns the number of activities assigned to myState
                |             as a "End Condition".
                | 
                |              Dim myState As DNB3DState
                |              myState = 
                |              parentObj = myState.GetParent

        :rtype: AnyObject
        """
        return self.dnb_3d_state.GetParent()

    def get_related_activities(self, i_condition_type: str, o_activities_array: tuple) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub GetRelatedActivities(CATBSTR iConditionType,
                | CATSafeArrayVariant oActivitiesArray)
                | 
                |     Returns the list of activities/processes associated with the 3D State based
                |     on the condition on which the state has been assigned.
                | 
                |     Parameters:
                | 
                |         iConditionType
                |             The condition on which the state has been assigned. The condition
                |             type should be one of "Begin Condition" or "End Condition" or "3D Context" or
                |             "All". 
                | 
                |     Returns:
                |         oActivitiesArray The list of activities assigned to the given 3D state
                |         based on the specified condition.
                | 
                |         Example:
                |             This example returns the list of activities assigned to myState as
                |             a "End Condition".
                | 
                |              Dim myState As DNB3DState
                |              Dim activitiesArray()
                |              myState = 
                |              numOfActivities = myState.GetNumberofRelatedActivities("End Conditon")
                |              Redim activitiesArray(numOfActivities - 1)
                |              myState.GetRelatedActivities "End
                |              Conditon",activitiesArray

        :param str i_condition_type:
        :param tuple o_activities_array:
        :rtype: None
        """
        return self.dnb_3d_state.GetRelatedActivities(i_condition_type, o_activities_array)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'get_related_activities'
        # # vba_code = """
        # # Public Function get_related_activities(dnb3_d_state)
        # #     Dim iConditionType (2)
        # #     dnb3_d_state.GetRelatedActivities iConditionType
        # #     get_related_activities = iConditionType
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def get_related_object(self) -> AnyObject:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Func GetRelatedObject() As CATBaseDispatch
                | 
                |     Returns the product/resource/MA/ASTMA on which the given state is being
                |     defined.
                | 
                |     Returns:
                |         oRelatedObj The product/resource/MA/ASTMA on which the given state is
                |         being defined.
                | 
                |         Example:
                |             This example returns the product/resource/MA/ASTMA on which the
                |             given state is being defined.
                | 
                |              Dim myState As DNB3DState
                |              myState = 
                |              Set relObj = myState.GetRelatedObject

        :rtype: AnyObject
        """
        return self.dnb_3d_state.GetRelatedObject()

    def remove_3d_position(self, i_position: Position) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub Remove3DPosition(DNBIA3DStatePosition iPosition)
                | 
                |     Removes the specified 3D position from the given 3D state’s definition
                |     list
                | 
                |     Parameters:
                | 
                |         iPosition
                |             The 3D position object to be removed.
                | 
                |             Example:
                |                 This example removes a specified 3D state from a 3D state's
                |                 definition list .
                | 
                |                  Dim myState1 As DNB3DState
                |                  Dim myPostion As DNB3DStatePosition
                |                  myPostion = 
                |                  myState1.Remove3DPosition(myPostion)

        :param DNBIA3DStatePosition i_position:
        :rtype: None
        """
        return self.dnb_3d_state.Remove3DPosition(i_position.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'remove3_d_position'
        # # vba_code = """
        # # Public Function remove3_d_position(dnb3_d_state)
        # #     Dim iPosition (2)
        # #     dnb3_d_state.Remove3DPosition iPosition
        # #     remove3_d_position = iPosition
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def remove_3d_state(self, i_state: 'DNB3DState') -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub Remove3DState(DNB3DState iState)
                | 
                |     Removes the specified 3D state from the given 3D state’s definition
                |     list
                | 
                |     Parameters:
                | 
                |         iState
                |             The 3D State object to be removed.
                | 
                |             Example:
                |                 This example removes a specified 3D state from a 3D state's
                |                 definition list .
                | 
                |                  Dim myState1 As DNB3DState
                |                  Dim myState2 As DNB3DState
                |                  myState2 = 
                |                  myState1.Remove3DState(myState2)

        :param DNB3DState i_state:
        :rtype: None
        """
        return self.dnb_3d_state.Remove3DState(i_state.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'remove3_d_state'
        # # vba_code = """
        # # Public Function remove3_d_state(dnb3_d_state)
        # #     Dim iState (2)
        # #     dnb3_d_state.Remove3DState iState
        # #     remove3_d_state = iState
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def unassign_3d_state(self, i_process: Activity) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub Unassign3DState(Activity iProcess)
                | 
                |     Unassigns the 3D state from a specified process.
                | 
                |     Parameters:
                | 
                |         iProcess
                |             The activity from which the 3D state is to be
                |             unassigned.
                | 
                |             Example:
                |                 This example unassigns myState from
                |                 mySelectedAct.
                | 
                |                  Dim myState As DNB3DState
                |                  mySelectedAct = 
                |                  myState = 
                |                  myState.Assign3DState(mySelectedAct)

        :param Activity i_process:
        :rtype: None
        """
        return self.dnb_3d_state.Unassign3DState(i_process.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'unassign3_d_state'
        # # vba_code = """
        # # Public Function unassign3_d_state(dnb3_d_state)
        # #     Dim iProcess (2)
        # #     dnb3_d_state.Unassign3DState iProcess
        # #     unassign3_d_state = iProcess
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def __repr__(self):
        return f'DNB3DState(name="{self.name}")'
