#! usr/bin/python3.9
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-09-25 14:34:21.593357

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""
from pycatia.dmaps_interfaces.activity import Activity
from pycatia.dnb_state_interfaces.dnb_3d_state import DNB3DState
from pycatia.dnb_state_interfaces.dnb_3d_states import DNB3DStates
from pycatia.system_interfaces.any_object import AnyObject


class DNB3DStateManagement(AnyObject):
    """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.AnyObject
                |                     DNB3DStateManagement
                | 
                | Interface representing the 3D State Management in the
                | CATDocument.
                | 
                | Role: Provides access the C++ interfaces DNBIState, DNBIStateMgt to create and
                | manage the 3D States.
    
    """

    def __init__(self, com_object):
        super().__init__(com_object)
        self.dnb_3d_state_management = com_object

    def create_3d_state(self, i_state_name: str, i_object: AnyObject, i_list_defn: tuple) -> DNB3DState:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Func Create3DState(CATBSTR iStateName,
                | CATBaseDispatch iObject,
                | CATSafeArrayVariant iListDefn) As DNB3DState
                | 
                |     Creates a 3D State object
                | 
                |     Parameters:
                | 
                |         iStateName
                |             The name of the 3D State to be created. 
                |         iObject
                |             The object(Resource/MA/Product..)on which the state is to be
                |             created 
                |         iListDefn
                |             The definition list(an existing 3D State/3D Position) on which the
                |             new state is to be created 
                | 
                |     Returns:
                |         oState The 3D State object created.
                | 
                |         Example:
                |             For example, Creating a 3D State with the name "My NewState" on the
                |             already existing 3D State "My State".
                | 
                |              Dim MySelectedProduct
                |              Dim MySelectedState as DNB3DState
                |              Dim MyNewState1 as DNB3DState
                |              defnArray[0] = MySelectedState
                |              Set MyNewState1 = stateManagement.Create3DState("My NewState",MySelectedProduct,defnArray)

        :param str i_state_name:
        :param AnyObject i_object:
        :param tuple i_list_defn:
        :rtype: DNB3DState
        """
        return DNB3DState(self.dnb_3d_state_management.Create3DState(i_state_name, i_object.com_object, i_list_defn))

    def delete_3d_state(self, i_state: DNB3DState) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub Delete3DState(DNB3DState iState)
                | 
                |     Deletes the specified state object
                | 
                |     Parameters:
                | 
                |         iState
                |             The 3D State object to be deleted.
                | 
                |             Example:
                | 
                |                  Dim MySelectedProduct
                |                  Dim MySelectedState as DNB3DState
                |                 
                |                 stateManagement.Delete3DState(MySelectedState)

        :param DNB3DState i_state:
        :rtype: None
        """
        return self.dnb_3d_state_management.Delete3DState(i_state.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'delete3_d_state'
        # # vba_code = """
        # # Public Function delete3_d_state(dnb3_d_state_management)
        # #     Dim iState (2)
        # #     dnb3_d_state_management.Delete3DState iState
        # #     delete3_d_state = iState
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def get_3d_state(self, i_object: AnyObject, i_state_name: str) -> DNB3DState:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Func Get3DState(CATBaseDispatch iObject,
                | CATBSTR iStateName) As DNB3DState
                | 
                |     Returns the 3D State object given its name and the
                |     object(Resource/MA/Product..) on which the state is
                |     created.
                | 
                |     Parameters:
                | 
                |         iObject
                |             The object(Resource/MA/Product..), on which the state is created.
                |             
                |         iStateName
                |             The name of the 3D State. 
                | 
                |     Returns:
                |         oState The 3D States object.
                | 
                |         Example:
                | 
                |              Dim MySelectedProduct
                |              Dim state as DNB3DState
                |              Set state = stateManagement.GetState(MySelectedProduct, "My State1")

        :param AnyObject i_object:
        :param str i_state_name:
        :rtype: DNB3DState
        """
        return DNB3DState(self.dnb_3d_state_management.Get3DState(i_object.com_object, i_state_name))

    def get_number_of_3d_states(self) -> int:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Func GetNumberOf3DStates() As long
                | 
                |     Returns the number of 3D State objects in the process
                |     document
                | 
                |     Returns:
                |         numberOfStates The number of 3D States in the current
                |         document.
                | 
                |         Example:
                | 
                |              stateCount = stateManagement.GetNumberOf3DStates

        :rtype: int
        """
        return self.dnb_3d_state_management.GetNumberOf3DStates()

    def get_number_of_3d_states_on_object(self, i_obj: AnyObject) -> int:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Func GetNumberOf3DStatesOnObject(CATBaseDispatch iObj) As
                | long
                | 
                |     Returns the number of 3D State objects on a given
                |     object(Resource/MA/Product..)
                | 
                |     Parameters:
                | 
                |         iObject
                |             The object(Resource/MA/Product..), whose states are to be listed.
                | 
                |     Returns:
                |         numberOfStates The number of 3D States created on
                |         iObjec.
                | 
                |         Example:
                | 
                |              stateCount = stateManagement.GetNumberOf3DStatesOnObject(MySelectedProduct)

        :param AnyObject i_obj:
        :rtype: int
        """
        return self.dnb_3d_state_management.GetNumberOf3DStatesOnObject(i_obj.com_object)

    def get_number_of_3d_states_in_activity(self, i_process: Activity, i_condition_type: str) -> int:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Func GetNumberof3DStatesInActivity(Activity iProcess,
                | CATBSTR iConditionType) As long
                | 
                |     Returns the number of 3D states assigned to the given activity, based on
                |     the condition on which the activity has been assigned to the 3D
                |     state.
                | 
                |     Parameters:
                | 
                |         iProcess
                |             The activity whose states are to be listed. 
                |         iConditionType
                |             The type of assignment that has been made i.e., the condition on
                |             which the state(s) have been assigned to the given activity. iConditionType
                |             could be one of "Begin Condition", "End Condition", "3D Context" or "All"
                | 
                |     Returns:
                |         oNumStates The number of 3D States that have been assigned to the given
                |         activity.
                | 
                |         Example:
                | 
                |              Dim MySelectedActivity
                |              NumStates = stateManagement.GetNumberof3DStatesInActivity(MySelectedActivity, "Begin Condition")

        :param Activity i_process:
        :param str i_condition_type:
        :rtype: int
        """
        return self.dnb_3d_state_management.GetNumberof3DStatesInActivity(i_process.com_object, i_condition_type)

    def list_3d_states_in_activity(self, i_process: Activity, i_condition_type: str, o_states: tuple) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub List3DStatesInActivity(Activity iProcess,
                | CATBSTR iConditionType,
                | CATSafeArrayVariant oStates)
                | 
                |     Returns the list of 3D states assigned to the given activity, based on the
                |     condition on which the activity has been assigned to the 3D
                |     state.
                | 
                |     Parameters:
                | 
                |         iProcess
                |             The activity whose states are to be listed. 
                |         iConditionType
                |             The type of assignment that has been made i.e., the condition on
                |             which the state(s) have been assigned to the given activity. iConditionType
                |             could be one of "Begin Condition", "End Condition", "3D Context" or "All"
                | 
                |     Returns:
                |         oStates The list of 3D States that have been assigned to the given
                |         activity.
                | 
                |         Example:
                | 
                |              Dim activitiesArray() as AnyObject
                |              Dim numActs
                |              numActs = stateManagement.GetNumberof3DStatesInActivity(MySelectedActivity)
                |              ReDim activitiesArray(numActs)
                |              stateManagement.List3DStatesInActivity MySelectedActivity, "Begin
                |              Condition",activitiesArray

        :param Activity i_process:
        :param str i_condition_type:
        :param tuple o_states:
        :rtype: None
        """
        return self.dnb_3d_state_management.List3DStatesInActivity(i_process.com_object, i_condition_type, o_states)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'list3_d_states_in_activity'
        # # vba_code = """
        # # Public Function list3_d_states_in_activity(dnb3_d_state_management)
        # #     Dim iProcess (2)
        # #     dnb3_d_state_management.List3DStatesInActivity iProcess
        # #     list3_d_states_in_activity = iProcess
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def list_all3_d_states(self) -> DNB3DStates:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Func ListAll3DStates() As DNB3DStates
                | 
                |     Returns the list of all 3D State objects in the process
                |     document
                | 
                |     Returns:
                |         oListStates The list of all 3D States in the current
                |         document.
                | 
                |         Example:
                | 
                |              Dim My3DStates as DNB3DStates
                |              set My3DStates = stateManagement.ListAll3DStates
                |              statesCount = My3DStates.Count

        :rtype: DNB3DStates
        """
        return DNB3DStates(self.dnb_3d_state_management.ListAll3DStates())

    def list_all_3d_states_on_object(self, i_obj: AnyObject, o_list_states: tuple) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub ListAll3DStatesOnObject(CATBaseDispatch iObj,
                | CATSafeArrayVariant oListStates)
                | 
                |     Returns the list of all 3D State objects on a given
                |     object(Resource/MA/Product..)
                | 
                |     Parameters:
                | 
                |         iObject
                |             The object(Resource/MA/Product..), whose states are to be listed.
                |             
                | 
                |     Returns:
                |         oListStates The list of all 3D States created on
                |         iObject.
                | 
                |         Example:
                | 
                |              Dim statesArray() as AnyObject
                |              Dim statesCount
                |              statesCount = stateManagement.GetNumberOf3DStatesOnObject(MySelectedProduct)
                |              Redim statesArray(statesCount)
                |              stateManagement.ListAll3DStatesOnObject(MySelectedProduct,statesArray)

        :param AnyObject i_obj:
        :param tuple o_list_states:
        :rtype: None
        """
        return self.dnb_3d_state_management.ListAll3DStatesOnObject(i_obj.com_object, o_list_states)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'list_all3_d_states_on_object'
        # # vba_code = """
        # # Public Function list_all3_d_states_on_object(dnb3_d_state_management)
        # #     Dim iObj (2)
        # #     dnb3_d_state_management.ListAll3DStatesOnObject iObj
        # #     list_all3_d_states_on_object = iObj
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def __repr__(self):
        return f'DNB3DStateManagement(name="{self.name}")'
