#! usr/bin/python3.9
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-09-25 14:34:21.593357

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""

from pycatia.system_interfaces.any_object import AnyObject


class Shot(AnyObject):

    """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.AnyObject
                |                     Shot
                | 
                | The interface to access a CATIAShot.
                | Role: A CATIAShot (or shot) is the base element that Sampled objects are
                | composed of. For example, when considering a Track, each recorded position is a
                | shot.
    
    """

    def __init__(self, com_object):
        super().__init__(com_object)
        self.shot = com_object

    def append_abs_datas(self, i_position: tuple) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub AppendAbsDatas(CATSafeArrayVariant iPosition)
                | 
                |     Appends to the data related to the shot. Role: In certain cases, a shot
                |     contains more than one data item. The SetDatas method is used to store the
                |     first data item. This method is then used to specify any additional data
                |     items
                | 
                |     Parameters:
                | 
                |         iPosition
                |             An array of associated values to the shot. Please note that these
                |             values are absolute (relative to the world coordinate system), specifically to
                |             where the object started from.

        :param tuple i_position:
        :rtype: None
        """
        return self.shot.AppendAbsDatas(i_position)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'append_abs_datas'
        # # vba_code = """
        # # Public Function append_abs_datas(shot)
        # #     Dim iPosition (2)
        # #     shot.AppendAbsDatas iPosition
        # #     append_abs_datas = iPosition
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def append_datas(self, i_position: tuple) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub AppendDatas(CATSafeArrayVariant iPosition)
                | 
                |     Appends to the data related to the shot. Role: In certain cases, a shot
                |     contains more than one data item. The SetDatas method is used to store the
                |     first data item. This method is then used to specify any additional data
                |     items.
                | 
                |     Parameters:
                | 
                |         iPosition
                |             An array of associated values to the shot. Please note that these
                |             values are relative to the position of object, specifically to where the object
                |             started from.

        :param tuple i_position:
        :rtype: None
        """
        return self.shot.AppendDatas(i_position)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'append_datas'
        # # vba_code = """
        # # Public Function append_datas(shot)
        # #     Dim iPosition (2)
        # #     shot.AppendDatas iPosition
        # #     append_datas = iPosition
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def get_abs_datas(self, i_index: int, o_position: tuple) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub GetAbsDatas(short iIndex,
                | CATSafeArrayVariant oPosition)
                | 
                |     Retrieves the data related to the shot. Role: To get the numerical
                |     information related to the shot. For example, for a Track, each shot
                |     corresponds to a position that is used when evaluating a defined trajectory.
                |     Please note that these values are absolute (relative to the world coordinate
                |     system), specifically to where the object started from.
                | 
                |     Parameters:
                | 
                |         iIndex
                |             A shot can have more than one piece of data associated to it. The
                |             value of iIndex refers to which specific data item to retrieve. The legal
                |             values of iIndex correspond to the rank of the data item (that is the 0 for the
                |             first item, 1 for the second item). 
                | 
                |     Returns:
                |         An array of associated values to the shot.

        :param int i_index:
        :param tuple o_position:
        :rtype: None
        """
        return self.shot.GetAbsDatas(i_index, o_position)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'get_abs_datas'
        # # vba_code = """
        # # Public Function get_abs_datas(shot)
        # #     Dim iIndex (2)
        # #     shot.GetAbsDatas iIndex
        # #     get_abs_datas = iIndex
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def get_datas(self, i_index: int, o_position: tuple) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub GetDatas(short iIndex,
                | CATSafeArrayVariant oPosition)
                | 
                |     Retrieves the data related to the shot. Role: To get the numerical
                |     information related to the shot. For example, for a Track, each shot
                |     corresponds to a position that is used when evaluating a defined trajectory.
                |     Please note that these values are relative to the position of object,
                |     specifically to where the object started from.
                | 
                |     Parameters:
                | 
                |         iIndex
                |             A shot can have more than one piece of data associated to it. The
                |             value value of iIndex refers to which specific data item to retrieve. The legal
                |             values of iIndex correspond to the rank of the data item (that is the 0 for the
                |             first item, 1 for the second item). 
                | 
                |     Returns:
                |         An array of associated values to the shot.

        :param int i_index:
        :param tuple o_position:
        :rtype: None
        """
        return self.shot.GetDatas(i_index, o_position)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'get_datas'
        # # vba_code = """
        # # Public Function get_datas(shot)
        # #     Dim iIndex (2)
        # #     shot.GetDatas iIndex
        # #     get_datas = iIndex
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def get_duration(self) -> float:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Func GetDuration() As double
                | 
                |     Retrieves the duration (in terms of distance) associated to a shot. The
                |     duration of a shot is the amount of time needed to travel from the previous
                |     shot to the current shot. However, this method retrieves the distance of the
                |     current shot from that of the previous shot. It is left for the user to
                |     calculate the Time using distance/speed Formula. Some key things to note
                |     are:
                | 
                |         The first shot should have a duration of zero.
                |         The value of the duration is a positive real number. Hence, 0.454 &
                |         1345 are legal while -18 is not. 
                | 
                |     Parameters:
                | 
                |         oTime
                |             The duration (distance) of a shot.

        :rtype: float
        """
        return self.shot.GetDuration()

    def get_technological_datas(self, o_datas: tuple) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub GetTechnologicalDatas(CATSafeArrayVariant oDatas)
                | 
                |     Retrieves all the data associated to the part.

        :param tuple o_datas:
        :rtype: None
        """
        return self.shot.GetTechnologicalDatas(o_datas)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'get_technological_datas'
        # # vba_code = """
        # # Public Function get_technological_datas(shot)
        # #     Dim oDatas (2)
        # #     shot.GetTechnologicalDatas oDatas
        # #     get_technological_datas = oDatas
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def set_abs_datas(self, i_position: tuple) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub SetAbsDatas(CATSafeArrayVariant iPosition)
                | 
                |     Set the data related to the shot. Role: To set the numerical information
                |     related to the shot. For example, for a Track, each shot corresponds to a
                |     position that is used when evaluating a defined
                |     trajectory.
                | 
                |     Parameters:
                | 
                |         iPosition
                |             An array of associated values to the shot. Please note that these
                |             values are absolute (relative to the world coordinate system), specifically to
                |             where the object started from.

        :param tuple i_position:
        :rtype: None
        """
        return self.shot.SetAbsDatas(i_position)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'set_abs_datas'
        # # vba_code = """
        # # Public Function set_abs_datas(shot)
        # #     Dim iPosition (2)
        # #     shot.SetAbsDatas iPosition
        # #     set_abs_datas = iPosition
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def set_datas(self, i_position: tuple) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub SetDatas(CATSafeArrayVariant iPosition)
                | 
                |     Set the data related to the shot. Role: To set the numerical information
                |     related to the shot. For example, for a Track, each shot corresponds to a
                |     position that is used when evaluating a defined
                |     trajectory.
                | 
                |     Parameters:
                | 
                |         iPosition
                |             An array of associated values to the shot. Please note that these
                |             values are relative to the position of object, specifically to where the object
                |             started from.

        :param tuple i_position:
        :rtype: None
        """
        return self.shot.SetDatas(i_position)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'set_datas'
        # # vba_code = """
        # # Public Function set_datas(shot)
        # #     Dim iPosition (2)
        # #     shot.SetDatas iPosition
        # #     set_datas = iPosition
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def set_duration(self, i_duration: float) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub SetDuration(double iDuration)
                | 
                |     Sets the duration (in terms of distance) associated to a shot. The duration
                |     of a shot is the amount of time needed to travel from the previous shot to the
                |     current shot. However, this method sets the distance of the current shot from
                |     that of the previous shot. It is left for the user to calculate the distance
                |     that needs to be set for the shot using the Time*Speed Formula. Some key things
                |     to note are:
                | 
                |         The first shot should have a duration of zero.
                |         The value of the duration is a positive real number. Hence, 0.454 &
                |         1345 are legal while -18 is not. 
                | 
                |     Parameters:
                | 
                |         oTime
                |             The duration (distance) of a shot.

        :param float i_duration:
        :rtype: None
        """
        return self.shot.SetDuration(i_duration)

    def set_technological_datas(self, i_datas: tuple) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub SetTechnologicalDatas(CATSafeArrayVariant iDatas)
                | 
                |     Sets all the data associated to the part.

        :param tuple i_datas:
        :rtype: None
        """
        return self.shot.SetTechnologicalDatas(i_datas)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'set_technological_datas'
        # # vba_code = """
        # # Public Function set_technological_datas(shot)
        # #     Dim iDatas (2)
        # #     shot.SetTechnologicalDatas iDatas
        # #     set_technological_datas = iDatas
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def __repr__(self):
        return f'Shot(name="{ self.name }")'
