#! usr/bin/python3.9
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-09-25 14:34:21.593357

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""
from pycatia.fitting_interfaces.shuttle import Shuttle
from pycatia.system_interfaces.collection import Collection
from pycatia.types.general import cat_variant


class Shuttles(Collection):
    """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.Collection
                |                     Shuttles
                | 
                | The interface to access a CATIAShuttles
                | 
                | Using this prefered syntax will enable mkdoc to document your
                | class.
    
    """

    def __init__(self, com_object):
        super().__init__(com_object, child_object=Shuttle)
        self.shuttles = com_object

    def add(self) -> Shuttle:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Func Add() As Shuttle
                | 
                |     Creates a new Shuttle and adds it to the Shuttles
                |     collection.
                | 
                |     Returns:
                |         The created Shuttle 
                |     Example:
                |         The following example creates a Shuttle newShuttle in the Shuttles
                |         collection.
                | 
                |          Set newShuttles = Shuttles.Add

        :rtype: Shuttle
        """
        return Shuttle(self.shuttles.Add())

    def add_from_sel(self) -> Shuttle:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Func AddFromSel() As Shuttle
                | 
                |     Creates a new Shuttle from the selection and adds it to the Shuttles
                |     collection.
                | 
                |     Returns:
                |         The created Shuttle 
                |     Example:
                |         The following example creates a Shuttle newShuttle in the Shuttles
                |         collection.
                | 
                |          Set newShuttles = Shuttles.Add

        :rtype: Shuttle
        """
        return Shuttle(self.shuttles.AddFromSel())

    def item(self, i_index: cat_variant) -> Shuttle:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Func Item(CATVariant iIndex) As Shuttle

        :param cat_variant i_index:
        :rtype: Shuttle
        """
        return Shuttle(self.shuttles.Item(i_index))

    def remove(self, i_shuttle: Shuttle) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub Remove(Shuttle iShuttle)

        :param Shuttle i_shuttle:
        :rtype: None
        """
        return self.shuttles.Remove(i_shuttle.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'remove'
        # # vba_code = """
        # # Public Function remove(shuttles)
        # #     Dim iShuttle (2)
        # #     shuttles.Remove iShuttle
        # #     remove = iShuttle
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def __repr__(self):
        return f'Shuttles(name="{self.name}")'
