#! usr/bin/python3.9
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-09-25 14:34:21.593357

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""

from pycatia.system_interfaces.any_object import AnyObject


class ExpertReportObject(AnyObject):

    """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.AnyObject
                |                     ExpertReportObject
                | 
                | Represents the ExpertReportObject object.
    
    """

    def __init__(self, com_object):
        super().__init__(com_object)
        self.expert_report_object = com_object

    @property
    def validity(self) -> bool:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)
                | o Property Validity() As boolean (Read Only)
                | 
                |     Returns the validity of a check for a given tuple. The result depends on
                |     the result of the check for a given tuple :
                | 
                |     "True" or "False" for the tuple.

        :rtype: bool
        """

        return self.expert_report_object.Validity

    def get_tuple(self, o_safe_array: tuple) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub getTuple(CATSafeArrayVariant oSafeArray)
                | 
                |     Returns a tuple (a collection of objects) concerned by this report
                |     object.
                | 
                |     Example:
                | 
                |          Dim relations1 As Relations
                |          Dim RuleBase1 As ExpertRuleBaseRuntime
                |          Dim ListComponents As ExpertRuleBaseComponentRuntimes
                |          Dim AComponent As ExpertRuleBaseComponentRuntime
                |          Dim NupletsList As ExpertReportObjects
                |          Dim ANuplet As ExpertReportObject
                |          Dim anArray () as Object
                |          Dim anElementArray as Object
                | 
                |          Set relations1 = part1.Relations
                |          Set RuleBase1 = relations1.Item("RuleBase")
                |          Set ListComponents = RuleBase1.RuleSet.ExpertRuleBaseComponentRuntimes
                |          ' Let's get a check ..
                |          Set AComponent = ListComponents.Item("CheckOnHoles")
                |          ' .. and let's see what makes it true
                |          Set NupletsList = AComponent.Succeeds
                |          For i = 1 to AComponent.Succeeds.CountSucceed
                |            Set ANuplet = AComponent.Succeeds.SucceedItem(i)
                |            NupletSize = ANuplet.getTupleSize()
                |            ReDim anArray (NupletSize)
                |            ANuplet.getTuple(anArray)
                |            For j = LBound(anArray) to UBound(anArray)
                |              Set anElementArray = anArray(j) ' a hole
                | 
                |              ' .. some action on the element of the array
                |            Next
                |          Next
                |          
                | 
                |     Parameters:
                | 
                |         oSafeArray
                |             The collection of objects.

        :param tuple o_safe_array:
        :rtype: None
        """
        return self.expert_report_object.getTuple(o_safe_array)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'get_tuple'
        # # vba_code = """
        # # Public Function get_tuple(expert_report_object)
        # #     Dim oSafeArray (2)
        # #     expert_report_object.getTuple oSafeArray
        # #     get_tuple = oSafeArray
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def get_tuple_size(self) -> int:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Func getTupleSize() As long
                | 
                |     Returns the size of the tuple concerned by this report
                |     object.
                | 
                |     Returns:
                |         Size of the tuple

        :rtype: int
        """
        return self.expert_report_object.getTupleSize()

    def __repr__(self):
        return f'ExpertReportObject(name="{ self.name }")'
