#! usr/bin/python3.9
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-09-25 14:34:21.593357

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""

from pycatia.system_interfaces.any_object import AnyObject


class KweCorrectFunction(AnyObject):
    """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.AnyObject
                |                     KWECorrectFunction
                | 
                | Represents the Knowledge correct function.
    
    """

    def __init__(self, com_object):
        super().__init__(com_object)
        self.kwe_correct_function = com_object

    def check(self) -> AnyObject:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Func Check() As CATBaseDispatch
                | 
                |     Retrieves the check associtade to this correct function.
                | 
                |     Returns:
                |         oAssociatedCheck ExpertCheck associated to this correct function.

        :rtype: AnyObject
        """
        return self.kwe_correct_function.Check()

    def get_number_of_list_failed_elements(self) -> int:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Func GetNumberOfListFailedElements() As long
                | 
                |     Retrieves the number of roots of facts of the rule base.
                | 
                |     Returns:
                |         oArraySize Number of roots of facts.

        :rtype: int
        """
        return self.kwe_correct_function.GetNumberOfListFailedElements()

    def list_failed_elements(self) -> tuple:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub ListFailedElements(CATSafeArrayVariant
                | oListElementsOfTupleFailed)
                | 
                |     Returns the list of elements of current tuple failed.
                | 
                |     Parameters:
                | 
                |         oListElementsOfTupleFailed
                |             array of tuple elements.

        :param tuple o_list_elements_of_tuple_failed:
        :rtype: tuple
        """
        return self.kwe_correct_function.ListFailedElements()
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'list_failed_elements'
        # # vba_code = """
        # # Public Function list_failed_elements(kwe_correct_function)
        # #     Dim oListElementsOfTupleFailed (2)
        # #     kwe_correct_function.ListFailedElements oListElementsOfTupleFailed
        # #     list_failed_elements = oListElementsOfTupleFailed
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def __repr__(self):
        return f'KweCorrectFunction(name="{self.name}")'
