#! usr/bin/python3.9
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-09-25 14:34:21.593357

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""
from pycatia.kinematics_interfaces.mechanism import Mechanism
from pycatia.product_structure_interfaces.product import Product
from pycatia.system_interfaces.any_object import AnyObject


class Dressup(AnyObject):
    """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.AnyObject
                |                     Dressup
                | 
                | Interface to access the Dressup object.
    
    """

    def __init__(self, com_object):
        super().__init__(com_object)
        self.dressup = com_object

    @property
    def context(self) -> Product:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)
                | o Property Context() As Product (Read Only)
                | 
                |     Returns the context product on which the mechanism is defined. This
                |     property is read only.
                | 
                |     Returns:
                |         The dressup mechanism's context 
                |     Example:
                |         This example sets in MecaContext the context product of
                |         MyDressup.
                | 
                |             Dim MecaContext As Product
                |             Set MecaContext = MyDressup.Context

        :rtype: Product
        """

        return Product(self.dressup.Context)

    @property
    def mechanism(self) -> Mechanism:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)
                | o Property Mechanism() As Mechanism (Read Only)
                | 
                |     Returns the mechanism on which a dressup is applied. This property is read
                |     only.
                | 
                |     Returns:
                |         The dressup's mechanism 
                |     Example:
                |         This example sets in Meca the mechanism of MyDressup.
                | 
                |           Dim Meca As Mechanism
                |           Set Meca = MyDressup.Mechanism

        :rtype: Mechanism
        """

        return Mechanism(self.dressup.Mechanism)

    def attach(self, i_link: Product, i_attached_prod: Product) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub Attach(Product iLink,
                | Product iAttachedProd)
                | 
                |     Attaches a given product to a link of the mechanism pointed by the
                |     dressup.
                | 
                |     Parameters:
                | 
                |         iLink
                |             The link (Product) on which the attachment should be done. It
                |             should be a product that belongs to the mechanism pointed by the dressup,
                |             otherwise the method will fail. 
                |         iAttachedProd
                |             The Product that will be attached to the link. This product should
                |             not be a product that is already attached by another link, otherwise the method
                |             will fail. 
                | 
                |     Returns:
                |         Nothing 
                |     Example:
                |         This example attaches inside MyDressup, Link1 as mechanism's part to
                |         Product1.
                | 
                |             Dim Link1 As Product
                |             Dim Product1 As Product
                |             ...
                |             MyDressup.Attach(Link1,Product1)

        :param Product i_link:
        :param Product i_attached_prod:
        :rtype: None
        """
        return self.dressup.Attach(i_link.com_object, i_attached_prod.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'attach'
        # # vba_code = """
        # # Public Function attach(dressup)
        # #     Dim iLink (2)
        # #     dressup.Attach iLink
        # #     attach = iLink
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def detach(self, i_attached_prod: Product) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub Detach(Product iAttachedProd)
                | 
                |     Detaches an attached product from its link.
                | 
                |     Parameters:
                | 
                |         iAttachedProd
                |             The Product that will be detached. It should be a product that is
                |             currently attached in the dressup, otherwise the method will fail.
                |             
                | 
                |     Returns:
                |         Nothing 
                |     Example:
                |         This example detaches Product1 previously attached to a mechanism's
                |         part inside MyDressup.
                | 
                |             Dim Product1 As Product
                |             ...
                |             MyDressup.Detach(Product1)

        :param Product i_attached_prod:
        :rtype: None
        """
        return self.dressup.Detach(i_attached_prod.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'detach'
        # # vba_code = """
        # # Public Function detach(dressup)
        # #     Dim iAttachedProd (2)
        # #     dressup.Detach iAttachedProd
        # #     detach = iAttachedProd
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def list_attached(self, i_link: Product) -> tuple:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Func ListAttached(Product iLink) As CATSafeArrayVariant
                | 
                |     Returns the list of products attached to a given link.
                | 
                |     Parameters:
                | 
                |         iLink
                |             The Product on which the returned product list is attached to.
                |             
                | 
                |     Returns:
                |         The Product list that is attached to iLink. 
                |     Example:
                |         The following example loops for all the products attached to
                |         Link1.
                | 
                |             Dim ListAttached1 as Product
                |             ListAttached1 = MyDressup.ListAttached(Link1)
                |             Dim Maxi as Integer
                |             Set Maxi = ubound(ListAttached1)
                |             Dim Prod_i as Product
                |             For i = 0  To  Maxi
                |                Set Prod_i = ListAttached1(i)
                |                ..
                |             Next

        :param Product i_link:
        :rtype: tuple
        """
        return self.dressup.ListAttached(i_link.com_object)

    def __repr__(self):
        return f'Dressup(name="{self.name}")'
