#! usr/bin/python3.9
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-09-25 14:34:21.593357

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""
from pycatia.manufacturing_interfaces.manufacturing_activity import ManufacturingActivity
from pycatia.system_interfaces.collection import Collection
from pycatia.types.general import cat_variant


class ManufacturingActivities(Collection):
    """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.Collection
                |                     MfgActivities
                | 
                | The collection of MfgActivities related to the Manufacturing Document
                | .
    
    """

    def __init__(self, com_object):
        super().__init__(com_object, child_object=ManufacturingActivity)
        self.mfg_activities = com_object

    def add(self, i_real_obj: ManufacturingActivity) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub Add(ManufacturingActivity iRealObj)
                | 
                |     This method adds the specified CATIAManufacturingActivity in the current
                |     list CATIAMfgActivities.
                | 
                |     Example:
                |         The following example adds in CATIAMfgActivities ListActivities the
                |         CATIAManufacturingActivity ThisActivity in position
                |         NumPos:
                | 
                |          ListActivities.Add(ThisActivity)

        :param ManufacturingActivity i_real_obj:
        :rtype: None
        """
        return self.mfg_activities.Add(i_real_obj.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'add'
        # # vba_code = """
        # # Public Function add(mfg_activities)
        # #     Dim iRealObj (2)
        # #     mfg_activities.Add iRealObj
        # #     add = iRealObj
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def get_element(self, i_index: int) -> ManufacturingActivity:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Func GetElement(long iIndex) As ManufacturingActivity
                | 
                |     This method return the specified CATIAManufacturingActivity in the current
                |     list CATIAMfgActivities.
                | 
                |     Example:
                |         The following example return the CATIAManufacturingActivity
                |         ThisActivity in CATIAMfgActivities ListActivities in position
                |         NumPos:
                | 
                |          Set ThisActivity = ListActivities.GetElement(Numpos)

        :param int i_index:
        :rtype: ManufacturingActivity
        """
        return ManufacturingActivity(self.mfg_activities.GetElement(i_index))

    def item(self, i_index: cat_variant) -> ManufacturingActivity:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Func Item(CATVariant iIndex) As ManufacturingActivity
                | 
                |     This method return the specified CATIAManufacturingActivity in the current
                |     list CATIAMfgActivities.
                | 
                |     Example:
                |         The following example return the CATIAManufacturingActivity
                |         ThisActivity in CATIAMfgActivities ListActivities in position
                |         NumPos:
                | 
                |          Set ThisActivity = ListActivities.Item(Numpos)

        :param cat_variant i_index:
        :rtype: ManufacturingActivity
        """
        return ManufacturingActivity(self.mfg_activities.Item(i_index))

    def __repr__(self):
        return f'MfgActivities(name="{self.name}")'
