#! usr/bin/python3.9
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-09-25 14:34:21.593357

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""
from pycatia.manufacturing_interfaces.manufacturing_activity import ManufacturingActivity


class ManufacturingCopyTransformation(ManufacturingActivity):
    """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.AnyObject
                |                     DMAPSInterfaces.Activity
                |                        ManufacturingInterfaces.ManufacturingActivity
                |                             ManufacturingCopyTransformation
                | 
                | Interface representing the Manufacturing Copy Transformation
                | object.
                | 
                | Role: Component that implements CATIAManufacturingCopyOrder is MfgCopyOrder.
                | This interface allows to modify the Copy Tranformation and to get the start and
                | end points of the computed trajectory.
    
    """

    def __init__(self, com_object):
        super().__init__(com_object)
        self.manufacturing_copy_transformation = com_object

    def add_operation(self, i_manufacturing_activity: ManufacturingActivity) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub AddOperation(ManufacturingActivity
                | iManufacturingActivity)
                | 
                |     Add a Manufacturing Operation to a Copy Transformation.
                | 
                |     Example:
                |         The following example adds a manufacturing operation myOperation, as a
                |         reference for the Copy Transformation
                |         CopyTransformation
                | 
                |          call myOperation.AddOperation(CopyTransformation)

        :param ManufacturingActivity i_manufacturing_activity:
        :rtype: None
        """
        return self.manufacturing_copy_transformation.AddOperation(i_manufacturing_activity.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'add_operation'
        # # vba_code = """
        # # Public Function add_operation(manufacturing_copy_transformation)
        # #     Dim iManufacturingActivity (2)
        # #     manufacturing_copy_transformation.AddOperation iManufacturingActivity
        # #     add_operation = iManufacturingActivity
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def get_trajectory_end_point_coord(self, o_end_point: tuple) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub GetTrajectoryEndPointCoord(CATSafeArrayVariant
                | oEndPoint)
                | 
                |     Retrieves the Manufacturing Copy Order trajectory end
                |     point.
                | 
                |     Example:
                |         The following example retrieves in oEndPoint the end point of the
                |         Manufacturing Copy Order CopyOrder
                | 
                |          Dim oEndPoint(3)
                |          call CopyOrder.GetTrajectoryEndPointCoord(oEndPoint)
                |          x = oEndPoint(0)
                |          y = oEndPoint(1)
                |          z = oEndPoint(2)

        :param tuple o_end_point:
        :rtype: None
        """
        return self.manufacturing_copy_transformation.GetTrajectoryEndPointCoord(o_end_point)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'get_trajectory_end_point_coord'
        # # vba_code = """
        # # Public Function get_trajectory_end_point_coord(manufacturing_copy_transformation)
        # #     Dim oEndPoint (2)
        # #     manufacturing_copy_transformation.GetTrajectoryEndPointCoord oEndPoint
        # #     get_trajectory_end_point_coord = oEndPoint
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def get_trajectory_start_point_coord(self, o_start_point: tuple) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub GetTrajectoryStartPointCoord(CATSafeArrayVariant
                | oStartPoint)
                | 
                |     Retrieves the Manufacturing Copy Order Operation's trajectory start
                |     point.
                | 
                |     Example:
                |         The following example retrieves in oStartPoint the start point of the
                |         Machining Operation Operation
                | 
                |          Dim oStartPoint(3)
                |          call
                |          Operation.GetTrajectoryStartPointCoord(oStartPoint)
                |          x = oStartPoint(0)
                |          y = oStartPoint(1)
                |          z = oStartPoint(2)

        :param tuple o_start_point:
        :rtype: None
        """
        return self.manufacturing_copy_transformation.GetTrajectoryStartPointCoord(o_start_point)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'get_trajectory_start_point_coord'
        # # vba_code = """
        # # Public Function get_trajectory_start_point_coord(manufacturing_copy_transformation)
        # #     Dim oStartPoint (2)
        # #     manufacturing_copy_transformation.GetTrajectoryStartPointCoord oStartPoint
        # #     get_trajectory_start_point_coord = oStartPoint
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def set_copy_transformation(self, i_number_of_copies: int, i_ordering: str, i_transformation_type: str) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub SetCopyTransformation(long iNumberOfCopies,
                | CATBSTR iOrdering,
                | CATBSTR iTransformationType)
                | 
                |     Set the 'Number of Copies', 'Ordering' and 'Transformation Type' of a Copy
                |     Tranformation.
                | 
                |     Parameters:
                | 
                |         iOrdering
                |             Legal values: iOrdering can be
                | 
                |             "EachOperationNTime"
                |             "AllOperationsNTime"
                | 
                |         iTransformationType
                |             Legal values: iTransformationType can be
                | 
                |             "Translation"
                |             "Rotation"
                |             "Mirror"
                |             "AxisToAxis"
                |             "Scale"
                |             "Affinity"
                |             "Matrix"
                | 
                |         Example:
                |             The following example does that for the Copy Transformation
                |             CopyTransformation :
                | 
                |              call CopyTransformation.SetCopyTransformation(iNumberOfCopies,
                |              "EachOperationNTime", "Translation")

        :param int i_number_of_copies:
        :param str i_ordering:
        :param str i_transformation_type:
        :rtype: None
        """
        return self.manufacturing_copy_transformation.SetCopyTransformation(
            i_number_of_copies,
            i_ordering,
            i_transformation_type
        )

    def set_copy_transformation_translation_attributes(
            self,
            i_translation_type: str,
            i_distance_along_x: float,
            i_distance_along_y: float,
            i_distance_along_z: float
    ) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub SetCopyTransformationTranslationAttributes(CATBSTR
                | iTranslationType,
                | double iDistanceAlongX,
                | double iDistanceAlongY,
                | double iDistanceAlongZ)
                | 
                |     Set the 'Translation Type', 'Distance Along X', 'Distance Along Y' and
                |     'Distance Along Z' of a Copy Tranformation which has a Translation as
                |     transformation.
                | 
                |     Parameters:
                | 
                |         iTranslationType
                |             Legal values: iTranslationType can be
                | 
                |             "AbsoluteCoordinates"
                |             "CurrentCoordinates"
                | 
                |         iDistanceAlongX
                |             distance along X in mm. 
                |         iDistanceAlongY
                |             distance along Y in mm. 
                |         iDistanceAlongZ
                |             distance along Z in mm. 
                |         Example:
                |             The following example does that for the Copy Transformation
                |             CopyTransformation :
                | 
                |              call
                |              CopyTransformation.SetCopyTransformationTranslationAttributes("AbsoluteCoordinates", 0.0, 100.0, 0.0
                |              )

        :param str i_translation_type:
        :param float i_distance_along_x:
        :param float i_distance_along_y:
        :param float i_distance_along_z:
        :rtype: None
        """
        return self.manufacturing_copy_transformation.SetCopyTransformationTranslationAttributes(
            i_translation_type,
            i_distance_along_x,
            i_distance_along_y,
            i_distance_along_z
        )

    def __repr__(self):
        return f'ManufacturingCopyTransformation(name="{self.name}")'
