#! usr/bin/python3.9
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-09-25 14:34:21.593357

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""
from pycatia.manufacturing_interfaces.manufacturing_output import ManufacturingOutput
from pycatia.system_interfaces.any_object import AnyObject
from pycatia.system_interfaces.cat_base_unknown import CATBaseUnknown


class ManufacturingGeneratorData(AnyObject):
    """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.AnyObject
                |                     ManufacturingGeneratorData
                | 
                | Represents the manufacturing output stream object.
                | This object contains the output stream generated for the output files (APT,
                | etc.).
    
    """

    def __init__(self, com_object):
        super().__init__(com_object)
        self.manufacturing_generator_data = com_object

    def add_object_to_generate(self, i_object: CATBaseUnknown) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub AddObjectToGenerate(CATBaseUnknown iObject)
                | 
                |     Adds an object to the output stream.
                | 
                |         With buffer: V5R13 and next <=> AddObjectToGenerate
                |         Without buffer: V5R12 and previous <=>
                |         AddObjectToGenerate
                |         From buffer: Debug only
                | 
                |     Parameters:
                | 
                |         iObject
                |             The object to add

        :param CATBaseUnknown i_object:
        :rtype: None
        """
        return self.manufacturing_generator_data.AddObjectToGenerate(i_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'add_object_to_generate'
        # # vba_code = """
        # # Public Function add_object_to_generate(manufacturing_generator_data)
        # #     Dim iObject (2)
        # #     manufacturing_generator_data.AddObjectToGenerate iObject
        # #     add_object_to_generate = iObject
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def add_object_to_generate_from_buffer(self, i_object: CATBaseUnknown) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub AddObjectToGenerateFromBuffer(CATBaseUnknown iObject)
                | 
                |     Adds an object to the output stream from the buffer.
                | 
                |     Parameters:
                | 
                |         iObject
                |             The object to add

        :param CATBaseUnknown i_object:
        :rtype: None
        """
        return self.manufacturing_generator_data.AddObjectToGenerateFromBuffer(i_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'add_object_to_generate_from_buffer'
        # # vba_code = """
        # # Public Function add_object_to_generate_from_buffer(manufacturing_generator_data)
        # #     Dim iObject (2)
        # #     manufacturing_generator_data.AddObjectToGenerateFromBuffer iObject
        # #     add_object_to_generate_from_buffer = iObject
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def add_object_to_generate_with_buffer(self, i_object: CATBaseUnknown) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub AddObjectToGenerateWithBuffer(CATBaseUnknown iObject)
                | 
                |     Adds an object to the output stream within the buffer.
                | 
                |     Parameters:
                | 
                |         iObject
                |             The object to add

        :param CATBaseUnknown i_object:
        :rtype: None
        """
        return self.manufacturing_generator_data.AddObjectToGenerateWithBuffer(i_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'add_object_to_generate_with_buffer'
        # # vba_code = """
        # # Public Function add_object_to_generate_with_buffer(manufacturing_generator_data)
        # #     Dim iObject (2)
        # #     manufacturing_generator_data.AddObjectToGenerateWithBuffer iObject
        # #     add_object_to_generate_with_buffer = iObject
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def add_object_to_generate_with_out_buffer(self, i_object: CATBaseUnknown) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub AddObjectToGenerateWithOutBuffer(CATBaseUnknown
                | iObject)
                | 
                |     Adds an object to the output stream without the buffer.
                | 
                |     Parameters:
                | 
                |         iObject
                |             The object to add

        :param CATBaseUnknown i_object:
        :rtype: None
        """
        return self.manufacturing_generator_data.AddObjectToGenerateWithOutBuffer(i_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'add_object_to_generate_with_out_buffer'
        # # vba_code = """
        # # Public Function add_object_to_generate_with_out_buffer(manufacturing_generator_data)
        # #     Dim iObject (2)
        # #     manufacturing_generator_data.AddObjectToGenerateWithOutBuffer iObject
        # #     add_object_to_generate_with_out_buffer = iObject
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def add_object_to_modal_values(self, i_object: CATBaseUnknown) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub AddObjectToModalValues(CATBaseUnknown iObject)
                | 
                |     Adds an object to the modal values manager only.
                | 
                |     Parameters:
                | 
                |         iObject
                |             The object to add

        :param CATBaseUnknown i_object:
        :rtype: None
        """
        return self.manufacturing_generator_data.AddObjectToModalValues(i_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'add_object_to_modal_values'
        # # vba_code = """
        # # Public Function add_object_to_modal_values(manufacturing_generator_data)
        # #     Dim iObject (2)
        # #     manufacturing_generator_data.AddObjectToModalValues iObject
        # #     add_object_to_modal_values = iObject
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def get_ft06_stream(self, o_stream: ManufacturingOutput) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub GetFT06Stream(ManufacturingOutput oStream)
                | 
                |     Retrieves the FT06 stream.
                | 
                |     Parameters:
                | 
                |         oStream
                |             The retrieved stream

        :param ManufacturingOutput o_stream:
        :rtype: None
        """
        return self.manufacturing_generator_data.GetFT06Stream(o_stream.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'get_ft06_stream'
        # # vba_code = """
        # # Public Function get_ft06_stream(manufacturing_generator_data)
        # #     Dim oStream (2)
        # #     manufacturing_generator_data.GetFT06Stream oStream
        # #     get_ft06_stream = oStream
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def get_last_object_to_generate(self, o_object: CATBaseUnknown) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub GetLastObjectToGenerate(CATBaseUnknown oObject)
                | 
                |     Retrieves the last object to generate.
                | 
                |     Parameters:
                | 
                |         oObject
                |             The retrieved object

        :param CATBaseUnknown o_object:
        :rtype: None
        """
        return self.manufacturing_generator_data.GetLastObjectToGenerate(o_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'get_last_object_to_generate'
        # # vba_code = """
        # # Public Function get_last_object_to_generate(manufacturing_generator_data)
        # #     Dim oObject (2)
        # #     manufacturing_generator_data.GetLastObjectToGenerate oObject
        # #     get_last_object_to_generate = oObject
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def get_output_stream(self, o_stream: ManufacturingOutput) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub GetOutputStream(ManufacturingOutput oStream)
                | 
                |     Retrieves the output stream.
                | 
                |     Parameters:
                | 
                |         oStream
                |             The retrieved stream

        :param ManufacturingOutput o_stream:
        :rtype: None
        """
        return self.manufacturing_generator_data.GetOutputStream(o_stream.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'get_output_stream'
        # # vba_code = """
        # # Public Function get_output_stream(manufacturing_generator_data)
        # #     Dim oStream (2)
        # #     manufacturing_generator_data.GetOutputStream oStream
        # #     get_output_stream = oStream
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def reset_all_modal_values(self) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub ResetAllModalValues()
                | 
                |     Resets all modal values.

        :rtype: None
        """
        return self.manufacturing_generator_data.ResetAllModalValues()

    def set_last_object_to_generate(self, i_object: CATBaseUnknown) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub SetLastObjectToGenerate(CATBaseUnknown iObject)
                | 
                |     Sets the last Activity to generate.
                | 
                |     Parameters:
                | 
                |         iObject
                |             The activity to generate

        :param CATBaseUnknown i_object:
        :rtype: None
        """
        return self.manufacturing_generator_data.SetLastObjectToGenerate(i_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'set_last_object_to_generate'
        # # vba_code = """
        # # Public Function set_last_object_to_generate(manufacturing_generator_data)
        # #     Dim iObject (2)
        # #     manufacturing_generator_data.SetLastObjectToGenerate iObject
        # #     set_last_object_to_generate = iObject
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def __repr__(self):
        return f'ManufacturingGeneratorData(name="{self.name}")'
