#! usr/bin/python3.9
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-09-25 14:34:21.593357

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""
from pycatia.manufacturing_interfaces.manufacturing_activity import ManufacturingActivity
from pycatia.manufacturing_interfaces.manufacturing_precedence import ManufacturingPrecedence
from pycatia.system_interfaces.collection import Collection
from pycatia.types.general import cat_variant


class ManufacturingPrecedences(Collection):
    """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.Collection
                |                     ManufacturingPrecedences
                | 
                | Interface that manage the precedences for an object of type @
                | CATIAManufacturingActivity.
                | If an object A has objects B and C as precedence constraints, it means that B
                | and C have to be performed before A.
    
    """

    def __init__(self, com_object):
        super().__init__(com_object, child_object=ManufacturingPrecedence)
        self.manufacturing_precedences = com_object

    def add_operation(self, i_object: ManufacturingActivity, i_type: int) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub AddOperation(ManufacturingActivity iObject,
                | CatManufacturingPrecedenceType iType)
                | 
                |     Adds a new precedence in the collection of precedences. The type of added
                |     object is a CATIAManufacturingActivity.

        :param ManufacturingActivity i_object:
        :param int i_type: enum cat_manufacturing_precedence_type
        :rtype: None
        """
        return self.manufacturing_precedences.AddOperation(i_object.com_object, i_type)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'add_operation'
        # # vba_code = """
        # # Public Function add_operation(manufacturing_precedences)
        # #     Dim iObject (2)
        # #     manufacturing_precedences.AddOperation iObject
        # #     add_operation = iObject
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def item(self, i_index: cat_variant) -> ManufacturingPrecedence:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Func Item(CATVariant iIndex) As ManufacturingPrecedence
                | 
                |     Returns a precedence object from the precedence collection.

        :param cat_variant i_index:
        :rtype: ManufacturingPrecedence
        """
        return ManufacturingPrecedence(self.manufacturing_precedences.Item(i_index))

    def remove(self, i_index: int) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub Remove(long iIndex)
                | 
                |     Removes an object from the precedences collection. The removed precedence
                |     will be deleted, but not the referenced object attach to this precedence.

        :param int i_index:
        :rtype: None
        """
        return self.manufacturing_precedences.Remove(i_index)

    def remove_all(self) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub RemoveAll()
                | 
                |     Removes all objects from the precedences collection.

        :rtype: None
        """
        return self.manufacturing_precedences.RemoveAll()

    def __repr__(self):
        return f'ManufacturingPrecedences(name="{self.name}")'
