#! usr/bin/python3.9
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-09-25 14:34:21.593357

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""
from pycatia.osm_interfaces.scene import Scene
from pycatia.product_structure_interfaces.product import Product
from pycatia.system_interfaces.collection import Collection


class Scenes(Collection):
    """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.Collection
                |                     Scenes
                | 
                | A collection of scenes contained in a given ProductDocument.
    
    """

    def __init__(self, com_object):
        super().__init__(com_object)
        self.scenes = com_object

    def add_copy_scene(self, i_name: str, i_reference_scene: Scene) -> Scene:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Func AddCopyScene(CATBSTR iName,
                | Scene iReferenceScene) As Scene
                | 
                |     Creates a scene from another and adds it to the Scenes
                |     collection.
                | 
                |     Parameters:
                | 
                |         iName
                |             The name of the scene 
                |         iReferenceScene
                |             The scene to be copied 
                | 
                |     Returns:
                |         The created scene 
                |     Example:
                | 
                |              This example creates the Engine scene from the SpareWheel
                |              scene
                |             and adds the scene to the ToolKits collection.
                |
                |             Dim Engine As Scene
                |             Set Engine = ToolKits.AddNewScene("Engine", SpareWheel)

        :param str i_name:
        :param Scene i_reference_scene:
        :rtype: Scene
        """
        return Scene(self.scenes.AddCopyScene(i_name, i_reference_scene.com_object))

    def add_new_scene(self, i_name: str, i_reference_product: Product) -> Scene:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Func AddNewScene(CATBSTR iName,
                | Product iReferenceProduct) As Scene
                | 
                |     Creates a scene from a product and adds it to the Scenes
                |     collection.
                | 
                |     Parameters:
                | 
                |         iName
                |             The name of the scene 
                |         iReferenceProduct
                |             The product used as reference 
                | 
                |     Returns:
                |         The created scene 
                |     Example:
                | 
                |              This example creates the SpareWheel scene from the reference
                |              product
                |             FrontRightWheel and adds the scene to the ToolKits
                |             collection.
                |
                |             Dim SpareWheel As Scene
                |             Set SpareWheel = ToolKits.AddNewScene("SpareWheel", FrontRightWheel)

        :param str i_name:
        :param Product i_reference_product:
        :rtype: Scene
        """
        return Scene(self.scenes.AddNewScene(i_name, i_reference_product.com_object))

    def remove(self, i_scene: Scene) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub Remove(Scene iScene)
                | 
                |     Removes a scene from the Scenes collection.
                | 
                |     Parameters:
                | 
                |         iScene
                |             The scene to remove. 
                | 
                |     Example:
                | 
                |              This example removes the Engine scene from the ToolKits
                |              collection.
                |
                |             ToolKits.Remove Engine

        :param Scene i_scene:
        :rtype: None
        """
        return self.scenes.Remove(i_scene.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'remove'
        # # vba_code = """
        # # Public Function remove(scenes)
        # #     Dim iScene (2)
        # #     scenes.Remove iScene
        # #     remove = iScene
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def __repr__(self):
        return f'Scenes(name="{self.name}")'
