#! usr/bin/python3.9
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-09-25 14:34:21.593357

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""

from pycatia.system_interfaces.any_object import AnyObject


class StrAnchorPoint(AnyObject):
    """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.AnyObject
                |                     StrAnchorPoint
                | 
                | Represents an anchor point.
                | An anchor point is a point used to place the section on the support in the
                | design model.
    
    """

    def __init__(self, com_object):
        super().__init__(com_object)
        self.str_anchor_point = com_object

    def get_coordinates(self) -> tuple:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub GetCoordinates(CATSafeArrayVariant oCoord)
                | 
                |     Retrieves the coordinates of the anchor point. These coordinates are
                |     expressed in the section local coordinate system.
                | 
                |     Parameters:
                | 
                |         oCoord
                |             The 2D coordinates of the anchor point. 
                | 
                |     Example:
                | 
                |           
                | 
                |          Dim coord(1)
                |          anchor_1.GetCoordinates(coord)

        :param tuple o_coord:
        :rtype: None
        """
        return self.str_anchor_point.GetCoordinates()
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'get_coordinates'
        # # vba_code = """
        # # Public Function get_coordinates(str_anchor_point)
        # #     Dim oCoord (2)
        # #     str_anchor_point.GetCoordinates oCoord
        # #     get_coordinates = oCoord
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def __repr__(self):
        return f'StrAnchorPoint(name="{self.name}")'
