"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BootstraplessSynthesizer = void 0;
const _shared_1 = require("./_shared");
const default_synthesizer_1 = require("./default-synthesizer");
/**
 * A special synthesizer that behaves similarly to DefaultStackSynthesizer,
 * but doesn't require bootstrapping the environment it operates in.
 * Because of that, stacks using it cannot have assets inside of them.
 * Used by the CodePipeline construct for the support stacks needed for
 * cross-region replication S3 buckets.
 */
class BootstraplessSynthesizer extends default_synthesizer_1.DefaultStackSynthesizer {
    constructor(props) {
        super({
            deployRoleArn: props.deployRoleArn,
            cloudFormationExecutionRole: props.cloudFormationExecutionRoleArn,
        });
    }
    addFileAsset(_asset) {
        throw new Error('Cannot add assets to a Stack that uses the BootstraplessSynthesizer');
    }
    addDockerImageAsset(_asset) {
        throw new Error('Cannot add assets to a Stack that uses the BootstraplessSynthesizer');
    }
    synthesizeStackArtifacts(session) {
        _shared_1.assertBound(this.stack);
        // do _not_ treat the template as an asset,
        // because this synthesizer doesn't have a bootstrap bucket to put it in
        _shared_1.addStackArtifactToAssembly(session, this.stack, {
            assumeRoleArn: this.deployRoleArn,
            cloudFormationExecutionRoleArn: this.cloudFormationExecutionRoleArn,
            requiresBootstrapStackVersion: 1,
        }, []);
    }
}
exports.BootstraplessSynthesizer = BootstraplessSynthesizer;
//# sourceMappingURL=data:application/json;base64,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