# vim: set filetype=python fileencoding=utf-8:
# -*- coding: utf-8 -*-

#============================================================================#
#                                                                            #
#  Licensed under the Apache License, Version 2.0 (the "License");           #
#  you may not use this file except in compliance with the License.          #
#  You may obtain a copy of the License at                                   #
#                                                                            #
#      http://www.apache.org/licenses/LICENSE-2.0                            #
#                                                                            #
#  Unless required by applicable law or agreed to in writing, software       #
#  distributed under the License is distributed on an "AS IS" BASIS,         #
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  #
#  See the License for the specific language governing permissions and       #
#  limitations under the License.                                            #
#                                                                            #
#============================================================================#


''' Sentinel for absent values.

    Sentinel is distinct from ``None``. Package als has support for creating
    package-specific absence sentinels. Particularly useful in contexts where
    ``None`` is a valid value but you need to detect the absence of a value.
'''


from . import __
# --- BEGIN: Injected by Copier ---
from . import exceptions
# --- END: Injected by Copier ---

from .installers import *
from .objects import *


__version__ = '1.1.1'


__.ccstd.finalize_module( __name__, recursive = True )
