from enum import Enum, IntEnum


class SpecialHiraType(Enum):
    Ignore = 0
    Kata = 1
    Special = 2


class TableIndex(IntEnum):
    Roman = 0
    Hira = 1
    Kata = 2


class RomanKanaTable(object):
    common = (
        ('a', 'あ', 'ア'),
        ('i', 'い', 'イ'),
        ('u', 'う', 'ウ'),
        ('e', 'え', 'エ'),
        ('o', 'お', 'オ'),
        ('wha', 'うぁ', 'ウァ'),
        ('whi', 'うぃ', 'ウィ'),
        ('whu', 'う', 'ウ'),
        ('whe', 'うぇ', 'ウェ'),
        ('who', 'うぉ', 'ウォ'),
        ('la', 'ぁ', 'ァ'),
        ('li', 'ぃ', 'ィ'),
        ('lu', 'ぅ', 'ゥ'),
        ('le', 'ぇ', 'ェ'),
        ('lo', 'ぉ', 'ォ'),
        ('xa', 'ぁ', 'ァ'),
        ('xi', 'ぃ', 'ィ'),
        ('xu', 'ぅ', 'ゥ'),
        ('xe', 'ぇ', 'ェ'),
        ('xo', 'ぉ', 'ォ'),
        ('ka', 'か', 'カ'),
        ('ki', 'き', 'キ'),
        ('ku', 'く', 'ク'),
        ('ke', 'け', 'ケ'),
        ('ko', 'こ', 'コ'),
        ('kya', 'きゃ', 'キャ'),
        ('kyi', 'きぃ', 'キィ'),
        ('kyu', 'きゅ', 'キュ'),
        ('kye', 'きぇ', 'キェ'),
        ('kyo', 'きょ', 'キョ'),
        ('kwa', 'くぁ', 'クァ'),
        ('ca', 'か', 'カ'),
        ('ci', 'し', 'シ'),
        ('cu', 'く', 'ク'),
        ('ce', 'せ', 'セ'),
        ('co', 'こ', 'コ'),
        ('qa', 'くぁ', 'クァ'),
        ('qi', 'くぃ', 'クィ'),
        ('qu', 'く', 'ク'),
        ('qe', 'くぇ', 'クェ'),
        ('qo', 'くぉ', 'クォ'),
        ('qya', 'くゃ', 'クャ'),
        ('qyi', 'くぃ', 'クィ'),
        ('qyu', 'くゅ', 'クュ'),
        ('qye', 'くぇ', 'クェ'),
        ('qyo', 'くょ', 'クョ'),
        ('qwa', 'くぁ', 'クァ'),
        ('qwi', 'くぃ', 'クィ'),
        ('qwu', 'くぅ', 'クゥ'),
        ('qwe', 'くぇ', 'クェ'),
        ('qwo', 'くぉ', 'クォ'),
        ('ga', 'が', 'ガ'),
        ('gi', 'ぎ', 'ギ'),
        ('gu', 'ぐ', 'グ'),
        ('ge', 'げ', 'ゲ'),
        ('go', 'こ', 'ゴ'),
        ('gya', 'ぎゃ', 'ギャ'),
        ('gyi', 'ぎぃ', 'ギィ'),
        ('gyu', 'ぎゅ', 'ギュ'),
        ('gye', 'ぎぇ', 'ギェ'),
        ('gyo', 'ぎょ', 'ギョ'),
        ('gwa', 'ぐぁ', 'グァ'),
        ('gwi', 'ぐぃ', 'グィ'),
        ('gwu', 'ぐぅ', 'グゥ'),
        ('gwe', 'ぐぇ', 'グェ'),
        ('gwo', 'ぐぉ', 'グォ'),
        ('sa', 'さ', 'サ'),
        ('si', 'し', 'シ'),
        ('su', 'す', 'ス'),
        ('se', 'せ', 'セ'),
        ('so', 'そ', 'ソ'),
        ('sya', 'しゃ', 'シャ'),
        ('syi', 'しぃ', 'シィ'),
        ('syu', 'しゅ', 'シュ'),
        ('sye', 'しぇ', 'シェ'),
        ('syo', 'しょ', 'ショ'),
        ('sha', 'しゃ', 'シャ'),
        ('shi', 'し', 'シ'),
        ('shu', 'しゅ', 'シュ'),
        ('she', 'しぇ', 'シェ'),
        ('sho', 'しょ', 'ショ'),
        ('swa', 'すぁ', 'スァ'),
        ('swi', 'すぃ', 'スィ'),
        ('swu', 'すぅ', 'スゥ'),
        ('swe', 'すぇ', 'スェ'),
        ('swo', 'すぉ', 'スォ'),
        ('za', 'ざ', 'ザ'),
        ('zi', 'じ', 'ジ'),
        ('zu', 'ず', 'ズ'),
        ('ze', 'ぜ', 'ゼ'),
        ('zo', 'ぞ', 'ゾ'),
        ('zya', 'じゃ', 'ジャ'),
        ('zyi', 'じぃ', 'ジィ'),
        ('zyu', 'じゅ', 'ジュ'),
        ('zye', 'じぇ', 'ジェ'),
        ('zyo', 'じょ', 'ジョ'),
        ('ja', 'じゃ', 'ジャ'),
        ('ji', 'じ', 'ジ'),
        ('ju', 'じゅ', 'ジュ'),
        ('je', 'じぇ', 'ジェ'),
        ('jo', 'じょ', 'ジョ'),
        ('jya', 'じゃ', 'ジャ'),
        ('jyi', 'じぃ', 'ジィ'),
        ('jyu', 'じゅ', 'ジュ'),
        ('jye', 'じぇ', 'ジェ'),
        ('jyo', 'じょ', 'ジョ'),
        ('ta', 'た', 'タ'),
        ('ti', 'ち', 'チ'),
        ('tu', 'つ', 'ツ'),
        ('te', 'て', 'テ'),
        ('to', 'と', 'ト'),
        ('tya', 'ちゃ', 'チャ'),
        ('tyi', 'ちぃ', 'チィ'),
        ('tyu', 'ちゅ', 'チュ'),
        ('tye', 'ちぇ', 'チェ'),
        ('tyo', 'ちょ', 'チョ'),
        ('cha', 'ちゃ', 'チャ'),
        ('chi', 'ち', 'チ'),
        ('chu', 'ちゅ', 'チュ'),
        ('che', 'ちぇ', 'チェ'),
        ('cho', 'ちょ', 'チョ'),
        ('cya', 'ちゃ', 'チャ'),
        ('cyi', 'ちぃ', 'チィ'),
        ('cyu', 'ちゅ', 'チュ'),
        ('cye', 'ちぇ', 'チェ'),
        ('cyo', 'ちょ', 'チョ'),
        ('tsa', 'つぁ', 'ツァ'),
        ('tsi', 'つぃ', 'ツィ'),
        ('tsu', 'つ', 'ツ'),
        ('tse', 'つぇ', 'ツェ'),
        ('tso', 'つぉ', 'ツォ'),
        ('tha', 'てゃ', 'テャ'),
        ('thi', 'てぃ', 'ティ'),
        ('thu', 'てゅ', 'テュ'),
        ('the', 'てぇ', 'テェ'),
        ('tho', 'てょ', 'テョ'),
        ('twa', 'とぁ', 'トァ'),
        ('twi', 'とぃ', 'トィ'),
        ('twu', 'とぅ', 'トゥ'),
        ('twe', 'とぇ', 'トェ'),
        ('two', 'とぉ', 'トォ'),
        ('da', 'だ', 'ダ'),
        ('di', 'ぢ', 'ヂ'),
        ('du', 'づ', 'ヅ'),
        ('de', 'で', 'デ'),
        ('do', 'ど', 'ド'),
        ('dya', 'ぢゃ', 'ヂャ'),
        ('dyi', 'ぢぃ', 'ヂィ'),
        ('dyu', 'ぢゅ', 'ヂュ'),
        ('dye', 'ぢぇ', 'ヂェ'),
        ('dyo', 'ぢょ', 'ヂョ'),
        ('dha', 'でゃ', 'デャ'),
        ('dhi', 'でぃ', 'ディ'),
        ('dhu', 'でゅ', 'デュ'),
        ('dhe', 'でぇ', 'デェ'),
        ('dho', 'でょ', 'デョ'),
        ('dwa', 'どぁ', 'ドァ'),
        ('dwi', 'どぃ', 'ドィ'),
        ('dwu', 'どぅ', 'ドゥ'),
        ('dwe', 'どぇ', 'ドェ'),
        ('dwo', 'どぉ', 'ドォ'),
        ('ltu', 'っ', 'ッ'),
        ('xtu', 'っ', 'ッ'),
        ('ltsu', 'っ', 'ッ'),
        ('na', 'な', 'ナ'),
        ('ni', 'に', 'ニ'),
        ('nu', 'ぬ', 'ヌ'),
        ('ne', 'ね', 'ネ'),
        ('no', 'の', 'ノ'),
        ('nya', 'にゃ', 'ニャ'),
        ('nyi', 'にぃ', 'ニィ'),
        ('nyu', 'にゅ', 'ニュ'),
        ('nye', 'にぇ', 'ニェ'),
        ('nyo', 'にょ', 'ニョ'),
        ('ha', 'は', 'ハ'),
        ('hi', 'ひ', 'ヒ'),
        ('hu', 'ふ', 'フ'),
        ('he', 'へ', 'ヘ'),
        ('ho', 'ほ', 'ホ'),
        ('hya', 'ひゃ', 'ヒャ'),
        ('hyi', 'ひぃ', 'ヒィ'),
        ('hyu', 'ひゅ', 'ヒュ'),
        ('hye', 'ひぇ', 'ヒェ'),
        ('hyo', 'ひょ', 'ヒョ'),
        ('fa', 'ふぁ', 'ファ'),
        ('fi', 'ふぃ', 'フィ'),
        ('fu', 'ふ', 'フ'),
        ('fe', 'ふぇ', 'フェ'),
        ('fo', 'ふぉ', 'フォ'),
        ('fwa', 'ふぁ', 'ファ'),
        ('fwi', 'ふぃ', 'フィ'),
        ('fwu', 'ふぅ', 'フゥ'),
        ('fwe', 'ふぇ', 'フェ'),
        ('fwo', 'ふぉ', 'フォ'),
        ('fya', 'ふゃ', 'フャ'),
        ('fyi', 'ふぃ', 'フィ'),
        ('fyu', 'ふゅ', 'フュ'),
        ('fye', 'ふぇ', 'フェ'),
        ('fyo', 'ふょ', 'フョ'),
        ('ba', 'ば', 'バ'),
        ('bi', 'び', 'ビ'),
        ('bu', 'ぶ', 'ブ'),
        ('be', 'べ', 'ベ'),
        ('bo', 'ぼ', 'ボ'),
        ('bya', 'びゃ', 'ビャ'),
        ('byi', 'びぃ', 'ビィ'),
        ('byu', 'びゅ', 'ビュ'),
        ('bye', 'びぇ', 'ビェ'),
        ('byo', 'びょ', 'ビョ'),
        ('pa', 'ぱ', 'パ'),
        ('pi', 'ぴ', 'ピ'),
        ('pu', 'ぷ', 'プ'),
        ('pe', 'ぺ', 'ペ'),
        ('po', 'ぽ', 'ポ'),
        ('pya', 'ぴゃ', 'ピャ'),
        ('pyi', 'ぴぃ', 'ピィ'),
        ('pyu', 'ぴゅ', 'ピュ'),
        ('pye', 'ぴぇ', 'ピェ'),
        ('pyo', 'ぴょ', 'ピョ'),
        ('ma', 'ま', 'マ'),
        ('mi', 'み', 'ミ'),
        ('mu', 'む', 'ム'),
        ('me', 'め', 'メ'),
        ('mo', 'も', 'モ'),
        ('mya', 'みゃ', 'ミャ'),
        ('myi', 'みぃ', 'ミィ'),
        ('myu', 'みゅ', 'ミュ'),
        ('mye', 'みぇ', 'ミェ'),
        ('myo', 'みょ', 'ミョ'),
        ('ya', 'や', 'ヤ'),
        ('yi', 'い', 'イ'),
        ('yu', 'ゆ', 'ユ'),
        # ('ye', 'いぇ', 'イェ'),
        ('ye', 'え', 'エ'), # 追加
        ('yo', 'よ', 'ヨ'),
        ('lya', 'ゃ', 'ャ'),
        ('lyi', 'ぃ', 'ィ'),
        ('lyu', 'ゅ', 'ュ'),
        ('lye', 'ぇ', 'ェ'),
        ('lyo', 'ょ', 'ョ'),
        ('xya', 'ゃ', 'ャ'),
        ('xyi', 'ぃ', 'ィ'),
        ('xyu', 'ゅ', 'ュ'),
        ('xye', 'ぇ', 'ェ'),
        ('xyo', 'ょ', 'ョ'),
        ('ra', 'ら', 'ラ'),
        ('ri', 'り', 'リ'),
        ('ru', 'る', 'ル'),
        ('re', 'れ', 'レ'),
        ('ro', 'ろ', 'ロ'),
        ('wa', 'わ', 'ワ'),
        ('wu', 'う', 'ウ'),
        ('wo', 'を', 'ヲ'),
        ('nn', 'ん', 'ン'),
        ('xn', 'ん', 'ン'),
        ("n'", 'ん', 'ン'),
        ('rya', 'りゃ', 'リャ'),
        ('ryi', 'りぃ', 'リィ'),
        ('ryu', 'りゅ', 'リュ'),
        ('rye', 'りぇ', 'リェ'),
        ('ryo', 'りょ', 'リョ'),
        ('wyi', 'ゐ', 'ヰ'),
        ('wye', 'ゑ', 'ヱ'),
        ('lwa', 'ゎ', 'ヮ'),
        ('-', 'ー', 'ー') # 長音追加
    )

    wi_we = (
        (('wi', 'うぃ', 'ウィ'), ('we', 'うぇ', 'ウェ')),
        (('wi', 'ゐ', 'ヰ'), ('we', 'ゑ', 'ヱ'))
    )

    xk_lk = (
        (('lka', None, 'ヵ'), ('xka', None, 'ヵ'),
            ('lke', None, 'ヶ'), ('xke', None, 'ヶ')),
        (('lka', 'ヵ', 'ヵ'), ('xka', 'ヵ', 'ヵ'),
            ('lke', 'ヶ', 'ヶ'), ('xke', 'ヶ', 'ヶ')),
        (('lka', 'ゕ', 'ヵ'), ('xka', 'ゕ', 'ヵ'),
            ('lke', 'ゖ', 'ヶ'), ('xke', 'ゖ', 'ヶ'))
    )

    v_vy = (
        (
            ('va', None, 'ヴァ'),
            ('vi', None, 'ヴィ'),
            ('vu', None, 'ヴ'),
            ('ve', None, 'ヴェ'),
            ('vo', None, 'ヴォ'),
            ('vya', None, 'ヴャ'),
            ('vyi', None, 'ヴィ'),
            ('vyu', None, 'ヴュ'),
            ('vye', None, 'ヴェ'),
            ('vyo', None, 'ヴョ')
        ),
        (
            ('va', 'ヴぁ', 'ヴァ'),
            ('vi', 'ヴぃ', 'ヴィ'),
            ('vu', 'ヴ', 'ヴ'),
            ('ve', 'ヴぇ', 'ヴェ'),
            ('vo', 'ヴぉ', 'ヴォ'),
            ('vya', 'ヴゃ', 'ヴャ'),
            ('vyi', 'ヴぃ', 'ヴィ'),
            ('vyu', 'ヴゅ', 'ヴュ'),
            ('vye', 'ヴぇ', 'ヴェ'),
            ('vyo', 'ヴょ', 'ヴョ')
        ),
        (
            ('va', 'ゔぁ', 'ヴァ'),
            ('vi', 'ゔぃ', 'ヴィ'),
            ('vu', 'ゔ', 'ヴ'),
            ('ve', 'ゔぇ', 'ヴェ'),
            ('vo', 'ゔぉ', 'ヴォ'),
            ('vya', 'ゔゃ', 'ヴャ'),
            ('vyi', 'ゔぃ', 'ヴィ'),
            ('vyu', 'ゔゅ', 'ヴュ'),
            ('vye', 'ゔぇ', 'ヴェ'),
            ('vyo', 'ゔょ', 'ヴョ')
        )
    )

    n_single = ((), (('n', 'ん', 'ン'),))

    @classmethod
    def _tableList(cls, old_w, n_single, type_xk_lk, type_v_vy):
        return [
            cls.common,
            cls.wi_we[old_w],
            cls.xk_lk[type_xk_lk.value],
            cls.v_vy[type_v_vy.value],
            cls.n_single[n_single]
        ]

    def __new__(cls,
                old_w=False,
                n_single=False,
                type_xk_lk=SpecialHiraType.Kata,
                type_v_vy=SpecialHiraType.Kata):
        for table in cls._tableList(old_w, n_single, type_xk_lk, type_v_vy):
            for item in table:
                yield item


def romaji_to_hiragana(romaji):
    result = ''
    i = 0
    j = 3
    while i < len(romaji):
        is_hit = False
        for item in RomanKanaTable(n_single=True):
            if item[0] == romaji[i:i+j]:
                result += item[1]
                i += j
                j = 3
                is_hit = True
                break
        if not is_hit:
            j -= 1
        if j == 0:
            result += romaji[i:i + 1]
            i += 1
            j = 3
    return result


if __name__ == '__main__':

    text = 'barentainde-'
    print(romaji_to_hiragana(text))
