# coding: utf-8

"""
    Agent API

    This document refers to Symphony API calls to send and receive messages and content. They need the on-premise Agent installed to perform decryption/encryption of content.  - sessionToken and keyManagerToken can be obtained by calling the authenticationAPI on the symphony back end and the key manager respectively. Refer to the methods described in authenticatorAPI.yaml. - Actions are defined to be atomic, ie will succeed in their entirety or fail and have changed nothing. - If it returns a 40X status then it will have sent no message to any stream even if a request to some subset of the requested streams would have succeeded. - If this contract cannot be met for any reason then this is an error and the response code will be 50X. - MessageML is a markup language for messages. See reference here: https://rest-api.symphony.com/docs/messagemlv2 - **Real Time Events**: The following events are returned when reading from a real time messages and events stream (\"datafeed\"). These events will be returned for datafeeds created with the v5 endpoints. To know more about the endpoints, refer to Create Messages/Events Stream and Read Messages/Events Stream. Unless otherwise specified, all events were added in 1.46. 

    The version of the OpenAPI document: 25.8.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictInt, StrictStr
from typing import Optional
from typing_extensions import Annotated
from symphony.bdk.gen.agent_model.v1_audit_trail_initiator_list import V1AuditTrailInitiatorList

from symphony.bdk.gen.api_client import ApiClient, RequestSerialized
from symphony.bdk.gen.api_response import ApiResponse
from symphony.bdk.gen.rest import RESTResponseType


class AuditTrailApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    async def v1_audittrail_privilegeduser_get(
        self,
        session_token: Annotated[StrictStr, Field(description="Session authentication token.")],
        start_timestamp: Annotated[StrictInt, Field(description="Start timestamp in unix timestamp in millseconds.")],
        key_manager_token: Annotated[Optional[StrictStr], Field(description="Key Manager authentication token.")] = None,
        end_timestamp: Annotated[Optional[StrictInt], Field(description="End timestamp in unix timestamp in millseconds. If not specified, it assumes to be current time.")] = None,
        before: Annotated[Optional[StrictStr], Field(description="Return results from an opaque “before” cursor value as presented via a response cursor.")] = None,
        after: Annotated[Optional[StrictStr], Field(description="Return results from an opaque “after” cursor value as presented via a response cursor.")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="Max No. of violations to return. If no value is provided, 50 is the default. Some maximums for limit may be enforced for performance reasons. The maximum supported value is 500. ")] = None,
        initiator_id: Annotated[Optional[StrictInt], Field(description="If present, only the initiator with this initiator <user id> will be returned.")] = None,
        role: Annotated[Optional[StrictStr], Field(description="If present, only the audit trail initiated by s user with privileged role acting as privileged user will be returned. Privileged eliglible roles: User Provisioning (USER_PROVISIONING), Content Management (CONTENT_MANAGEMENT), Expression Filter Policy Management (EF_POLICY_MANAGEMENT), SCO (SUPER_COMPLIANCE_OFFICER), CO (COMPLIANCE_OFFICER), Super admin (SUPER_ADMINISTRATOR), Admin (ADMINISTRATOR), L1 (L1_SUPPORT), L2 (L2_SUPPORT), Scope Manager (SCOPE_MANAGEMENT) ")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> V1AuditTrailInitiatorList:
        """Get a list of  actions performed by a privileged account acting as privileged user given a period of time.

        Get a list of actions performed by a privileged account acting as privileged user given a period of time.

        :param session_token: Session authentication token. (required)
        :type session_token: str
        :param start_timestamp: Start timestamp in unix timestamp in millseconds. (required)
        :type start_timestamp: int
        :param key_manager_token: Key Manager authentication token.
        :type key_manager_token: str
        :param end_timestamp: End timestamp in unix timestamp in millseconds. If not specified, it assumes to be current time.
        :type end_timestamp: int
        :param before: Return results from an opaque “before” cursor value as presented via a response cursor.
        :type before: str
        :param after: Return results from an opaque “after” cursor value as presented via a response cursor.
        :type after: str
        :param limit: Max No. of violations to return. If no value is provided, 50 is the default. Some maximums for limit may be enforced for performance reasons. The maximum supported value is 500. 
        :type limit: int
        :param initiator_id: If present, only the initiator with this initiator <user id> will be returned.
        :type initiator_id: int
        :param role: If present, only the audit trail initiated by s user with privileged role acting as privileged user will be returned. Privileged eliglible roles: User Provisioning (USER_PROVISIONING), Content Management (CONTENT_MANAGEMENT), Expression Filter Policy Management (EF_POLICY_MANAGEMENT), SCO (SUPER_COMPLIANCE_OFFICER), CO (COMPLIANCE_OFFICER), Super admin (SUPER_ADMINISTRATOR), Admin (ADMINISTRATOR), L1 (L1_SUPPORT), L2 (L2_SUPPORT), Scope Manager (SCOPE_MANAGEMENT) 
        :type role: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v1_audittrail_privilegeduser_get_serialize(
            session_token=session_token,
            start_timestamp=start_timestamp,
            key_manager_token=key_manager_token,
            end_timestamp=end_timestamp,
            before=before,
            after=after,
            limit=limit,
            initiator_id=initiator_id,
            role=role,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V1AuditTrailInitiatorList",
            '204': None,
            '400': "Error",
            '401': "Error",
            '403': "Error",
            '500': "Error",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def v1_audittrail_privilegeduser_get_with_http_info(
        self,
        session_token: Annotated[StrictStr, Field(description="Session authentication token.")],
        start_timestamp: Annotated[StrictInt, Field(description="Start timestamp in unix timestamp in millseconds.")],
        key_manager_token: Annotated[Optional[StrictStr], Field(description="Key Manager authentication token.")] = None,
        end_timestamp: Annotated[Optional[StrictInt], Field(description="End timestamp in unix timestamp in millseconds. If not specified, it assumes to be current time.")] = None,
        before: Annotated[Optional[StrictStr], Field(description="Return results from an opaque “before” cursor value as presented via a response cursor.")] = None,
        after: Annotated[Optional[StrictStr], Field(description="Return results from an opaque “after” cursor value as presented via a response cursor.")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="Max No. of violations to return. If no value is provided, 50 is the default. Some maximums for limit may be enforced for performance reasons. The maximum supported value is 500. ")] = None,
        initiator_id: Annotated[Optional[StrictInt], Field(description="If present, only the initiator with this initiator <user id> will be returned.")] = None,
        role: Annotated[Optional[StrictStr], Field(description="If present, only the audit trail initiated by s user with privileged role acting as privileged user will be returned. Privileged eliglible roles: User Provisioning (USER_PROVISIONING), Content Management (CONTENT_MANAGEMENT), Expression Filter Policy Management (EF_POLICY_MANAGEMENT), SCO (SUPER_COMPLIANCE_OFFICER), CO (COMPLIANCE_OFFICER), Super admin (SUPER_ADMINISTRATOR), Admin (ADMINISTRATOR), L1 (L1_SUPPORT), L2 (L2_SUPPORT), Scope Manager (SCOPE_MANAGEMENT) ")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[V1AuditTrailInitiatorList]:
        """Get a list of  actions performed by a privileged account acting as privileged user given a period of time.

        Get a list of actions performed by a privileged account acting as privileged user given a period of time.

        :param session_token: Session authentication token. (required)
        :type session_token: str
        :param start_timestamp: Start timestamp in unix timestamp in millseconds. (required)
        :type start_timestamp: int
        :param key_manager_token: Key Manager authentication token.
        :type key_manager_token: str
        :param end_timestamp: End timestamp in unix timestamp in millseconds. If not specified, it assumes to be current time.
        :type end_timestamp: int
        :param before: Return results from an opaque “before” cursor value as presented via a response cursor.
        :type before: str
        :param after: Return results from an opaque “after” cursor value as presented via a response cursor.
        :type after: str
        :param limit: Max No. of violations to return. If no value is provided, 50 is the default. Some maximums for limit may be enforced for performance reasons. The maximum supported value is 500. 
        :type limit: int
        :param initiator_id: If present, only the initiator with this initiator <user id> will be returned.
        :type initiator_id: int
        :param role: If present, only the audit trail initiated by s user with privileged role acting as privileged user will be returned. Privileged eliglible roles: User Provisioning (USER_PROVISIONING), Content Management (CONTENT_MANAGEMENT), Expression Filter Policy Management (EF_POLICY_MANAGEMENT), SCO (SUPER_COMPLIANCE_OFFICER), CO (COMPLIANCE_OFFICER), Super admin (SUPER_ADMINISTRATOR), Admin (ADMINISTRATOR), L1 (L1_SUPPORT), L2 (L2_SUPPORT), Scope Manager (SCOPE_MANAGEMENT) 
        :type role: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v1_audittrail_privilegeduser_get_serialize(
            session_token=session_token,
            start_timestamp=start_timestamp,
            key_manager_token=key_manager_token,
            end_timestamp=end_timestamp,
            before=before,
            after=after,
            limit=limit,
            initiator_id=initiator_id,
            role=role,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V1AuditTrailInitiatorList",
            '204': None,
            '400': "Error",
            '401': "Error",
            '403': "Error",
            '500': "Error",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def v1_audittrail_privilegeduser_get_without_preload_content(
        self,
        session_token: Annotated[StrictStr, Field(description="Session authentication token.")],
        start_timestamp: Annotated[StrictInt, Field(description="Start timestamp in unix timestamp in millseconds.")],
        key_manager_token: Annotated[Optional[StrictStr], Field(description="Key Manager authentication token.")] = None,
        end_timestamp: Annotated[Optional[StrictInt], Field(description="End timestamp in unix timestamp in millseconds. If not specified, it assumes to be current time.")] = None,
        before: Annotated[Optional[StrictStr], Field(description="Return results from an opaque “before” cursor value as presented via a response cursor.")] = None,
        after: Annotated[Optional[StrictStr], Field(description="Return results from an opaque “after” cursor value as presented via a response cursor.")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="Max No. of violations to return. If no value is provided, 50 is the default. Some maximums for limit may be enforced for performance reasons. The maximum supported value is 500. ")] = None,
        initiator_id: Annotated[Optional[StrictInt], Field(description="If present, only the initiator with this initiator <user id> will be returned.")] = None,
        role: Annotated[Optional[StrictStr], Field(description="If present, only the audit trail initiated by s user with privileged role acting as privileged user will be returned. Privileged eliglible roles: User Provisioning (USER_PROVISIONING), Content Management (CONTENT_MANAGEMENT), Expression Filter Policy Management (EF_POLICY_MANAGEMENT), SCO (SUPER_COMPLIANCE_OFFICER), CO (COMPLIANCE_OFFICER), Super admin (SUPER_ADMINISTRATOR), Admin (ADMINISTRATOR), L1 (L1_SUPPORT), L2 (L2_SUPPORT), Scope Manager (SCOPE_MANAGEMENT) ")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get a list of  actions performed by a privileged account acting as privileged user given a period of time.

        Get a list of actions performed by a privileged account acting as privileged user given a period of time.

        :param session_token: Session authentication token. (required)
        :type session_token: str
        :param start_timestamp: Start timestamp in unix timestamp in millseconds. (required)
        :type start_timestamp: int
        :param key_manager_token: Key Manager authentication token.
        :type key_manager_token: str
        :param end_timestamp: End timestamp in unix timestamp in millseconds. If not specified, it assumes to be current time.
        :type end_timestamp: int
        :param before: Return results from an opaque “before” cursor value as presented via a response cursor.
        :type before: str
        :param after: Return results from an opaque “after” cursor value as presented via a response cursor.
        :type after: str
        :param limit: Max No. of violations to return. If no value is provided, 50 is the default. Some maximums for limit may be enforced for performance reasons. The maximum supported value is 500. 
        :type limit: int
        :param initiator_id: If present, only the initiator with this initiator <user id> will be returned.
        :type initiator_id: int
        :param role: If present, only the audit trail initiated by s user with privileged role acting as privileged user will be returned. Privileged eliglible roles: User Provisioning (USER_PROVISIONING), Content Management (CONTENT_MANAGEMENT), Expression Filter Policy Management (EF_POLICY_MANAGEMENT), SCO (SUPER_COMPLIANCE_OFFICER), CO (COMPLIANCE_OFFICER), Super admin (SUPER_ADMINISTRATOR), Admin (ADMINISTRATOR), L1 (L1_SUPPORT), L2 (L2_SUPPORT), Scope Manager (SCOPE_MANAGEMENT) 
        :type role: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v1_audittrail_privilegeduser_get_serialize(
            session_token=session_token,
            start_timestamp=start_timestamp,
            key_manager_token=key_manager_token,
            end_timestamp=end_timestamp,
            before=before,
            after=after,
            limit=limit,
            initiator_id=initiator_id,
            role=role,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V1AuditTrailInitiatorList",
            '204': None,
            '400': "Error",
            '401': "Error",
            '403': "Error",
            '500': "Error",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _v1_audittrail_privilegeduser_get_serialize(
        self,
        session_token,
        start_timestamp,
        key_manager_token,
        end_timestamp,
        before,
        after,
        limit,
        initiator_id,
        role,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if start_timestamp is not None:
            
            _query_params.append(('startTimestamp', start_timestamp))
            
        if end_timestamp is not None:
            
            _query_params.append(('endTimestamp', end_timestamp))
            
        if before is not None:
            
            _query_params.append(('before', before))
            
        if after is not None:
            
            _query_params.append(('after', after))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if initiator_id is not None:
            
            _query_params.append(('initiatorId', initiator_id))
            
        if role is not None:
            
            _query_params.append(('role', role))
            
        # process the header parameters
        if session_token is not None:
            _header_params['sessionToken'] = session_token
        if key_manager_token is not None:
            _header_params['keyManagerToken'] = key_manager_token
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/audittrail/privilegeduser',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


