# coding: utf-8

"""
    Agent API

    This document refers to Symphony API calls to send and receive messages and content. They need the on-premise Agent installed to perform decryption/encryption of content.  - sessionToken and keyManagerToken can be obtained by calling the authenticationAPI on the symphony back end and the key manager respectively. Refer to the methods described in authenticatorAPI.yaml. - Actions are defined to be atomic, ie will succeed in their entirety or fail and have changed nothing. - If it returns a 40X status then it will have sent no message to any stream even if a request to some subset of the requested streams would have succeeded. - If this contract cannot be met for any reason then this is an error and the response code will be 50X. - MessageML is a markup language for messages. See reference here: https://rest-api.symphony.com/docs/messagemlv2 - **Real Time Events**: The following events are returned when reading from a real time messages and events stream (\"datafeed\"). These events will be returned for datafeeds created with the v5 endpoints. To know more about the endpoints, refer to Create Messages/Events Stream and Read Messages/Events Stream. Unless otherwise specified, all events were added in 1.46. 

    The version of the OpenAPI document: 25.8.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictBytes, StrictInt, StrictStr
from typing import Optional, Union
from typing_extensions import Annotated
from symphony.bdk.gen.agent_model.v1_dlp_violation_message_response import V1DLPViolationMessageResponse
from symphony.bdk.gen.agent_model.v1_dlp_violation_signal_response import V1DLPViolationSignalResponse
from symphony.bdk.gen.agent_model.v1_dlp_violation_stream_response import V1DLPViolationStreamResponse
from symphony.bdk.gen.agent_model.v3_dlp_violation_message_response import V3DLPViolationMessageResponse
from symphony.bdk.gen.agent_model.v3_dlp_violation_signal_response import V3DLPViolationSignalResponse
from symphony.bdk.gen.agent_model.v3_dlp_violation_stream_response import V3DLPViolationStreamResponse

from symphony.bdk.gen.api_client import ApiClient, RequestSerialized
from symphony.bdk.gen.api_response import ApiResponse
from symphony.bdk.gen.rest import RESTResponseType


class ViolationsApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    async def v1_dlp_violations_message_get(
        self,
        start_time: Annotated[StrictInt, Field(description="Timestamp of the first required violation. This is a long integer value representing milliseconds since Jan 1 1970 ")],
        session_token: Annotated[StrictStr, Field(description="Session authentication token.")],
        end_time: Annotated[Optional[StrictInt], Field(description="Timestamp of the last required violation. This is a long integer value representing milliseconds since Jan 1 1970 If unspecified, it will default to current time of the request. ")] = None,
        next: Annotated[Optional[StrictStr], Field(description="Offset of the next chunk of violations. Value is null for the first request.")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="Max No. of violations to return. If no value is provided, 50 is the default. The maximum supported value is 500. ")] = None,
        key_manager_token: Annotated[Optional[StrictStr], Field(description="Key Manager authentication token.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> V1DLPViolationMessageResponse:
        """Get violations as a result of policy enforcement on messages.


        :param start_time: Timestamp of the first required violation. This is a long integer value representing milliseconds since Jan 1 1970  (required)
        :type start_time: int
        :param session_token: Session authentication token. (required)
        :type session_token: str
        :param end_time: Timestamp of the last required violation. This is a long integer value representing milliseconds since Jan 1 1970 If unspecified, it will default to current time of the request. 
        :type end_time: int
        :param next: Offset of the next chunk of violations. Value is null for the first request.
        :type next: str
        :param limit: Max No. of violations to return. If no value is provided, 50 is the default. The maximum supported value is 500. 
        :type limit: int
        :param key_manager_token: Key Manager authentication token.
        :type key_manager_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v1_dlp_violations_message_get_serialize(
            start_time=start_time,
            session_token=session_token,
            end_time=end_time,
            next=next,
            limit=limit,
            key_manager_token=key_manager_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V1DLPViolationMessageResponse",
            '204': None,
            '400': "Error",
            '401': "Error",
            '403': "Error",
            '500': "Error",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def v1_dlp_violations_message_get_with_http_info(
        self,
        start_time: Annotated[StrictInt, Field(description="Timestamp of the first required violation. This is a long integer value representing milliseconds since Jan 1 1970 ")],
        session_token: Annotated[StrictStr, Field(description="Session authentication token.")],
        end_time: Annotated[Optional[StrictInt], Field(description="Timestamp of the last required violation. This is a long integer value representing milliseconds since Jan 1 1970 If unspecified, it will default to current time of the request. ")] = None,
        next: Annotated[Optional[StrictStr], Field(description="Offset of the next chunk of violations. Value is null for the first request.")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="Max No. of violations to return. If no value is provided, 50 is the default. The maximum supported value is 500. ")] = None,
        key_manager_token: Annotated[Optional[StrictStr], Field(description="Key Manager authentication token.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[V1DLPViolationMessageResponse]:
        """Get violations as a result of policy enforcement on messages.


        :param start_time: Timestamp of the first required violation. This is a long integer value representing milliseconds since Jan 1 1970  (required)
        :type start_time: int
        :param session_token: Session authentication token. (required)
        :type session_token: str
        :param end_time: Timestamp of the last required violation. This is a long integer value representing milliseconds since Jan 1 1970 If unspecified, it will default to current time of the request. 
        :type end_time: int
        :param next: Offset of the next chunk of violations. Value is null for the first request.
        :type next: str
        :param limit: Max No. of violations to return. If no value is provided, 50 is the default. The maximum supported value is 500. 
        :type limit: int
        :param key_manager_token: Key Manager authentication token.
        :type key_manager_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v1_dlp_violations_message_get_serialize(
            start_time=start_time,
            session_token=session_token,
            end_time=end_time,
            next=next,
            limit=limit,
            key_manager_token=key_manager_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V1DLPViolationMessageResponse",
            '204': None,
            '400': "Error",
            '401': "Error",
            '403': "Error",
            '500': "Error",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def v1_dlp_violations_message_get_without_preload_content(
        self,
        start_time: Annotated[StrictInt, Field(description="Timestamp of the first required violation. This is a long integer value representing milliseconds since Jan 1 1970 ")],
        session_token: Annotated[StrictStr, Field(description="Session authentication token.")],
        end_time: Annotated[Optional[StrictInt], Field(description="Timestamp of the last required violation. This is a long integer value representing milliseconds since Jan 1 1970 If unspecified, it will default to current time of the request. ")] = None,
        next: Annotated[Optional[StrictStr], Field(description="Offset of the next chunk of violations. Value is null for the first request.")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="Max No. of violations to return. If no value is provided, 50 is the default. The maximum supported value is 500. ")] = None,
        key_manager_token: Annotated[Optional[StrictStr], Field(description="Key Manager authentication token.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get violations as a result of policy enforcement on messages.


        :param start_time: Timestamp of the first required violation. This is a long integer value representing milliseconds since Jan 1 1970  (required)
        :type start_time: int
        :param session_token: Session authentication token. (required)
        :type session_token: str
        :param end_time: Timestamp of the last required violation. This is a long integer value representing milliseconds since Jan 1 1970 If unspecified, it will default to current time of the request. 
        :type end_time: int
        :param next: Offset of the next chunk of violations. Value is null for the first request.
        :type next: str
        :param limit: Max No. of violations to return. If no value is provided, 50 is the default. The maximum supported value is 500. 
        :type limit: int
        :param key_manager_token: Key Manager authentication token.
        :type key_manager_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v1_dlp_violations_message_get_serialize(
            start_time=start_time,
            session_token=session_token,
            end_time=end_time,
            next=next,
            limit=limit,
            key_manager_token=key_manager_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V1DLPViolationMessageResponse",
            '204': None,
            '400': "Error",
            '401': "Error",
            '403': "Error",
            '500': "Error",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _v1_dlp_violations_message_get_serialize(
        self,
        start_time,
        session_token,
        end_time,
        next,
        limit,
        key_manager_token,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if start_time is not None:
            
            _query_params.append(('startTime', start_time))
            
        if end_time is not None:
            
            _query_params.append(('endTime', end_time))
            
        if next is not None:
            
            _query_params.append(('next', next))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        # process the header parameters
        if session_token is not None:
            _header_params['sessionToken'] = session_token
        if key_manager_token is not None:
            _header_params['keyManagerToken'] = key_manager_token
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/dlp/violations/message',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def v1_dlp_violations_signal_get(
        self,
        start_time: Annotated[StrictInt, Field(description="Timestamp of the first required violation. This is a long integer value representing milliseconds since Jan 1 1970 ")],
        session_token: Annotated[StrictStr, Field(description="Session authentication token.")],
        end_time: Annotated[Optional[StrictInt], Field(description="Timestamp of the last required violation. This is a long integer value representing milliseconds since Jan 1 1970 If unspecified, it will default to current time of the request. ")] = None,
        next: Annotated[Optional[StrictStr], Field(description="Offset of the next chunk of violations. Value is null for the first request.")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="Max No. of violations to return. If no value is provided, 50 is the default. The maximum supported value is 500. ")] = None,
        key_manager_token: Annotated[Optional[StrictStr], Field(description="Key Manager authentication token.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> V1DLPViolationSignalResponse:
        """Get violations as a result of policy enforcement on signals.


        :param start_time: Timestamp of the first required violation. This is a long integer value representing milliseconds since Jan 1 1970  (required)
        :type start_time: int
        :param session_token: Session authentication token. (required)
        :type session_token: str
        :param end_time: Timestamp of the last required violation. This is a long integer value representing milliseconds since Jan 1 1970 If unspecified, it will default to current time of the request. 
        :type end_time: int
        :param next: Offset of the next chunk of violations. Value is null for the first request.
        :type next: str
        :param limit: Max No. of violations to return. If no value is provided, 50 is the default. The maximum supported value is 500. 
        :type limit: int
        :param key_manager_token: Key Manager authentication token.
        :type key_manager_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v1_dlp_violations_signal_get_serialize(
            start_time=start_time,
            session_token=session_token,
            end_time=end_time,
            next=next,
            limit=limit,
            key_manager_token=key_manager_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V1DLPViolationSignalResponse",
            '204': None,
            '400': "Error",
            '401': "Error",
            '403': "Error",
            '500': "Error",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def v1_dlp_violations_signal_get_with_http_info(
        self,
        start_time: Annotated[StrictInt, Field(description="Timestamp of the first required violation. This is a long integer value representing milliseconds since Jan 1 1970 ")],
        session_token: Annotated[StrictStr, Field(description="Session authentication token.")],
        end_time: Annotated[Optional[StrictInt], Field(description="Timestamp of the last required violation. This is a long integer value representing milliseconds since Jan 1 1970 If unspecified, it will default to current time of the request. ")] = None,
        next: Annotated[Optional[StrictStr], Field(description="Offset of the next chunk of violations. Value is null for the first request.")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="Max No. of violations to return. If no value is provided, 50 is the default. The maximum supported value is 500. ")] = None,
        key_manager_token: Annotated[Optional[StrictStr], Field(description="Key Manager authentication token.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[V1DLPViolationSignalResponse]:
        """Get violations as a result of policy enforcement on signals.


        :param start_time: Timestamp of the first required violation. This is a long integer value representing milliseconds since Jan 1 1970  (required)
        :type start_time: int
        :param session_token: Session authentication token. (required)
        :type session_token: str
        :param end_time: Timestamp of the last required violation. This is a long integer value representing milliseconds since Jan 1 1970 If unspecified, it will default to current time of the request. 
        :type end_time: int
        :param next: Offset of the next chunk of violations. Value is null for the first request.
        :type next: str
        :param limit: Max No. of violations to return. If no value is provided, 50 is the default. The maximum supported value is 500. 
        :type limit: int
        :param key_manager_token: Key Manager authentication token.
        :type key_manager_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v1_dlp_violations_signal_get_serialize(
            start_time=start_time,
            session_token=session_token,
            end_time=end_time,
            next=next,
            limit=limit,
            key_manager_token=key_manager_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V1DLPViolationSignalResponse",
            '204': None,
            '400': "Error",
            '401': "Error",
            '403': "Error",
            '500': "Error",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def v1_dlp_violations_signal_get_without_preload_content(
        self,
        start_time: Annotated[StrictInt, Field(description="Timestamp of the first required violation. This is a long integer value representing milliseconds since Jan 1 1970 ")],
        session_token: Annotated[StrictStr, Field(description="Session authentication token.")],
        end_time: Annotated[Optional[StrictInt], Field(description="Timestamp of the last required violation. This is a long integer value representing milliseconds since Jan 1 1970 If unspecified, it will default to current time of the request. ")] = None,
        next: Annotated[Optional[StrictStr], Field(description="Offset of the next chunk of violations. Value is null for the first request.")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="Max No. of violations to return. If no value is provided, 50 is the default. The maximum supported value is 500. ")] = None,
        key_manager_token: Annotated[Optional[StrictStr], Field(description="Key Manager authentication token.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get violations as a result of policy enforcement on signals.


        :param start_time: Timestamp of the first required violation. This is a long integer value representing milliseconds since Jan 1 1970  (required)
        :type start_time: int
        :param session_token: Session authentication token. (required)
        :type session_token: str
        :param end_time: Timestamp of the last required violation. This is a long integer value representing milliseconds since Jan 1 1970 If unspecified, it will default to current time of the request. 
        :type end_time: int
        :param next: Offset of the next chunk of violations. Value is null for the first request.
        :type next: str
        :param limit: Max No. of violations to return. If no value is provided, 50 is the default. The maximum supported value is 500. 
        :type limit: int
        :param key_manager_token: Key Manager authentication token.
        :type key_manager_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v1_dlp_violations_signal_get_serialize(
            start_time=start_time,
            session_token=session_token,
            end_time=end_time,
            next=next,
            limit=limit,
            key_manager_token=key_manager_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V1DLPViolationSignalResponse",
            '204': None,
            '400': "Error",
            '401': "Error",
            '403': "Error",
            '500': "Error",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _v1_dlp_violations_signal_get_serialize(
        self,
        start_time,
        session_token,
        end_time,
        next,
        limit,
        key_manager_token,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if start_time is not None:
            
            _query_params.append(('startTime', start_time))
            
        if end_time is not None:
            
            _query_params.append(('endTime', end_time))
            
        if next is not None:
            
            _query_params.append(('next', next))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        # process the header parameters
        if session_token is not None:
            _header_params['sessionToken'] = session_token
        if key_manager_token is not None:
            _header_params['keyManagerToken'] = key_manager_token
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/dlp/violations/signal',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def v1_dlp_violations_stream_get(
        self,
        start_time: Annotated[StrictInt, Field(description="Timestamp of the first required violation. This is a long integer value representing milliseconds since Jan 1 1970 ")],
        session_token: Annotated[StrictStr, Field(description="Session authentication token.")],
        end_time: Annotated[Optional[StrictInt], Field(description="Timestamp of the last required violation. This is a long integer value representing milliseconds since Jan 1 1970 If unspecified, it will default to current time of the request. ")] = None,
        next: Annotated[Optional[StrictStr], Field(description="Offset of the next chunk of violations. Value is null for the first request.")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="Max No. of violations to return. If no value is provided, 50 is the default. The maximum supported value is 500. ")] = None,
        key_manager_token: Annotated[Optional[StrictStr], Field(description="Key Manager authentication token.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> V1DLPViolationStreamResponse:
        """Get violations as a result of policy enforcement on streams.


        :param start_time: Timestamp of the first required violation. This is a long integer value representing milliseconds since Jan 1 1970  (required)
        :type start_time: int
        :param session_token: Session authentication token. (required)
        :type session_token: str
        :param end_time: Timestamp of the last required violation. This is a long integer value representing milliseconds since Jan 1 1970 If unspecified, it will default to current time of the request. 
        :type end_time: int
        :param next: Offset of the next chunk of violations. Value is null for the first request.
        :type next: str
        :param limit: Max No. of violations to return. If no value is provided, 50 is the default. The maximum supported value is 500. 
        :type limit: int
        :param key_manager_token: Key Manager authentication token.
        :type key_manager_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v1_dlp_violations_stream_get_serialize(
            start_time=start_time,
            session_token=session_token,
            end_time=end_time,
            next=next,
            limit=limit,
            key_manager_token=key_manager_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V1DLPViolationStreamResponse",
            '204': None,
            '400': "Error",
            '401': "Error",
            '403': "Error",
            '500': "Error",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def v1_dlp_violations_stream_get_with_http_info(
        self,
        start_time: Annotated[StrictInt, Field(description="Timestamp of the first required violation. This is a long integer value representing milliseconds since Jan 1 1970 ")],
        session_token: Annotated[StrictStr, Field(description="Session authentication token.")],
        end_time: Annotated[Optional[StrictInt], Field(description="Timestamp of the last required violation. This is a long integer value representing milliseconds since Jan 1 1970 If unspecified, it will default to current time of the request. ")] = None,
        next: Annotated[Optional[StrictStr], Field(description="Offset of the next chunk of violations. Value is null for the first request.")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="Max No. of violations to return. If no value is provided, 50 is the default. The maximum supported value is 500. ")] = None,
        key_manager_token: Annotated[Optional[StrictStr], Field(description="Key Manager authentication token.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[V1DLPViolationStreamResponse]:
        """Get violations as a result of policy enforcement on streams.


        :param start_time: Timestamp of the first required violation. This is a long integer value representing milliseconds since Jan 1 1970  (required)
        :type start_time: int
        :param session_token: Session authentication token. (required)
        :type session_token: str
        :param end_time: Timestamp of the last required violation. This is a long integer value representing milliseconds since Jan 1 1970 If unspecified, it will default to current time of the request. 
        :type end_time: int
        :param next: Offset of the next chunk of violations. Value is null for the first request.
        :type next: str
        :param limit: Max No. of violations to return. If no value is provided, 50 is the default. The maximum supported value is 500. 
        :type limit: int
        :param key_manager_token: Key Manager authentication token.
        :type key_manager_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v1_dlp_violations_stream_get_serialize(
            start_time=start_time,
            session_token=session_token,
            end_time=end_time,
            next=next,
            limit=limit,
            key_manager_token=key_manager_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V1DLPViolationStreamResponse",
            '204': None,
            '400': "Error",
            '401': "Error",
            '403': "Error",
            '500': "Error",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def v1_dlp_violations_stream_get_without_preload_content(
        self,
        start_time: Annotated[StrictInt, Field(description="Timestamp of the first required violation. This is a long integer value representing milliseconds since Jan 1 1970 ")],
        session_token: Annotated[StrictStr, Field(description="Session authentication token.")],
        end_time: Annotated[Optional[StrictInt], Field(description="Timestamp of the last required violation. This is a long integer value representing milliseconds since Jan 1 1970 If unspecified, it will default to current time of the request. ")] = None,
        next: Annotated[Optional[StrictStr], Field(description="Offset of the next chunk of violations. Value is null for the first request.")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="Max No. of violations to return. If no value is provided, 50 is the default. The maximum supported value is 500. ")] = None,
        key_manager_token: Annotated[Optional[StrictStr], Field(description="Key Manager authentication token.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get violations as a result of policy enforcement on streams.


        :param start_time: Timestamp of the first required violation. This is a long integer value representing milliseconds since Jan 1 1970  (required)
        :type start_time: int
        :param session_token: Session authentication token. (required)
        :type session_token: str
        :param end_time: Timestamp of the last required violation. This is a long integer value representing milliseconds since Jan 1 1970 If unspecified, it will default to current time of the request. 
        :type end_time: int
        :param next: Offset of the next chunk of violations. Value is null for the first request.
        :type next: str
        :param limit: Max No. of violations to return. If no value is provided, 50 is the default. The maximum supported value is 500. 
        :type limit: int
        :param key_manager_token: Key Manager authentication token.
        :type key_manager_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v1_dlp_violations_stream_get_serialize(
            start_time=start_time,
            session_token=session_token,
            end_time=end_time,
            next=next,
            limit=limit,
            key_manager_token=key_manager_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V1DLPViolationStreamResponse",
            '204': None,
            '400': "Error",
            '401': "Error",
            '403': "Error",
            '500': "Error",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _v1_dlp_violations_stream_get_serialize(
        self,
        start_time,
        session_token,
        end_time,
        next,
        limit,
        key_manager_token,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if start_time is not None:
            
            _query_params.append(('startTime', start_time))
            
        if end_time is not None:
            
            _query_params.append(('endTime', end_time))
            
        if next is not None:
            
            _query_params.append(('next', next))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        # process the header parameters
        if session_token is not None:
            _header_params['sessionToken'] = session_token
        if key_manager_token is not None:
            _header_params['keyManagerToken'] = key_manager_token
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/dlp/violations/stream',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def v3_dlp_violation_attachment_get(
        self,
        file_id: Annotated[StrictStr, Field(description="ID of attachment that will be downloaded.")],
        violation_id: Annotated[StrictStr, Field(description="ID of violation that corresponds to the flagged message that contains the attachment")],
        session_token: Annotated[StrictStr, Field(description="Session authentication token.")],
        key_manager_token: Annotated[Optional[StrictStr], Field(description="Key Manager authentication token.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> bytearray:
        """Get attachments that were sent as part of messages that were flagged by the DLP System.

        Retrieves attachments from related message violations as a base64 encoded String.

        :param file_id: ID of attachment that will be downloaded. (required)
        :type file_id: str
        :param violation_id: ID of violation that corresponds to the flagged message that contains the attachment (required)
        :type violation_id: str
        :param session_token: Session authentication token. (required)
        :type session_token: str
        :param key_manager_token: Key Manager authentication token.
        :type key_manager_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v3_dlp_violation_attachment_get_serialize(
            file_id=file_id,
            violation_id=violation_id,
            session_token=session_token,
            key_manager_token=key_manager_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '400': "Error",
            '401': "Error",
            '403': "Error",
            '404': "Error",
            '500': "Error",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def v3_dlp_violation_attachment_get_with_http_info(
        self,
        file_id: Annotated[StrictStr, Field(description="ID of attachment that will be downloaded.")],
        violation_id: Annotated[StrictStr, Field(description="ID of violation that corresponds to the flagged message that contains the attachment")],
        session_token: Annotated[StrictStr, Field(description="Session authentication token.")],
        key_manager_token: Annotated[Optional[StrictStr], Field(description="Key Manager authentication token.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[bytearray]:
        """Get attachments that were sent as part of messages that were flagged by the DLP System.

        Retrieves attachments from related message violations as a base64 encoded String.

        :param file_id: ID of attachment that will be downloaded. (required)
        :type file_id: str
        :param violation_id: ID of violation that corresponds to the flagged message that contains the attachment (required)
        :type violation_id: str
        :param session_token: Session authentication token. (required)
        :type session_token: str
        :param key_manager_token: Key Manager authentication token.
        :type key_manager_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v3_dlp_violation_attachment_get_serialize(
            file_id=file_id,
            violation_id=violation_id,
            session_token=session_token,
            key_manager_token=key_manager_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '400': "Error",
            '401': "Error",
            '403': "Error",
            '404': "Error",
            '500': "Error",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def v3_dlp_violation_attachment_get_without_preload_content(
        self,
        file_id: Annotated[StrictStr, Field(description="ID of attachment that will be downloaded.")],
        violation_id: Annotated[StrictStr, Field(description="ID of violation that corresponds to the flagged message that contains the attachment")],
        session_token: Annotated[StrictStr, Field(description="Session authentication token.")],
        key_manager_token: Annotated[Optional[StrictStr], Field(description="Key Manager authentication token.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get attachments that were sent as part of messages that were flagged by the DLP System.

        Retrieves attachments from related message violations as a base64 encoded String.

        :param file_id: ID of attachment that will be downloaded. (required)
        :type file_id: str
        :param violation_id: ID of violation that corresponds to the flagged message that contains the attachment (required)
        :type violation_id: str
        :param session_token: Session authentication token. (required)
        :type session_token: str
        :param key_manager_token: Key Manager authentication token.
        :type key_manager_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v3_dlp_violation_attachment_get_serialize(
            file_id=file_id,
            violation_id=violation_id,
            session_token=session_token,
            key_manager_token=key_manager_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '400': "Error",
            '401': "Error",
            '403': "Error",
            '404': "Error",
            '500': "Error",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _v3_dlp_violation_attachment_get_serialize(
        self,
        file_id,
        violation_id,
        session_token,
        key_manager_token,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if file_id is not None:
            
            _query_params.append(('fileId', file_id))
            
        if violation_id is not None:
            
            _query_params.append(('violationId', violation_id))
            
        # process the header parameters
        if session_token is not None:
            _header_params['sessionToken'] = session_token
        if key_manager_token is not None:
            _header_params['keyManagerToken'] = key_manager_token
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/octet-stream'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v3/dlp/violation/attachment',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def v3_dlp_violations_message_get(
        self,
        start_time: Annotated[StrictInt, Field(description="Timestamp of the first required violation. This is a long integer value representing milliseconds since Jan 1 1970 ")],
        session_token: Annotated[StrictStr, Field(description="Session authentication token.")],
        end_time: Annotated[Optional[StrictInt], Field(description="Timestamp of the last required violation. This is a long integer value representing milliseconds since Jan 1 1970 If unspecified, it will default to current time of the request. ")] = None,
        next: Annotated[Optional[StrictStr], Field(description="Offset of the next chunk of violations. Value is null for the first request.")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="Max No. of violations to return. If no value is provided, 50 is the default. The maximum supported value is 500. ")] = None,
        key_manager_token: Annotated[Optional[StrictStr], Field(description="Key Manager authentication token.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> V3DLPViolationMessageResponse:
        """Get violations as a result of policy enforcement on messages.

        Retrieves DLP v3 message related violations for a given time range

        :param start_time: Timestamp of the first required violation. This is a long integer value representing milliseconds since Jan 1 1970  (required)
        :type start_time: int
        :param session_token: Session authentication token. (required)
        :type session_token: str
        :param end_time: Timestamp of the last required violation. This is a long integer value representing milliseconds since Jan 1 1970 If unspecified, it will default to current time of the request. 
        :type end_time: int
        :param next: Offset of the next chunk of violations. Value is null for the first request.
        :type next: str
        :param limit: Max No. of violations to return. If no value is provided, 50 is the default. The maximum supported value is 500. 
        :type limit: int
        :param key_manager_token: Key Manager authentication token.
        :type key_manager_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v3_dlp_violations_message_get_serialize(
            start_time=start_time,
            session_token=session_token,
            end_time=end_time,
            next=next,
            limit=limit,
            key_manager_token=key_manager_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V3DLPViolationMessageResponse",
            '204': None,
            '400': "Error",
            '401': "Error",
            '403': "Error",
            '500': "Error",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def v3_dlp_violations_message_get_with_http_info(
        self,
        start_time: Annotated[StrictInt, Field(description="Timestamp of the first required violation. This is a long integer value representing milliseconds since Jan 1 1970 ")],
        session_token: Annotated[StrictStr, Field(description="Session authentication token.")],
        end_time: Annotated[Optional[StrictInt], Field(description="Timestamp of the last required violation. This is a long integer value representing milliseconds since Jan 1 1970 If unspecified, it will default to current time of the request. ")] = None,
        next: Annotated[Optional[StrictStr], Field(description="Offset of the next chunk of violations. Value is null for the first request.")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="Max No. of violations to return. If no value is provided, 50 is the default. The maximum supported value is 500. ")] = None,
        key_manager_token: Annotated[Optional[StrictStr], Field(description="Key Manager authentication token.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[V3DLPViolationMessageResponse]:
        """Get violations as a result of policy enforcement on messages.

        Retrieves DLP v3 message related violations for a given time range

        :param start_time: Timestamp of the first required violation. This is a long integer value representing milliseconds since Jan 1 1970  (required)
        :type start_time: int
        :param session_token: Session authentication token. (required)
        :type session_token: str
        :param end_time: Timestamp of the last required violation. This is a long integer value representing milliseconds since Jan 1 1970 If unspecified, it will default to current time of the request. 
        :type end_time: int
        :param next: Offset of the next chunk of violations. Value is null for the first request.
        :type next: str
        :param limit: Max No. of violations to return. If no value is provided, 50 is the default. The maximum supported value is 500. 
        :type limit: int
        :param key_manager_token: Key Manager authentication token.
        :type key_manager_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v3_dlp_violations_message_get_serialize(
            start_time=start_time,
            session_token=session_token,
            end_time=end_time,
            next=next,
            limit=limit,
            key_manager_token=key_manager_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V3DLPViolationMessageResponse",
            '204': None,
            '400': "Error",
            '401': "Error",
            '403': "Error",
            '500': "Error",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def v3_dlp_violations_message_get_without_preload_content(
        self,
        start_time: Annotated[StrictInt, Field(description="Timestamp of the first required violation. This is a long integer value representing milliseconds since Jan 1 1970 ")],
        session_token: Annotated[StrictStr, Field(description="Session authentication token.")],
        end_time: Annotated[Optional[StrictInt], Field(description="Timestamp of the last required violation. This is a long integer value representing milliseconds since Jan 1 1970 If unspecified, it will default to current time of the request. ")] = None,
        next: Annotated[Optional[StrictStr], Field(description="Offset of the next chunk of violations. Value is null for the first request.")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="Max No. of violations to return. If no value is provided, 50 is the default. The maximum supported value is 500. ")] = None,
        key_manager_token: Annotated[Optional[StrictStr], Field(description="Key Manager authentication token.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get violations as a result of policy enforcement on messages.

        Retrieves DLP v3 message related violations for a given time range

        :param start_time: Timestamp of the first required violation. This is a long integer value representing milliseconds since Jan 1 1970  (required)
        :type start_time: int
        :param session_token: Session authentication token. (required)
        :type session_token: str
        :param end_time: Timestamp of the last required violation. This is a long integer value representing milliseconds since Jan 1 1970 If unspecified, it will default to current time of the request. 
        :type end_time: int
        :param next: Offset of the next chunk of violations. Value is null for the first request.
        :type next: str
        :param limit: Max No. of violations to return. If no value is provided, 50 is the default. The maximum supported value is 500. 
        :type limit: int
        :param key_manager_token: Key Manager authentication token.
        :type key_manager_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v3_dlp_violations_message_get_serialize(
            start_time=start_time,
            session_token=session_token,
            end_time=end_time,
            next=next,
            limit=limit,
            key_manager_token=key_manager_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V3DLPViolationMessageResponse",
            '204': None,
            '400': "Error",
            '401': "Error",
            '403': "Error",
            '500': "Error",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _v3_dlp_violations_message_get_serialize(
        self,
        start_time,
        session_token,
        end_time,
        next,
        limit,
        key_manager_token,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if start_time is not None:
            
            _query_params.append(('startTime', start_time))
            
        if end_time is not None:
            
            _query_params.append(('endTime', end_time))
            
        if next is not None:
            
            _query_params.append(('next', next))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        # process the header parameters
        if session_token is not None:
            _header_params['sessionToken'] = session_token
        if key_manager_token is not None:
            _header_params['keyManagerToken'] = key_manager_token
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v3/dlp/violations/message',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def v3_dlp_violations_signal_get(
        self,
        start_time: Annotated[StrictInt, Field(description="Timestamp of the first required violation. This is a long integer value representing milliseconds since Jan 1 1970 ")],
        session_token: Annotated[StrictStr, Field(description="Session authentication token.")],
        end_time: Annotated[Optional[StrictInt], Field(description="Timestamp of the last required violation. This is a long integer value representing milliseconds since Jan 1 1970 If unspecified, it will default to current time of the request. ")] = None,
        next: Annotated[Optional[StrictStr], Field(description="Offset of the next chunk of violations. Value is null for the first request.")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="Max No. of violations to return. If no value is provided, 50 is the default. The maximum supported value is 500. ")] = None,
        key_manager_token: Annotated[Optional[StrictStr], Field(description="Key Manager authentication token.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> V3DLPViolationSignalResponse:
        """Get violations as a result of policy enforcement on signals.

        Retrieves DLP v3 signal related violations for a given time range

        :param start_time: Timestamp of the first required violation. This is a long integer value representing milliseconds since Jan 1 1970  (required)
        :type start_time: int
        :param session_token: Session authentication token. (required)
        :type session_token: str
        :param end_time: Timestamp of the last required violation. This is a long integer value representing milliseconds since Jan 1 1970 If unspecified, it will default to current time of the request. 
        :type end_time: int
        :param next: Offset of the next chunk of violations. Value is null for the first request.
        :type next: str
        :param limit: Max No. of violations to return. If no value is provided, 50 is the default. The maximum supported value is 500. 
        :type limit: int
        :param key_manager_token: Key Manager authentication token.
        :type key_manager_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v3_dlp_violations_signal_get_serialize(
            start_time=start_time,
            session_token=session_token,
            end_time=end_time,
            next=next,
            limit=limit,
            key_manager_token=key_manager_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V3DLPViolationSignalResponse",
            '204': None,
            '400': "Error",
            '401': "Error",
            '403': "Error",
            '500': "Error",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def v3_dlp_violations_signal_get_with_http_info(
        self,
        start_time: Annotated[StrictInt, Field(description="Timestamp of the first required violation. This is a long integer value representing milliseconds since Jan 1 1970 ")],
        session_token: Annotated[StrictStr, Field(description="Session authentication token.")],
        end_time: Annotated[Optional[StrictInt], Field(description="Timestamp of the last required violation. This is a long integer value representing milliseconds since Jan 1 1970 If unspecified, it will default to current time of the request. ")] = None,
        next: Annotated[Optional[StrictStr], Field(description="Offset of the next chunk of violations. Value is null for the first request.")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="Max No. of violations to return. If no value is provided, 50 is the default. The maximum supported value is 500. ")] = None,
        key_manager_token: Annotated[Optional[StrictStr], Field(description="Key Manager authentication token.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[V3DLPViolationSignalResponse]:
        """Get violations as a result of policy enforcement on signals.

        Retrieves DLP v3 signal related violations for a given time range

        :param start_time: Timestamp of the first required violation. This is a long integer value representing milliseconds since Jan 1 1970  (required)
        :type start_time: int
        :param session_token: Session authentication token. (required)
        :type session_token: str
        :param end_time: Timestamp of the last required violation. This is a long integer value representing milliseconds since Jan 1 1970 If unspecified, it will default to current time of the request. 
        :type end_time: int
        :param next: Offset of the next chunk of violations. Value is null for the first request.
        :type next: str
        :param limit: Max No. of violations to return. If no value is provided, 50 is the default. The maximum supported value is 500. 
        :type limit: int
        :param key_manager_token: Key Manager authentication token.
        :type key_manager_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v3_dlp_violations_signal_get_serialize(
            start_time=start_time,
            session_token=session_token,
            end_time=end_time,
            next=next,
            limit=limit,
            key_manager_token=key_manager_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V3DLPViolationSignalResponse",
            '204': None,
            '400': "Error",
            '401': "Error",
            '403': "Error",
            '500': "Error",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def v3_dlp_violations_signal_get_without_preload_content(
        self,
        start_time: Annotated[StrictInt, Field(description="Timestamp of the first required violation. This is a long integer value representing milliseconds since Jan 1 1970 ")],
        session_token: Annotated[StrictStr, Field(description="Session authentication token.")],
        end_time: Annotated[Optional[StrictInt], Field(description="Timestamp of the last required violation. This is a long integer value representing milliseconds since Jan 1 1970 If unspecified, it will default to current time of the request. ")] = None,
        next: Annotated[Optional[StrictStr], Field(description="Offset of the next chunk of violations. Value is null for the first request.")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="Max No. of violations to return. If no value is provided, 50 is the default. The maximum supported value is 500. ")] = None,
        key_manager_token: Annotated[Optional[StrictStr], Field(description="Key Manager authentication token.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get violations as a result of policy enforcement on signals.

        Retrieves DLP v3 signal related violations for a given time range

        :param start_time: Timestamp of the first required violation. This is a long integer value representing milliseconds since Jan 1 1970  (required)
        :type start_time: int
        :param session_token: Session authentication token. (required)
        :type session_token: str
        :param end_time: Timestamp of the last required violation. This is a long integer value representing milliseconds since Jan 1 1970 If unspecified, it will default to current time of the request. 
        :type end_time: int
        :param next: Offset of the next chunk of violations. Value is null for the first request.
        :type next: str
        :param limit: Max No. of violations to return. If no value is provided, 50 is the default. The maximum supported value is 500. 
        :type limit: int
        :param key_manager_token: Key Manager authentication token.
        :type key_manager_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v3_dlp_violations_signal_get_serialize(
            start_time=start_time,
            session_token=session_token,
            end_time=end_time,
            next=next,
            limit=limit,
            key_manager_token=key_manager_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V3DLPViolationSignalResponse",
            '204': None,
            '400': "Error",
            '401': "Error",
            '403': "Error",
            '500': "Error",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _v3_dlp_violations_signal_get_serialize(
        self,
        start_time,
        session_token,
        end_time,
        next,
        limit,
        key_manager_token,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if start_time is not None:
            
            _query_params.append(('startTime', start_time))
            
        if end_time is not None:
            
            _query_params.append(('endTime', end_time))
            
        if next is not None:
            
            _query_params.append(('next', next))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        # process the header parameters
        if session_token is not None:
            _header_params['sessionToken'] = session_token
        if key_manager_token is not None:
            _header_params['keyManagerToken'] = key_manager_token
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v3/dlp/violations/signal',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def v3_dlp_violations_stream_get(
        self,
        start_time: Annotated[StrictInt, Field(description="Timestamp of the first required violation. This is a long integer value representing milliseconds since Jan 1 1970 ")],
        session_token: Annotated[StrictStr, Field(description="Session authentication token.")],
        end_time: Annotated[Optional[StrictInt], Field(description="Timestamp of the last required violation. This is a long integer value representing milliseconds since Jan 1 1970 If unspecified, it will default to current time of the request. ")] = None,
        next: Annotated[Optional[StrictStr], Field(description="Offset of the next chunk of violations. Value is null for the first request.")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="Max No. of violations to return. If no value is provided, 50 is the default. The maximum supported value is 500. ")] = None,
        key_manager_token: Annotated[Optional[StrictStr], Field(description="Key Manager authentication token.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> V3DLPViolationStreamResponse:
        """Get violations as a result of policy enforcement on streams.

        Retrieves DLP v3 signal related violations for a given time range

        :param start_time: Timestamp of the first required violation. This is a long integer value representing milliseconds since Jan 1 1970  (required)
        :type start_time: int
        :param session_token: Session authentication token. (required)
        :type session_token: str
        :param end_time: Timestamp of the last required violation. This is a long integer value representing milliseconds since Jan 1 1970 If unspecified, it will default to current time of the request. 
        :type end_time: int
        :param next: Offset of the next chunk of violations. Value is null for the first request.
        :type next: str
        :param limit: Max No. of violations to return. If no value is provided, 50 is the default. The maximum supported value is 500. 
        :type limit: int
        :param key_manager_token: Key Manager authentication token.
        :type key_manager_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v3_dlp_violations_stream_get_serialize(
            start_time=start_time,
            session_token=session_token,
            end_time=end_time,
            next=next,
            limit=limit,
            key_manager_token=key_manager_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V3DLPViolationStreamResponse",
            '204': None,
            '400': "Error",
            '401': "Error",
            '403': "Error",
            '500': "Error",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def v3_dlp_violations_stream_get_with_http_info(
        self,
        start_time: Annotated[StrictInt, Field(description="Timestamp of the first required violation. This is a long integer value representing milliseconds since Jan 1 1970 ")],
        session_token: Annotated[StrictStr, Field(description="Session authentication token.")],
        end_time: Annotated[Optional[StrictInt], Field(description="Timestamp of the last required violation. This is a long integer value representing milliseconds since Jan 1 1970 If unspecified, it will default to current time of the request. ")] = None,
        next: Annotated[Optional[StrictStr], Field(description="Offset of the next chunk of violations. Value is null for the first request.")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="Max No. of violations to return. If no value is provided, 50 is the default. The maximum supported value is 500. ")] = None,
        key_manager_token: Annotated[Optional[StrictStr], Field(description="Key Manager authentication token.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[V3DLPViolationStreamResponse]:
        """Get violations as a result of policy enforcement on streams.

        Retrieves DLP v3 signal related violations for a given time range

        :param start_time: Timestamp of the first required violation. This is a long integer value representing milliseconds since Jan 1 1970  (required)
        :type start_time: int
        :param session_token: Session authentication token. (required)
        :type session_token: str
        :param end_time: Timestamp of the last required violation. This is a long integer value representing milliseconds since Jan 1 1970 If unspecified, it will default to current time of the request. 
        :type end_time: int
        :param next: Offset of the next chunk of violations. Value is null for the first request.
        :type next: str
        :param limit: Max No. of violations to return. If no value is provided, 50 is the default. The maximum supported value is 500. 
        :type limit: int
        :param key_manager_token: Key Manager authentication token.
        :type key_manager_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v3_dlp_violations_stream_get_serialize(
            start_time=start_time,
            session_token=session_token,
            end_time=end_time,
            next=next,
            limit=limit,
            key_manager_token=key_manager_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V3DLPViolationStreamResponse",
            '204': None,
            '400': "Error",
            '401': "Error",
            '403': "Error",
            '500': "Error",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def v3_dlp_violations_stream_get_without_preload_content(
        self,
        start_time: Annotated[StrictInt, Field(description="Timestamp of the first required violation. This is a long integer value representing milliseconds since Jan 1 1970 ")],
        session_token: Annotated[StrictStr, Field(description="Session authentication token.")],
        end_time: Annotated[Optional[StrictInt], Field(description="Timestamp of the last required violation. This is a long integer value representing milliseconds since Jan 1 1970 If unspecified, it will default to current time of the request. ")] = None,
        next: Annotated[Optional[StrictStr], Field(description="Offset of the next chunk of violations. Value is null for the first request.")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="Max No. of violations to return. If no value is provided, 50 is the default. The maximum supported value is 500. ")] = None,
        key_manager_token: Annotated[Optional[StrictStr], Field(description="Key Manager authentication token.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get violations as a result of policy enforcement on streams.

        Retrieves DLP v3 signal related violations for a given time range

        :param start_time: Timestamp of the first required violation. This is a long integer value representing milliseconds since Jan 1 1970  (required)
        :type start_time: int
        :param session_token: Session authentication token. (required)
        :type session_token: str
        :param end_time: Timestamp of the last required violation. This is a long integer value representing milliseconds since Jan 1 1970 If unspecified, it will default to current time of the request. 
        :type end_time: int
        :param next: Offset of the next chunk of violations. Value is null for the first request.
        :type next: str
        :param limit: Max No. of violations to return. If no value is provided, 50 is the default. The maximum supported value is 500. 
        :type limit: int
        :param key_manager_token: Key Manager authentication token.
        :type key_manager_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v3_dlp_violations_stream_get_serialize(
            start_time=start_time,
            session_token=session_token,
            end_time=end_time,
            next=next,
            limit=limit,
            key_manager_token=key_manager_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V3DLPViolationStreamResponse",
            '204': None,
            '400': "Error",
            '401': "Error",
            '403': "Error",
            '500': "Error",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _v3_dlp_violations_stream_get_serialize(
        self,
        start_time,
        session_token,
        end_time,
        next,
        limit,
        key_manager_token,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if start_time is not None:
            
            _query_params.append(('startTime', start_time))
            
        if end_time is not None:
            
            _query_params.append(('endTime', end_time))
            
        if next is not None:
            
            _query_params.append(('next', next))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        # process the header parameters
        if session_token is not None:
            _header_params['sessionToken'] = session_token
        if key_manager_token is not None:
            _header_params['keyManagerToken'] = key_manager_token
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v3/dlp/violations/stream',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


