# coding: utf-8

"""
    Agent API

    This document refers to Symphony API calls to send and receive messages and content. They need the on-premise Agent installed to perform decryption/encryption of content.  - sessionToken and keyManagerToken can be obtained by calling the authenticationAPI on the symphony back end and the key manager respectively. Refer to the methods described in authenticatorAPI.yaml. - Actions are defined to be atomic, ie will succeed in their entirety or fail and have changed nothing. - If it returns a 40X status then it will have sent no message to any stream even if a request to some subset of the requested streams would have succeeded. - If this contract cannot be met for any reason then this is an error and the response code will be 50X. - MessageML is a markup language for messages. See reference here: https://rest-api.symphony.com/docs/messagemlv2 - **Real Time Events**: The following events are returned when reading from a real time messages and events stream (\"datafeed\"). These events will be returned for datafeeds created with the v5 endpoints. To know more about the endpoints, refer to Create Messages/Events Stream and Read Messages/Events Stream. Unless otherwise specified, all events were added in 1.46. 

    The version of the OpenAPI document: 25.8.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class V1DLPStream(BaseModel):
    """
    Room details in the context of violation.
    """ # noqa: E501
    name: Optional[StrictStr] = Field(default=None, description="Name of the Stream/Room.")
    creator_pretty_name: Optional[StrictStr] = Field(default=None, description="Name of the creator of the Room.", alias="creatorPrettyName")
    public_room: Optional[StrictBool] = Field(default=None, description="Is this a public room?", alias="publicRoom")
    cross_pod: Optional[StrictBool] = Field(default=None, description="Is this a cross pod scenario?", alias="crossPod")
    allow_external: Optional[StrictBool] = Field(default=None, description="Is external messaging allowed", alias="allowExternal")
    creator_id: Optional[StrictStr] = Field(default=None, description="Id of the creator of the Room.", alias="creatorId")
    room_description: Optional[StrictStr] = Field(default=None, description="Description of the Room.", alias="roomDescription")
    stream_id: Optional[StrictStr] = Field(default=None, description="ThreadId of the Room.", alias="streamId")
    state: Optional[StrictStr] = Field(default=None, description="State of the Room (example CREATED etc)")
    type: Optional[StrictStr] = Field(default=None, description="Type of the Room (example ROOM (or IM or Wall))")
    last_disabled: Optional[StrictInt] = Field(default=None, description="Timestamp of last time the room is Disabled", alias="lastDisabled")
    member_add_user_enabled: Optional[StrictBool] = Field(default=None, description="Is memberAddUserEnabled", alias="memberAddUserEnabled")
    active: Optional[StrictBool] = Field(default=None, description="Is Room Active")
    discoverable: Optional[StrictBool] = Field(default=None, description="Is Room discoverable")
    read_only: Optional[StrictBool] = Field(default=None, description="Is Room read-only", alias="readOnly")
    copy_disabled: Optional[StrictBool] = Field(default=None, description="Is Room copyDisabled", alias="copyDisabled")
    external_owned: Optional[StrictBool] = Field(default=None, description="Is Room externalOwned", alias="externalOwned")
    send_message_disabled: Optional[StrictBool] = Field(default=None, description="Is sendMessage Disabled for this Room", alias="sendMessageDisabled")
    moderated: Optional[StrictBool] = Field(default=None, description="Is room moderated")
    share_history_enabled: Optional[StrictBool] = Field(default=None, description="Is room shareHistoryEnabled", alias="shareHistoryEnabled")
    diagnostic: Optional[StrictStr] = Field(default=None, description="A diagnostic message containing an error message in the event that the stream retrieval failed. May also be present in the case of a successful call if there is useful narrative to return. ")
    __properties: ClassVar[List[str]] = ["name", "creatorPrettyName", "publicRoom", "crossPod", "allowExternal", "creatorId", "roomDescription", "streamId", "state", "type", "lastDisabled", "memberAddUserEnabled", "active", "discoverable", "readOnly", "copyDisabled", "externalOwned", "sendMessageDisabled", "moderated", "shareHistoryEnabled", "diagnostic"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of V1DLPStream from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of V1DLPStream from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "creatorPrettyName": obj.get("creatorPrettyName"),
            "publicRoom": obj.get("publicRoom"),
            "crossPod": obj.get("crossPod"),
            "allowExternal": obj.get("allowExternal"),
            "creatorId": obj.get("creatorId"),
            "roomDescription": obj.get("roomDescription"),
            "streamId": obj.get("streamId"),
            "state": obj.get("state"),
            "type": obj.get("type"),
            "lastDisabled": obj.get("lastDisabled"),
            "memberAddUserEnabled": obj.get("memberAddUserEnabled"),
            "active": obj.get("active"),
            "discoverable": obj.get("discoverable"),
            "readOnly": obj.get("readOnly"),
            "copyDisabled": obj.get("copyDisabled"),
            "externalOwned": obj.get("externalOwned"),
            "sendMessageDisabled": obj.get("sendMessageDisabled"),
            "moderated": obj.get("moderated"),
            "shareHistoryEnabled": obj.get("shareHistoryEnabled"),
            "diagnostic": obj.get("diagnostic")
        })
        return _obj


