# coding: utf-8

"""
    Agent API

    This document refers to Symphony API calls to send and receive messages and content. They need the on-premise Agent installed to perform decryption/encryption of content.  - sessionToken and keyManagerToken can be obtained by calling the authenticationAPI on the symphony back end and the key manager respectively. Refer to the methods described in authenticatorAPI.yaml. - Actions are defined to be atomic, ie will succeed in their entirety or fail and have changed nothing. - If it returns a 40X status then it will have sent no message to any stream even if a request to some subset of the requested streams would have succeeded. - If this contract cannot be met for any reason then this is an error and the response code will be 50X. - MessageML is a markup language for messages. See reference here: https://rest-api.symphony.com/docs/messagemlv2 - **Real Time Events**: The following events are returned when reading from a real time messages and events stream (\"datafeed\"). These events will be returned for datafeeds created with the v5 endpoints. To know more about the endpoints, refer to Create Messages/Events Stream and Read Messages/Events Stream. Unless otherwise specified, all events were added in 1.46. 

    The version of the OpenAPI document: 25.8.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from importlib import import_module
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

from typing import TYPE_CHECKING
if TYPE_CHECKING:
    from symphony.bdk.gen.agent_model.connection_request_message import ConnectionRequestMessage
    from symphony.bdk.gen.agent_model.room_created_message import RoomCreatedMessage
    from symphony.bdk.gen.agent_model.room_deactivated_message import RoomDeactivatedMessage
    from symphony.bdk.gen.agent_model.room_member_demoted_from_owner_message import RoomMemberDemotedFromOwnerMessage
    from symphony.bdk.gen.agent_model.room_member_promoted_to_owner_message import RoomMemberPromotedToOwnerMessage
    from symphony.bdk.gen.agent_model.room_reactivated_message import RoomReactivatedMessage
    from symphony.bdk.gen.agent_model.room_updated_message import RoomUpdatedMessage
    from symphony.bdk.gen.agent_model.user_joined_room_message import UserJoinedRoomMessage
    from symphony.bdk.gen.agent_model.user_left_room_message import UserLeftRoomMessage
    from symphony.bdk.gen.agent_model.v2_message import V2Message

class V2BaseMessage(BaseModel):
    """
    V2BaseMessage
    """ # noqa: E501
    id: Optional[StrictStr] = Field(default=None, description="The messageId is assigned by the ingestor service when a message is sent.")
    timestamp: StrictStr
    v2message_type: StrictStr = Field(alias="v2messageType")
    stream_id: StrictStr = Field(alias="streamId")
    __properties: ClassVar[List[str]] = ["id", "timestamp", "v2messageType", "streamId"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    # JSON field name that stores the object type
    __discriminator_property_name: ClassVar[str] = 'v2messageType'

    # discriminator mappings
    __discriminator_value_class_map: ClassVar[Dict[str, str]] = {
        'ConnectionRequestMessage': 'ConnectionRequestMessage','RoomCreatedMessage': 'RoomCreatedMessage','RoomDeactivatedMessage': 'RoomDeactivatedMessage','RoomMemberDemotedFromOwnerMessage': 'RoomMemberDemotedFromOwnerMessage','RoomMemberPromotedToOwnerMessage': 'RoomMemberPromotedToOwnerMessage','RoomReactivatedMessage': 'RoomReactivatedMessage','RoomUpdatedMessage': 'RoomUpdatedMessage','UserJoinedRoomMessage': 'UserJoinedRoomMessage','UserLeftRoomMessage': 'UserLeftRoomMessage','V2Message': 'V2Message'
    }

    @classmethod
    def get_discriminator_value(cls, obj: Dict[str, Any]) -> Optional[str]:
        """Returns the discriminator value (object type) of the data"""
        discriminator_value = obj[cls.__discriminator_property_name]
        if discriminator_value:
            return cls.__discriminator_value_class_map.get(discriminator_value)
        else:
            return None

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Union[ConnectionRequestMessage, RoomCreatedMessage, RoomDeactivatedMessage, RoomMemberDemotedFromOwnerMessage, RoomMemberPromotedToOwnerMessage, RoomReactivatedMessage, RoomUpdatedMessage, UserJoinedRoomMessage, UserLeftRoomMessage, V2Message]]:
        """Create an instance of V2BaseMessage from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict[str, Any]) -> Optional[Union[ConnectionRequestMessage, RoomCreatedMessage, RoomDeactivatedMessage, RoomMemberDemotedFromOwnerMessage, RoomMemberPromotedToOwnerMessage, RoomReactivatedMessage, RoomUpdatedMessage, UserJoinedRoomMessage, UserLeftRoomMessage, V2Message]]:
        """Create an instance of V2BaseMessage from a dict"""
        # look up the object type based on discriminator mapping
        object_type = cls.get_discriminator_value(obj)
        if object_type ==  'ConnectionRequestMessage':
            return import_module("symphony.bdk.gen.agent_model.connection_request_message").ConnectionRequestMessage.from_dict(obj)
        if object_type ==  'RoomCreatedMessage':
            return import_module("symphony.bdk.gen.agent_model.room_created_message").RoomCreatedMessage.from_dict(obj)
        if object_type ==  'RoomDeactivatedMessage':
            return import_module("symphony.bdk.gen.agent_model.room_deactivated_message").RoomDeactivatedMessage.from_dict(obj)
        if object_type ==  'RoomMemberDemotedFromOwnerMessage':
            return import_module("symphony.bdk.gen.agent_model.room_member_demoted_from_owner_message").RoomMemberDemotedFromOwnerMessage.from_dict(obj)
        if object_type ==  'RoomMemberPromotedToOwnerMessage':
            return import_module("symphony.bdk.gen.agent_model.room_member_promoted_to_owner_message").RoomMemberPromotedToOwnerMessage.from_dict(obj)
        if object_type ==  'RoomReactivatedMessage':
            return import_module("symphony.bdk.gen.agent_model.room_reactivated_message").RoomReactivatedMessage.from_dict(obj)
        if object_type ==  'RoomUpdatedMessage':
            return import_module("symphony.bdk.gen.agent_model.room_updated_message").RoomUpdatedMessage.from_dict(obj)
        if object_type ==  'UserJoinedRoomMessage':
            return import_module("symphony.bdk.gen.agent_model.user_joined_room_message").UserJoinedRoomMessage.from_dict(obj)
        if object_type ==  'UserLeftRoomMessage':
            return import_module("symphony.bdk.gen.agent_model.user_left_room_message").UserLeftRoomMessage.from_dict(obj)
        if object_type ==  'V2Message':
            return import_module("symphony.bdk.gen.agent_model.v2_message").V2Message.from_dict(obj)

        raise ValueError("V2BaseMessage failed to lookup discriminator value from " +
                            json.dumps(obj) + ". Discriminator property name: " + cls.__discriminator_property_name +
                            ", mapping: " + json.dumps(cls.__discriminator_value_class_map))


