# coding: utf-8

"""
    Agent API

    This document refers to Symphony API calls to send and receive messages and content. They need the on-premise Agent installed to perform decryption/encryption of content.  - sessionToken and keyManagerToken can be obtained by calling the authenticationAPI on the symphony back end and the key manager respectively. Refer to the methods described in authenticatorAPI.yaml. - Actions are defined to be atomic, ie will succeed in their entirety or fail and have changed nothing. - If it returns a 40X status then it will have sent no message to any stream even if a request to some subset of the requested streams would have succeeded. - If this contract cannot be met for any reason then this is an error and the response code will be 50X. - MessageML is a markup language for messages. See reference here: https://rest-api.symphony.com/docs/messagemlv2 - **Real Time Events**: The following events are returned when reading from a real time messages and events stream (\"datafeed\"). These events will be returned for datafeeds created with the v5 endpoints. To know more about the endpoints, refer to Create Messages/Events Stream and Read Messages/Events Stream. Unless otherwise specified, all events were added in 1.46. 

    The version of the OpenAPI document: 25.8.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class V2ImportedMessage(BaseModel):
    """
    A historic message to be imported into the system. The importing user must have the Content Management role. Also, the importing user must be a member of the conversation it is importing into. The user that the message is intended to have come from must also be present in the conversation. The intended message timestamp must be a valid time from the past. It cannot be a future timestamp. By design, imported messages do not stream to datafeed or firehose endpoints. 
    """ # noqa: E501
    message: StrictStr = Field(description="Message text in MessageML")
    format: Optional[StrictStr] = None
    intended_message_timestamp: StrictInt = Field(description="The timestamp representing the time when the message was sent in the original system in milliseconds since Jan 1st 1970. ", alias="intendedMessageTimestamp")
    intended_message_from_user_id: StrictInt = Field(description="The long integer userid of the Symphony user who you intend to show sent the message.", alias="intendedMessageFromUserId")
    originating_system_id: StrictStr = Field(description="The ID of the system through which the message was originally sent.", alias="originatingSystemId")
    original_message_id: Optional[StrictStr] = Field(default=None, description="The ID of the message in the original system.", alias="originalMessageId")
    stream_id: StrictStr = Field(alias="streamId")
    __properties: ClassVar[List[str]] = ["message", "format", "intendedMessageTimestamp", "intendedMessageFromUserId", "originatingSystemId", "originalMessageId", "streamId"]

    @field_validator('format')
    def format_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['TEXT', 'MESSAGEML']):
            raise ValueError("must be one of enum values ('TEXT', 'MESSAGEML')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of V2ImportedMessage from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of V2ImportedMessage from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "message": obj.get("message"),
            "format": obj.get("format"),
            "intendedMessageTimestamp": obj.get("intendedMessageTimestamp"),
            "intendedMessageFromUserId": obj.get("intendedMessageFromUserId"),
            "originatingSystemId": obj.get("originatingSystemId"),
            "originalMessageId": obj.get("originalMessageId"),
            "streamId": obj.get("streamId")
        })
        return _obj


