# coding: utf-8

"""
    Agent API

    This document refers to Symphony API calls to send and receive messages and content. They need the on-premise Agent installed to perform decryption/encryption of content.  - sessionToken and keyManagerToken can be obtained by calling the authenticationAPI on the symphony back end and the key manager respectively. Refer to the methods described in authenticatorAPI.yaml. - Actions are defined to be atomic, ie will succeed in their entirety or fail and have changed nothing. - If it returns a 40X status then it will have sent no message to any stream even if a request to some subset of the requested streams would have succeeded. - If this contract cannot be met for any reason then this is an error and the response code will be 50X. - MessageML is a markup language for messages. See reference here: https://rest-api.symphony.com/docs/messagemlv2 - **Real Time Events**: The following events are returned when reading from a real time messages and events stream (\"datafeed\"). These events will be returned for datafeeds created with the v5 endpoints. To know more about the endpoints, refer to Create Messages/Events Stream and Read Messages/Events Stream. Unless otherwise specified, all events were added in 1.46. 

    The version of the OpenAPI document: 25.8.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from symphony.bdk.gen.agent_model.v3_dlp_policy_applies_to import V3DLPPolicyAppliesTo
from typing import Optional, Set
from typing_extensions import Self

class V3DLPPolicy(BaseModel):
    """
    A policy is the main entity of V3 policy/rule system. It is responsible to define rules and add scope constraints to the engine. 
    """ # noqa: E501
    id: Optional[StrictStr] = Field(default=None, description="Unique identifier for policy.")
    policy_id: Optional[StrictStr] = Field(default=None, description="Policy Id.", alias="policyId")
    version: Optional[StrictStr] = Field(default=None, description="The version of the policy, in format \"major.minor\". Initial value will set by backend as \"3.0\" when created. Whenever the policy version needs to be changed, the minor version by 1 unless minor == 999, then the major version is increased by 1 until it reaches 999. ")
    name: Optional[StrictStr] = Field(default=None, description="Unique name of policy, max 30 characters. Cannot be empty. All the leading and trailing blank spaces are trimmed. ")
    creator_id: Optional[StrictInt] = Field(default=None, description="Numeric userId of the creator.", alias="creatorId")
    scopes: Optional[List[StrictStr]] = Field(default=None, description="List of communication scopes. Possible values are \"Internal\" (for Internal conversations) or \"External\" (for External conversations). You can apply both scopes if you set it to [\"Internal\", \"External\"]. ")
    applies_to: List[V3DLPPolicyAppliesTo] = Field(alias="appliesTo")
    active: Optional[StrictBool] = Field(default=None, description="Indicate whether the policy is active or not.")
    deleted: Optional[StrictBool] = Field(default=None, description="Indicate whether the policy is deleted or not.")
    creation_date: Optional[StrictInt] = Field(default=None, description="Creation time of the policy in milliseconds elapsed as of epoch time.", alias="creationDate")
    last_updated_date: Optional[StrictInt] = Field(default=None, description="Recent update time of the policy in milliseconds elapsed as of epoch time.", alias="lastUpdatedDate")
    last_disabled_date: Optional[StrictInt] = Field(default=None, description="Recent disable time of the policy in milliseconds elapsed as of epoch time.", alias="lastDisabledDate")
    system_policy: Optional[StrictBool] = Field(default=None, alias="systemPolicy")
    __properties: ClassVar[List[str]] = ["id", "policyId", "version", "name", "creatorId", "scopes", "appliesTo", "active", "deleted", "creationDate", "lastUpdatedDate", "lastDisabledDate", "systemPolicy"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of V3DLPPolicy from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in applies_to (list)
        _items = []
        if self.applies_to:
            for _item_applies_to in self.applies_to:
                if _item_applies_to:
                    _items.append(_item_applies_to.to_dict())
            _dict['appliesTo'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of V3DLPPolicy from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "policyId": obj.get("policyId"),
            "version": obj.get("version"),
            "name": obj.get("name"),
            "creatorId": obj.get("creatorId"),
            "scopes": obj.get("scopes"),
            "appliesTo": [V3DLPPolicyAppliesTo.from_dict(_item) for _item in obj["appliesTo"]] if obj.get("appliesTo") is not None else None,
            "active": obj.get("active"),
            "deleted": obj.get("deleted"),
            "creationDate": obj.get("creationDate"),
            "lastUpdatedDate": obj.get("lastUpdatedDate"),
            "lastDisabledDate": obj.get("lastDisabledDate"),
            "systemPolicy": obj.get("systemPolicy")
        })
        return _obj


