# coding: utf-8

"""
    Agent API

    This document refers to Symphony API calls to send and receive messages and content. They need the on-premise Agent installed to perform decryption/encryption of content.  - sessionToken and keyManagerToken can be obtained by calling the authenticationAPI on the symphony back end and the key manager respectively. Refer to the methods described in authenticatorAPI.yaml. - Actions are defined to be atomic, ie will succeed in their entirety or fail and have changed nothing. - If it returns a 40X status then it will have sent no message to any stream even if a request to some subset of the requested streams would have succeeded. - If this contract cannot be met for any reason then this is an error and the response code will be 50X. - MessageML is a markup language for messages. See reference here: https://rest-api.symphony.com/docs/messagemlv2 - **Real Time Events**: The following events are returned when reading from a real time messages and events stream (\"datafeed\"). These events will be returned for datafeeds created with the v5 endpoints. To know more about the endpoints, refer to Create Messages/Events Stream and Read Messages/Events Stream. Unless otherwise specified, all events were added in 1.46. 

    The version of the OpenAPI document: 25.8.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from symphony.bdk.gen.agent_model.v3_dlp_file_classifier_config import V3DLPFileClassifierConfig
from symphony.bdk.gen.agent_model.v3_dlp_file_extension_config import V3DLPFileExtensionConfig
from symphony.bdk.gen.agent_model.v3_dlp_file_password_config import V3DLPFilePasswordConfig
from symphony.bdk.gen.agent_model.v3_dlp_file_size_config import V3DLPFileSizeConfig
from symphony.bdk.gen.agent_model.v3_dlp_text_match_config import V3DLPTextMatchConfig
from typing import Optional, Set
from typing_extensions import Self

class V3DLPRule(BaseModel):
    """
    A Rule defines the actual matching specification for policies. It holds a type and a configuration for the rule, these properties should be used to build the corresponding matching implementation. Only one of the configuration property should be set [textMatchConfig, fileSizeConfig, fileExtensionConfig, filePasswordConfig, fileClassifierConfig]. 
    """ # noqa: E501
    id: Optional[StrictStr] = None
    type: StrictStr = Field(description="Type of a rule used by policy. Can be [\"UNKNOWN\", \"TEXT_MATCH\", \"FILE_EXTENSION\", \"FILE_SIZE\", \"FILE_PASSWORD\", \"FILE_CLASSIFIER\"].")
    name: StrictStr = Field(description="Name for rule.")
    text_match_config: Optional[V3DLPTextMatchConfig] = Field(default=None, alias="textMatchConfig")
    file_size_config: Optional[V3DLPFileSizeConfig] = Field(default=None, alias="fileSizeConfig")
    file_extension_config: Optional[V3DLPFileExtensionConfig] = Field(default=None, alias="fileExtensionConfig")
    file_password_config: Optional[V3DLPFilePasswordConfig] = Field(default=None, alias="filePasswordConfig")
    file_classifier_config: Optional[V3DLPFileClassifierConfig] = Field(default=None, alias="fileClassifierConfig")
    __properties: ClassVar[List[str]] = ["id", "type", "name", "textMatchConfig", "fileSizeConfig", "fileExtensionConfig", "filePasswordConfig", "fileClassifierConfig"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of V3DLPRule from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of text_match_config
        if self.text_match_config:
            _dict['textMatchConfig'] = self.text_match_config.to_dict()
        # override the default output from pydantic by calling `to_dict()` of file_size_config
        if self.file_size_config:
            _dict['fileSizeConfig'] = self.file_size_config.to_dict()
        # override the default output from pydantic by calling `to_dict()` of file_extension_config
        if self.file_extension_config:
            _dict['fileExtensionConfig'] = self.file_extension_config.to_dict()
        # override the default output from pydantic by calling `to_dict()` of file_password_config
        if self.file_password_config:
            _dict['filePasswordConfig'] = self.file_password_config.to_dict()
        # override the default output from pydantic by calling `to_dict()` of file_classifier_config
        if self.file_classifier_config:
            _dict['fileClassifierConfig'] = self.file_classifier_config.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of V3DLPRule from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "type": obj.get("type"),
            "name": obj.get("name"),
            "textMatchConfig": V3DLPTextMatchConfig.from_dict(obj["textMatchConfig"]) if obj.get("textMatchConfig") is not None else None,
            "fileSizeConfig": V3DLPFileSizeConfig.from_dict(obj["fileSizeConfig"]) if obj.get("fileSizeConfig") is not None else None,
            "fileExtensionConfig": V3DLPFileExtensionConfig.from_dict(obj["fileExtensionConfig"]) if obj.get("fileExtensionConfig") is not None else None,
            "filePasswordConfig": V3DLPFilePasswordConfig.from_dict(obj["filePasswordConfig"]) if obj.get("filePasswordConfig") is not None else None,
            "fileClassifierConfig": V3DLPFileClassifierConfig.from_dict(obj["fileClassifierConfig"]) if obj.get("fileClassifierConfig") is not None else None
        })
        return _obj


