# coding: utf-8

"""
    Agent API

    This document refers to Symphony API calls to send and receive messages and content. They need the on-premise Agent installed to perform decryption/encryption of content.  - sessionToken and keyManagerToken can be obtained by calling the authenticationAPI on the symphony back end and the key manager respectively. Refer to the methods described in authenticatorAPI.yaml. - Actions are defined to be atomic, ie will succeed in their entirety or fail and have changed nothing. - If it returns a 40X status then it will have sent no message to any stream even if a request to some subset of the requested streams would have succeeded. - If this contract cannot be met for any reason then this is an error and the response code will be 50X. - MessageML is a markup language for messages. See reference here: https://rest-api.symphony.com/docs/messagemlv2 - **Real Time Events**: The following events are returned when reading from a real time messages and events stream (\"datafeed\"). These events will be returned for datafeeds created with the v5 endpoints. To know more about the endpoints, refer to Create Messages/Events Stream and Read Messages/Events Stream. Unless otherwise specified, all events were added in 1.46. 

    The version of the OpenAPI document: 25.8.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from symphony.bdk.gen.agent_model.v4_attachment_info import V4AttachmentInfo
from symphony.bdk.gen.agent_model.v4_stream import V4Stream
from symphony.bdk.gen.agent_model.v4_user import V4User
from typing import Optional, Set
from typing_extensions import Self

class V4Message(BaseModel):
    """
    A representation of a message sent by a user of Symphony
    """ # noqa: E501
    message_id: Optional[StrictStr] = Field(default=None, description="Id of the message", alias="messageId")
    parent_message_id: Optional[StrictStr] = Field(default=None, description="Id of the parent message, set when the message is a reply to another message or a forwarded message. Since Agent 20.14.", alias="parentMessageId")
    timestamp: Optional[StrictInt] = Field(default=None, description="Timestamp of the message in milliseconds since Jan 1 1970")
    message: Optional[StrictStr] = Field(default=None, description="Message content in MessageMLV2")
    shared_message: Optional[V4Message] = Field(default=None, alias="sharedMessage")
    data: Optional[StrictStr] = Field(default=None, description="Message data in EntityJSON")
    attachments: Optional[List[V4AttachmentInfo]] = Field(default=None, description="Message attachments")
    user: Optional[V4User] = None
    stream: Optional[V4Stream] = None
    external_recipients: Optional[StrictBool] = Field(default=None, description="Indicates if the message have external recipients. Only present on real time messaging.", alias="externalRecipients")
    diagnostic: Optional[StrictStr] = Field(default=None, description="Details if event failed to parse for any reason.  The contents of this field may not be useful, depending on the nature of the error. Only present when error occurs. ")
    user_agent: Optional[StrictStr] = Field(default=None, description="User agent string for client that sent the message.  Allows callers to identify which client sent the origin message (e.g. API Agent, SFE Client, mobile, etc) ", alias="userAgent")
    original_format: Optional[StrictStr] = Field(default=None, description="Indicates the format in which the message was originally sent.  This could have been either: - com.symphony.markdown - Markdown OR Message ML V1 - com.symphony.messageml.v2 - Message ML V2 ", alias="originalFormat")
    disclaimer: Optional[StrictStr] = Field(default=None, description="Message that may be sent along with a regular message if configured for the POD, usually the first message sent in a room that day. ")
    sid: Optional[StrictStr] = Field(default=None, description="Unique session identifier from where the message was created. ")
    replacing: Optional[StrictStr] = Field(default=None, description="Id of the message that the current message is replacing (present only if set)")
    replaced_by: Optional[StrictStr] = Field(default=None, description="Id of the message that the current message is being replaced with (present only if set)", alias="replacedBy")
    initial_timestamp: Optional[StrictInt] = Field(default=None, description="Timestamp of when the initial message has been created in milliseconds since  Jan 1 1970 (present only if set) ", alias="initialTimestamp")
    initial_message_id: Optional[StrictStr] = Field(default=None, description="Id the the initial message that has been updated (present only if set)", alias="initialMessageId")
    silent: Optional[StrictBool] = Field(default=None, description="When false the user/s will receive the message update as unread (true by default)")
    __properties: ClassVar[List[str]] = ["messageId", "parentMessageId", "timestamp", "message", "sharedMessage", "data", "attachments", "user", "stream", "externalRecipients", "diagnostic", "userAgent", "originalFormat", "disclaimer", "sid", "replacing", "replacedBy", "initialTimestamp", "initialMessageId", "silent"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of V4Message from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of shared_message
        if self.shared_message:
            _dict['sharedMessage'] = self.shared_message.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in attachments (list)
        _items = []
        if self.attachments:
            for _item_attachments in self.attachments:
                if _item_attachments:
                    _items.append(_item_attachments.to_dict())
            _dict['attachments'] = _items
        # override the default output from pydantic by calling `to_dict()` of user
        if self.user:
            _dict['user'] = self.user.to_dict()
        # override the default output from pydantic by calling `to_dict()` of stream
        if self.stream:
            _dict['stream'] = self.stream.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of V4Message from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "messageId": obj.get("messageId"),
            "parentMessageId": obj.get("parentMessageId"),
            "timestamp": obj.get("timestamp"),
            "message": obj.get("message"),
            "sharedMessage": V4Message.from_dict(obj["sharedMessage"]) if obj.get("sharedMessage") is not None else None,
            "data": obj.get("data"),
            "attachments": [V4AttachmentInfo.from_dict(_item) for _item in obj["attachments"]] if obj.get("attachments") is not None else None,
            "user": V4User.from_dict(obj["user"]) if obj.get("user") is not None else None,
            "stream": V4Stream.from_dict(obj["stream"]) if obj.get("stream") is not None else None,
            "externalRecipients": obj.get("externalRecipients"),
            "diagnostic": obj.get("diagnostic"),
            "userAgent": obj.get("userAgent"),
            "originalFormat": obj.get("originalFormat"),
            "disclaimer": obj.get("disclaimer"),
            "sid": obj.get("sid"),
            "replacing": obj.get("replacing"),
            "replacedBy": obj.get("replacedBy"),
            "initialTimestamp": obj.get("initialTimestamp"),
            "initialMessageId": obj.get("initialMessageId"),
            "silent": obj.get("silent")
        })
        return _obj

# TODO: Rewrite to not use raise_errors
V4Message.model_rebuild(raise_errors=False)

