# coding: utf-8

"""
    Symphony Profile Manager

    Profile Manager is a microservice to manage users profile and groups

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from symphony.bdk.gen.group_model.transfer_view import TransferView
from typing import Optional, Set
from typing_extensions import Self

class InteractionTransfer(BaseModel):
    """
    InteractionTransfer
    """ # noqa: E501
    target: Optional[StrictStr] = Field(default=None, description="Only TO_MEMBERS supported now")
    update_interaction_ongroup_update: Optional[StrictBool] = Field(default=None, alias="updateInteractionOngroupUpdate")
    system_message_on_interaction: Optional[StrictBool] = Field(default=None, description="Not supported yet", alias="systemMessageOnInteraction")
    transfer_view: Optional[TransferView] = Field(default=None, alias="transferView")
    audit_transfer: Optional[StrictBool] = Field(default=None, alias="auditTransfer")
    __properties: ClassVar[List[str]] = ["target", "updateInteractionOngroupUpdate", "systemMessageOnInteraction", "transferView", "auditTransfer"]

    @field_validator('target')
    def target_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['TO_USER', 'TO_MEMBERS', 'NONE']):
            raise ValueError("must be one of enum values ('TO_USER', 'TO_MEMBERS', 'NONE')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of InteractionTransfer from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of transfer_view
        if self.transfer_view:
            _dict['transferView'] = self.transfer_view.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of InteractionTransfer from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "target": obj.get("target"),
            "updateInteractionOngroupUpdate": obj.get("updateInteractionOngroupUpdate"),
            "systemMessageOnInteraction": obj.get("systemMessageOnInteraction"),
            "transferView": TransferView.from_dict(obj["transferView"]) if obj.get("transferView") is not None else None,
            "auditTransfer": obj.get("auditTransfer")
        })
        return _obj


