# coding: utf-8

"""
    Symphony Profile Manager

    Profile Manager is a microservice to manage users profile and groups

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class ReadMember(BaseModel):
    """
    ReadMember
    """ # noqa: E501
    member_tenant: Optional[StrictInt] = Field(default=None, description="Member's tenant id", alias="memberTenant")
    member_id: Optional[StrictInt] = Field(default=None, description="Member's user id", alias="memberId")
    added_date: Optional[datetime] = Field(default=None, description="Date/time when the member has been added in the group in ISO-8601 format (YYYY-MM-DDThh:mm:ss.sZ)", alias="addedDate")
    status: Optional[StrictStr] = Field(default=None, description="Some group types (e.g. COMPANY) keep disabled users, flagging them as DISABLED. However, this attribute is not relevant for group types (e.g. SDL) that remove (instead of flag) disabled user from group")
    __properties: ClassVar[List[str]] = ["memberTenant", "memberId", "addedDate", "status"]

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['ENABLED', 'DISABLED']):
            raise ValueError("must be one of enum values ('ENABLED', 'DISABLED')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ReadMember from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ReadMember from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "memberTenant": obj.get("memberTenant"),
            "memberId": obj.get("memberId"),
            "addedDate": obj.get("addedDate"),
            "status": obj.get("status")
        })
        return _obj


