# coding: utf-8

"""
    Pod API

    This document refers to Symphony API calls that do not need encryption or decryption of content.  - sessionToken can be obtained by calling the authenticationAPI on the symphony back end and the key manager respectively. Refer to the methods described in authenticatorAPI.yaml. - Actions are defined to be atomic, ie will succeed in their entirety or fail and have changed nothing. - If it returns a 40X status then it will have made no change to the system even if ome subset of the request would have succeeded. - If this contract cannot be met for any reason then this is an error and the response code will be 50X. 

    The version of the OpenAPI document: 20.17.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from symphony.bdk.gen.pod_model.app_authentication_keys import AppAuthenticationKeys
from symphony.bdk.gen.pod_model.app_notification import AppNotification
from symphony.bdk.gen.pod_model.app_property import AppProperty
from symphony.bdk.gen.pod_model.application_info import ApplicationInfo
from typing import Optional, Set
from typing_extensions import Self

class ApplicationDetail(BaseModel):
    """
    Detailed record of application.
    """ # noqa: E501
    application_info: Optional[ApplicationInfo] = Field(default=None, alias="applicationInfo")
    icon_url: Optional[StrictStr] = Field(default=None, description="Url to a icon to use for app. Must start with \"https://\".", alias="iconUrl")
    description: Optional[StrictStr] = Field(default=None, description="Description of the application.")
    allow_origins: Optional[StrictStr] = Field(default=None, description="The permitted domains to send or receive a request from. The field is for the purpose of CORS which set the app specific \"ALLOW-ORIGIN-DOMAINS\" header in HTTP. ", alias="allowOrigins")
    permissions: Optional[List[Annotated[str, Field(min_length=1, strict=True, max_length=64)]]] = Field(default=None, description="List of application permissions provisioned for the application. In addition to the known ones, custom permissions are accepted. A custom permission should only contain upper case alphanumeric characters and underscore. It should not be empty or only contain spaces and its length is limited to 64 characters.  Known permissions:   - SEND_MESSAGES   - GET_USER_CONNECTIONS   - REQUEST_USER_CONNECTIONS   - SET_PRESENCE   - GET_PRESENCE   - GET_BASIC_USER_INFO   - GET_EXTENDED_USER_INFO   - GET_BASIC_CONTACT_INFO   - GET_EXTENDED_CONTACT_INFO   - ACT_AS_USER   - MANAGE_SIGNALS   - MANAGE_USER_FOLLOWING   - TRUST_APP ")
    cert: Optional[StrictStr] = Field(default=None, description="The app public certificate in pem format.")
    authentication_keys: Optional[AppAuthenticationKeys] = Field(default=None, alias="authenticationKeys")
    notification: Optional[AppNotification] = None
    properties: Optional[List[AppProperty]] = Field(default=None, description="Application configuration properties that are shared with the extension application, client side. Do not store sensitive information here. Since SBE 20.14.")
    __properties: ClassVar[List[str]] = ["applicationInfo", "iconUrl", "description", "allowOrigins", "permissions", "cert", "authenticationKeys", "notification", "properties"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ApplicationDetail from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of application_info
        if self.application_info:
            _dict['applicationInfo'] = self.application_info.to_dict()
        # override the default output from pydantic by calling `to_dict()` of authentication_keys
        if self.authentication_keys:
            _dict['authenticationKeys'] = self.authentication_keys.to_dict()
        # override the default output from pydantic by calling `to_dict()` of notification
        if self.notification:
            _dict['notification'] = self.notification.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in properties (list)
        _items = []
        if self.properties:
            for _item_properties in self.properties:
                if _item_properties:
                    _items.append(_item_properties.to_dict())
            _dict['properties'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ApplicationDetail from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "applicationInfo": ApplicationInfo.from_dict(obj["applicationInfo"]) if obj.get("applicationInfo") is not None else None,
            "iconUrl": obj.get("iconUrl"),
            "description": obj.get("description"),
            "allowOrigins": obj.get("allowOrigins"),
            "permissions": obj.get("permissions"),
            "cert": obj.get("cert"),
            "authenticationKeys": AppAuthenticationKeys.from_dict(obj["authenticationKeys"]) if obj.get("authenticationKeys") is not None else None,
            "notification": AppNotification.from_dict(obj["notification"]) if obj.get("notification") is not None else None,
            "properties": [AppProperty.from_dict(_item) for _item in obj["properties"]] if obj.get("properties") is not None else None
        })
        return _obj


